/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz53;
import asposewobfuscated.zz5R;
import asposewobfuscated.zzB8;
import asposewobfuscated.zzFF;
import asposewobfuscated.zzL6;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zzYSS;
import com.aspose.words.zzZ2R;
import com.aspose.words.zzZGP;
import com.aspose.words.zzZPL;
import com.aspose.words.zzZZ6;

public class FormField
extends SpecialChar {
    private zzZZ6 zzZfg;
    private Field zzZff;
    static String zzZfe = zz5R.zzV('\u2002', 5);
    private static final zz53 zzVW = new zz53("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZ6 formFieldPr, zzZ2R runPr) {
        super(doc, '\u0001', runPr);
        this.zzZfg = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZPL zzZPL2) throws Exception {
        FormField formField = (FormField)super.zzZ(bl, zzZPL2);
        ((FormField)super.zzZ(bl, zzZPL2)).zzZfg = (zzZZ6)this.zzZfg.zzAd();
        formField.zzZff = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZGu().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVW.zzX3(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzFF.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZGt().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzL6.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYSS.zzY((zzB8)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZfg.getName();
    }

    public void setName(String value) throws Exception {
        BookmarkStart bookmarkStart;
        BookmarkStart bookmarkStart2;
        zzZ.zzZ((Object)value, "value");
        FormField formField = this;
        if (formField.getField() == null) {
            bookmarkStart2 = null;
        } else {
            BookmarkStart bookmarkStart3 = zzZ.zzZ((Object)formField.getField().getStart().getNextSibling(), BookmarkStart.class);
            if (bookmarkStart3 == null) {
                bookmarkStart3 = zzZ.zzZ((Object)formField.getField().getStart().getPreviousSibling(), BookmarkStart.class);
            }
            bookmarkStart2 = bookmarkStart = bookmarkStart3;
        }
        if (bookmarkStart2 != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZfg.setName(value);
    }

    public int getType() throws Exception {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZWU() throws Exception {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() throws Exception {
        if (this.zzZff == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZff = fieldChar.getField();
            }
        }
        return this.zzZff;
    }

    public String getResult() throws Exception {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz5R.equals(string, zzZfe)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZWT();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzL6.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzR1(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZfg.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZfg.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZfg.zzZWP();
    }

    public void setOwnStatus(boolean value) {
        this.zzZfg.zzWW(value);
    }

    public String getHelpText() {
        return this.zzZfg.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZfg.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZfg.zzZWQ();
    }

    public void setOwnHelp(boolean value) {
        this.zzZfg.zzWX(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZfg.zzZWR();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZfg.zzWY(value);
    }

    public String getEntryMacro() {
        return this.zzZfg.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZfg.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZfg.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZfg.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZfg.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZfg.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZfg.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZfg.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZfg.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZfg.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZfg.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZfg.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzGX(21);
            zzZGP.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZGt());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZfg.zzZWO();
    }

    public void setMaxLength(int value) {
        this.zzZfg.zzL3(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZfg.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZ6 zzZZ62 = this.zzZfg;
        if (zzZZ62.contains(21070)) {
            return this.zzZfg.zzZWI();
        }
        return this.zzZfg.zzZWJ();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZfg.zzL0(value);
    }

    final String zzZWT() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzR1(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzFF.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZ6 zzZZ62 = this.zzZfg;
        if (zzZZ62.contains(21010)) {
            return this.zzZfg.zzZWK();
        }
        return this.zzZfg.zzZWL();
    }

    public void setChecked(boolean value) {
        this.zzZfg.zzWT(value);
    }

    public boolean getDefault() {
        return this.zzZfg.zzZWL();
    }

    public void setDefault(boolean value) {
        this.zzZfg.zzWU(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZfg.zzZWN();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZfg.zzWV(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZfg.zzZWM();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZfg.zzL2(zzZ.zzV(value));
    }

    final zzZZ6 zzZWS() {
        return this.zzZfg;
    }
}

