/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerStatementColumnEncryptionSetting;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.UUID;

final class Column {
    private TypeInfo typeInfo;
    private CryptoMetadata cryptoMetadata;
    private DTV updaterDTV;
    private final DTV getterDTV = new DTV();
    private JDBCType jdbcTypeSetByUser = null;
    private int valueLength = 0;
    private String columnName;
    private String baseColumnName;
    private int tableNum;
    private int infoStatus;
    private SQLIdentifier tableName;
    ColumnFilter filter;

    final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    final void setColumnName(String string) {
        this.columnName = string;
    }

    final String getColumnName() {
        return this.columnName;
    }

    final void setBaseColumnName(String string) {
        this.baseColumnName = string;
    }

    final String getBaseColumnName() {
        return this.baseColumnName;
    }

    final void setTableNum(int n) {
        this.tableNum = n;
    }

    final int getTableNum() {
        return this.tableNum;
    }

    final void setInfoStatus(int n) {
        this.infoStatus = n;
    }

    final boolean hasDifferentName() {
        return 0 != (this.infoStatus & 0x20);
    }

    final boolean isHidden() {
        return 0 != (this.infoStatus & 0x10);
    }

    final boolean isKey() {
        return 0 != (this.infoStatus & 8);
    }

    final boolean isExpression() {
        return 0 != (this.infoStatus & 4);
    }

    final boolean isUpdatable() {
        return !this.isExpression() && !this.isHidden() && this.tableName.getObjectName().length() > 0;
    }

    final void setTableName(SQLIdentifier sQLIdentifier) {
        this.tableName = sQLIdentifier;
    }

    final SQLIdentifier getTableName() {
        return this.tableName;
    }

    Column(TypeInfo typeInfo, String string, SQLIdentifier sQLIdentifier, CryptoMetadata cryptoMetadata) {
        this.typeInfo = typeInfo;
        this.columnName = string;
        this.baseColumnName = string;
        this.tableName = sQLIdentifier;
        this.cryptoMetadata = cryptoMetadata;
    }

    CryptoMetadata getCryptoMetadata() {
        return this.cryptoMetadata;
    }

    final void clear() {
        this.getterDTV.clear();
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    final void initFromCompressedNull() {
        this.getterDTV.initFromCompressedNull();
    }

    void setFilter(ColumnFilter columnFilter) {
        this.filter = columnFilter;
    }

    final boolean isNull() {
        return this.getterDTV.isNull();
    }

    final boolean isInitialized() {
        return this.getterDTV.isInitialized();
    }

    Object getValue(JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        Object object = this.getterDTV.getValue(jDBCType, this.typeInfo.getScale(), inputStreamGetterArgs, calendar, this.typeInfo, this.cryptoMetadata, tDSReader);
        return null != this.filter ? this.filter.apply(object, jDBCType) : object;
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        return (Integer)this.getValue(JDBCType.INTEGER, null, null, tDSReader);
    }

    void updateValue(JDBCType object, Object object2, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection, SQLServerStatementColumnEncryptionSetting sQLServerStatementColumnEncryptionSetting, Integer n2, boolean bl, int n3) throws SQLServerException {
        Object object3;
        Object object4;
        SSType sSType = this.typeInfo.getSSType();
        if (null != this.cryptoMetadata) {
            if (null != object2) {
                if (JDBCType.TINYINT == this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType() && javaType == JavaType.SHORT) {
                    if (object2 instanceof Boolean) {
                        object2 = true == (Boolean)object2 ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    if ((object4 = Short.valueOf((String)(object3 = "" + object2))).shortValue() >= 0 && object4.shortValue() <= 255) {
                        object2 = object4.byteValue();
                        javaType = JavaType.BYTE;
                        object = JDBCType.TINYINT;
                    }
                }
            } else if (object.isBinary()) {
                object = this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType();
            }
        }
        if (null == n && null != this.cryptoMetadata) {
            n = this.cryptoMetadata.getBaseTypeInfo().getScale();
        }
        if (!(null == this.cryptoMetadata || JDBCType.CHAR != object && JDBCType.VARCHAR != object || JDBCType.NVARCHAR != this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType() && JDBCType.NCHAR != this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType() && JDBCType.LONGNVARCHAR != this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType())) {
            object = this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType();
        }
        if (Util.shouldHonorAEForParameters(sQLServerStatementColumnEncryptionSetting, sQLServerConnection)) {
            if (null == this.cryptoMetadata && bl) {
                object3 = new MessageFormat(SQLServerException.getErrString("R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS"));
                object4 = new Object[]{n3};
                throw new SQLServerException(null, ((Format)object3).format(object4), null, 0, false);
            }
            this.setJdbcTypeSetByUser((JDBCType)((Object)object));
            this.valueLength = Util.getValueLengthBaseOnJavaType(object2, javaType, n2, n, (JDBCType)((Object)object));
            if (null != this.cryptoMetadata && (JDBCType.NCHAR == this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType() || JDBCType.NVARCHAR == this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType() || JDBCType.LONGNVARCHAR == this.cryptoMetadata.getBaseTypeInfo().getSSType().getJDBCType())) {
                this.valueLength *= 2;
            }
        } else if (bl) {
            object3 = new MessageFormat(SQLServerException.getErrString("R_ForceEncryptionTrue_HonorAEFalseRS"));
            object4 = new Object[]{n3};
            throw new SQLServerException(null, ((Format)object3).format(object4), null, 0, false);
        }
        if (null != streamSetterArgs) {
            if (!streamSetterArgs.streamType.convertsTo(this.typeInfo)) {
                DataTypes.throwConversionError(streamSetterArgs.streamType.toString(), sSType.toString());
            }
        } else if (null != this.cryptoMetadata) {
            if (JDBCType.UNKNOWN == object && object2 instanceof UUID) {
                javaType = JavaType.STRING;
                object = JDBCType.GUID;
                this.setJdbcTypeSetByUser((JDBCType)((Object)object));
            }
            if (!object.convertsTo((SSType)((Object)(object3 = this.cryptoMetadata.baseTypeInfo.getSSType())))) {
                DataTypes.throwConversionError(object.toString(), sSType.toString());
            }
            if ((object4 = Column.getJDBCTypeFromBaseSSType((SSType)((Object)object3), (JDBCType)((Object)object))) != object) {
                this.setJdbcTypeSetByUser((JDBCType)((Object)object4));
                object = object4;
                this.valueLength = Util.getValueLengthBaseOnJavaType(object2, javaType, n2, n, (JDBCType)((Object)object));
            }
        } else if (!object.convertsTo(sSType)) {
            DataTypes.throwConversionError(object.toString(), sSType.toString());
        }
        if (!(JDBCType.DATETIMEOFFSET != object && JavaType.DATETIMEOFFSET != javaType || sQLServerConnection.isKatmaiOrLater())) {
            throw new SQLServerException(SQLServerException.getErrString("R_notSupported"), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
        if (null != this.cryptoMetadata && sQLServerConnection.sendStringParametersAsUnicode() && (JavaType.STRING == javaType || JavaType.READER == javaType || JavaType.CLOB == javaType)) {
            object = Column.getSSPAUJDBCType((JDBCType)((Object)object));
        }
        if (!(SSType.NCHAR != sSType && SSType.NVARCHAR != sSType && SSType.NVARCHARMAX != sSType && SSType.NTEXT != sSType && SSType.XML != sSType || JDBCType.CHAR != object && JDBCType.VARCHAR != object && JDBCType.LONGVARCHAR != object && JDBCType.CLOB != object)) {
            object = JDBCType.CLOB == object ? JDBCType.NCLOB : JDBCType.NVARCHAR;
        } else if (!(SSType.BINARY != sSType && SSType.VARBINARY != sSType && SSType.VARBINARYMAX != sSType && SSType.IMAGE != sSType && SSType.UDT != sSType || JDBCType.CHAR != object && JDBCType.VARCHAR != object && JDBCType.LONGVARCHAR != object)) {
            object = JDBCType.VARBINARY;
        } else if (!(JDBCType.TIMESTAMP != object && JDBCType.DATE != object && JDBCType.TIME != object && JDBCType.DATETIMEOFFSET != object || SSType.CHAR != sSType && SSType.VARCHAR != sSType && SSType.VARCHARMAX != sSType && SSType.TEXT != sSType && SSType.NCHAR != sSType && SSType.NVARCHAR != sSType && SSType.NVARCHARMAX != sSType && SSType.NTEXT != sSType)) {
            object = JDBCType.NCHAR;
        }
        if (null == this.updaterDTV) {
            this.updaterDTV = new DTV();
        }
        this.updaterDTV.setValue(this.typeInfo.getSQLCollation(), (JDBCType)((Object)object), object2, javaType, streamSetterArgs, calendar, n, sQLServerConnection, false);
    }

    private static JDBCType getSSPAUJDBCType(JDBCType jDBCType) {
        switch (jDBCType) {
            case CHAR: {
                return JDBCType.NCHAR;
            }
            case VARCHAR: {
                return JDBCType.NVARCHAR;
            }
            case LONGVARCHAR: {
                return JDBCType.LONGNVARCHAR;
            }
            case CLOB: {
                return JDBCType.NCLOB;
            }
        }
        return jDBCType;
    }

    private static JDBCType getJDBCTypeFromBaseSSType(SSType sSType, JDBCType jDBCType) {
        switch (jDBCType) {
            case TIMESTAMP: {
                if (SSType.DATETIME == sSType) {
                    return JDBCType.DATETIME;
                }
                if (SSType.SMALLDATETIME == sSType) {
                    return JDBCType.SMALLDATETIME;
                }
                return jDBCType;
            }
            case NUMERIC: 
            case DECIMAL: {
                if (SSType.MONEY == sSType) {
                    return JDBCType.MONEY;
                }
                if (SSType.SMALLMONEY == sSType) {
                    return JDBCType.SMALLMONEY;
                }
                return jDBCType;
            }
            case CHAR: {
                if (SSType.GUID != sSType) break;
                return JDBCType.GUID;
            }
        }
        return jDBCType;
    }

    boolean hasUpdates() {
        return null != this.updaterDTV;
    }

    void cancelUpdates() {
        this.updaterDTV = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.updaterDTV) {
            return;
        }
        try {
            this.updaterDTV.sendCryptoMetaData(this.cryptoMetadata, tDSWriter);
            this.updaterDTV.jdbcTypeSetByUser(this.getJdbcTypeSetByUser(), this.getValueLength());
            this.updaterDTV.sendByRPC(this.baseColumnName, this.typeInfo, null != this.cryptoMetadata ? this.cryptoMetadata.getBaseTypeInfo().getSQLCollation() : this.typeInfo.getSQLCollation(), null != this.cryptoMetadata ? this.cryptoMetadata.getBaseTypeInfo().getPrecision() : this.typeInfo.getPrecision(), null != this.cryptoMetadata ? this.cryptoMetadata.getBaseTypeInfo().getScale() : this.typeInfo.getScale(), false, tDSWriter, sQLServerConnection);
        }
        finally {
            this.updaterDTV.sendCryptoMetaData(null, tDSWriter);
        }
    }

    JDBCType getJdbcTypeSetByUser() {
        return this.jdbcTypeSetByUser;
    }

    void setJdbcTypeSetByUser(JDBCType jDBCType) {
        this.jdbcTypeSetByUser = jDBCType;
    }

    int getValueLength() {
        return this.valueLength;
    }
}

