/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.LocalDate;
import com.microsoft.sqlserver.jdbc.LocalDateTime;
import com.microsoft.sqlserver.jdbc.LocalTime;
import com.microsoft.sqlserver.jdbc.OffsetDateTime;
import com.microsoft.sqlserver.jdbc.OffsetTime;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TVP;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import microsoft.sql.DateTimeOffset;

final class AppDTVImpl
extends DTVImpl {
    private JDBCType jdbcType = JDBCType.UNKNOWN;
    private Object value;
    private JavaType javaType;
    private StreamSetterArgs streamSetterArgs;
    private Calendar cal;
    private Integer scale;
    private boolean forceEncrypt;

    AppDTVImpl() {
    }

    @Override
    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        assert (false);
    }

    @Override
    final void initFromCompressedNull() {
        assert (false);
    }

    @Override
    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection, boolean bl) throws SQLServerException {
        dTV.setValue(object, javaType);
        dTV.setJdbcType(jDBCType);
        dTV.setStreamSetterArgs(streamSetterArgs);
        dTV.setCalendar(calendar);
        dTV.setScale(n);
        dTV.setForceEncrypt(bl);
        dTV.executeOp(new SetValueOp(sQLCollation, sQLServerConnection));
    }

    @Override
    void setValue(Object object, JavaType javaType) {
        this.value = object;
        this.javaType = javaType;
    }

    @Override
    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        this.streamSetterArgs = streamSetterArgs;
    }

    @Override
    void setCalendar(Calendar calendar) {
        this.cal = calendar;
    }

    @Override
    void setScale(Integer n) {
        this.scale = n;
    }

    @Override
    void setForceEncrypt(boolean bl) {
        this.forceEncrypt = bl;
    }

    @Override
    StreamSetterArgs getStreamSetterArgs() {
        return this.streamSetterArgs;
    }

    @Override
    Calendar getCalendar() {
        return this.cal;
    }

    @Override
    Integer getScale() {
        return this.scale;
    }

    @Override
    boolean isNull() {
        return null == this.value;
    }

    @Override
    void setJdbcType(JDBCType jDBCType) {
        this.jdbcType = jDBCType;
    }

    @Override
    JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    Object getValue(DTV dTV, JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, CryptoMetadata cryptoMetadata, TDSReader tDSReader) throws SQLServerException {
        if (this.jdbcType != jDBCType) {
            DataTypes.throwConversionError(this.jdbcType.toString(), jDBCType.toString());
        }
        return this.value;
    }

    @Override
    Object getSetterValue() {
        return this.value;
    }

    final class SetValueOp
    extends DTVExecuteOp {
        private final SQLCollation collation;
        private final SQLServerConnection con;

        SetValueOp(SQLCollation sQLCollation, SQLServerConnection sQLServerConnection) {
            this.collation = sQLCollation;
            this.con = sQLServerConnection;
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            if (JDBCType.DECIMAL == jDBCType || JDBCType.NUMERIC == jDBCType || JDBCType.MONEY == jDBCType || JDBCType.SMALLMONEY == jDBCType) {
                assert (null != string);
                try {
                    dTV.setValue(new BigDecimal(string), JavaType.BIGDECIMAL);
                }
                catch (NumberFormatException numberFormatException) {
                    DataTypes.throwConversionError("String", jDBCType.toString());
                }
            } else if (jDBCType.isBinary()) {
                assert (null != string);
                dTV.setValue(ParameterUtils.HexToBin(string), JavaType.BYTEARRAY);
            } else if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                byte[] byArray = null;
                if (null != string) {
                    try {
                        byArray = string.getBytes(this.collation.getCharset());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                        Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                    }
                }
                dTV.setValue(byArray, JavaType.BYTEARRAY);
            }
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            assert (null != clob);
            try {
                DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), clob.length(), false);
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.con, null, sQLException.getMessage(), null, false);
            }
        }

        @Override
        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (time != null) : "value is null";
                dTV.setValue(time.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (date != null) : "value is null";
                dTV.setValue(date.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (timestamp != null) : "value is null";
                dTV.setValue(timestamp.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, java.util.Date date) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (date != null) : "value is null";
                dTV.setValue(date.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, LocalDate localDate) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (localDate != null) : "value is null";
                dTV.setValue(localDate.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, LocalTime localTime) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (localTime != null) : "value is null";
                dTV.setValue(localTime.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, LocalDateTime localDateTime) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (localDateTime != null) : "value is null";
                dTV.setValue(localDateTime.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, OffsetTime offsetTime) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (offsetTime != null) : "value is null";
                dTV.setValue(offsetTime.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, OffsetDateTime offsetDateTime) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (offsetDateTime != null) : "value is null";
                dTV.setValue(offsetDateTime.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, Calendar calendar) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (calendar != null) : "value is null";
                dTV.setValue(calendar.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (dateTimeOffset != null) : "value is null";
                dTV.setValue(dateTimeOffset.toString(), JavaType.STRING);
            }
        }

        @Override
        void execute(DTV dTV, TVP tVP) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            Integer n;
            if (null != bigDecimal && null != (n = dTV.getScale()) && n.intValue() != bigDecimal.scale()) {
                bigDecimal = bigDecimal.setScale((int)n, 1);
            }
            dTV.setValue(bigDecimal, JavaType.BIGDECIMAL);
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, BigInteger bigInteger) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            assert (null != blob);
            try {
                DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), blob.length(), false);
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.con, null, sQLException.getMessage(), null, false);
            }
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), dTV.getStreamSetterArgs().getLength(), true);
            if (JDBCType.NCHAR == AppDTVImpl.this.jdbcType || JDBCType.NVARCHAR == AppDTVImpl.this.jdbcType || JDBCType.LONGNVARCHAR == AppDTVImpl.this.jdbcType) {
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
                dTV.setValue(inputStreamReader, JavaType.READER);
                this.execute(dTV, inputStreamReader);
            }
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            assert (null != reader);
            JDBCType jDBCType = dTV.getJdbcType();
            long l = DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), dTV.getStreamSetterArgs().getLength(), true);
            if (jDBCType.isBinary()) {
                String string = DDC.convertReaderToString(reader, (int)l);
                if (-1L != l && (long)string.length() != l) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                    Object[] objectArray = new Object[]{l, string.length()};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                }
                dTV.setValue(string, JavaType.STRING);
                this.execute(dTV, string);
            } else if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                ReaderInputStream readerInputStream = null;
                try {
                    readerInputStream = new ReaderInputStream(reader, this.collation.getCharset(), l);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                    Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                }
                dTV.setValue(readerInputStream, JavaType.INPUTSTREAM);
                dTV.setStreamSetterArgs(new StreamSetterArgs(StreamType.CHARACTER, -1L));
                this.execute(dTV, readerInputStream);
            }
        }
    }
}

