/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzVA;
import com.aspose.words.Border;
import com.aspose.words.zzZRQ;
import java.awt.Color;
import java.util.Iterator;

public class BorderCollection
implements Iterable<Border> {
    private zzZRQ zz4R;

    BorderCollection(zzZRQ parent) {
        this.zz4R = parent;
    }

    public Border getByBorderType(int borderType) throws Exception {
        Object v = this.zz4R.getPossibleBorderKeys().get(borderType);
        if (v == null) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        int n = (Integer)v;
        Border border = (Border)this.zz4R.getDirectBorderAttr(n);
        if (border == null) {
            border = new Border(this.zz4R, n);
            this.zz4R.setBorderAttr(n, border);
        }
        return border;
    }

    public Border get(int index) throws Exception {
        int n = (Integer)this.zz4R.getPossibleBorderKeys().getKey(index);
        return this.getByBorderType(n);
    }

    public Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public int getCount() {
        return this.zz4R.getPossibleBorderKeys().getCount();
    }

    public double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zz4R.getPossibleBorderKeys().zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzU2(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zz4R.getPossibleBorderKeys().zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzU2(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public Color getColor() throws Exception {
        BorderCollection borderCollection = this;
        return borderCollection.get(0).zzzq().zzUH();
    }

    public void setColor(Color value) throws Exception {
        zzVA zzVA2 = zzVA.zzZ(value);
        BorderCollection borderCollection = this;
        Iterator iterator = borderCollection.zz4R.getPossibleBorderKeys().zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzU2(n)) continue;
            borderCollection.getByBorderType(n).zzz(zzVA2);
        }
    }

    public double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zz4R.getPossibleBorderKeys().zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzU2(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zz4R.getPossibleBorderKeys().zzEy().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzU2(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public Iterator iterator() {
        return new zzZ(this);
    }

    final boolean isVisible() throws Exception {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzU2(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ
    implements Iterator {
        private BorderCollection zz4B;
        private int zz4A;

        zzZ(BorderCollection borderCollection) {
            this.zz4B = borderCollection;
            this.zz4A = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zz4A >= this.zz4B.getCount() - 1) {
                return false;
            }
            ++this.zz4A;
            return true;
        }

        public final Object next() {
            try {
                return this.zz4B.get(this.zz4A);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

