/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzAK;
import asposewobfuscated.zzT4;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYmO = true;
    private boolean zzGF;
    private String zzYmN;
    private boolean zzYmM;
    private boolean zzYmL = false;
    private boolean zzYmK = true;
    private int zzYmJ = 1;
    private int zzZ5N = 0;
    private IWarningCallback zz6V;
    private int zzFF = 0;
    private String zzYmI = "";
    private boolean zzYmH = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZT0() {
        return false;
    }

    boolean zzZYa() {
        return true;
    }

    final boolean zzZrv() {
        return this.zzYmO;
    }

    public String getTempFolder() {
        return this.zzYmN;
    }

    public void setTempFolder(String value) {
        this.zzYmN = value;
    }

    public boolean getPrettyFormat() {
        return this.zzGF;
    }

    public void setPrettyFormat(boolean value) {
        this.zzGF = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYmM;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYmM = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYmL;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYmL = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYmK;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYmK = value;
    }

    public int getColorMode() {
        return this.zzFF;
    }

    public void setColorMode(int value) {
        this.zzFF = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYmJ;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYmJ = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZ5N;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZ5N = value;
    }

    public String getDefaultTemplate() {
        return this.zzYmI;
    }

    public void setDefaultTemplate(String value) {
        this.zzYmI = value;
    }

    public boolean getUpdateFields() {
        return this.zzYmH;
    }

    public void setUpdateFields(boolean value) {
        this.zzYmH = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz6V;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz6V = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzLK(zzT4.zzj(zzAK.zzXO(fileName))));
    }
}

