//公共参数
let tableTags = "stor_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    storTableInit();
});

//初始化表格
function storTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/ware/searchWareHouseList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                  //是否显示分页（*）
        sortable: false,                    //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",       //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                'site': $('#current_site').val(),
                'warehousetypeDb': 'T',
                'active': $('#status').val(),
                'warehouseid': $('#warehouseid').val(),
                'warehousename': $('#warehousename').val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'warehouseid',
            title: '店铺编号'
        }, {
            field: 'warehousename',
            title: '店铺名称'
        }, {
            field: 'active',
            title: '状态',
            formatter: function (value) {
                if (value == 'Y') {
                    return '启用'
                }
                return '未启用'
            }
        }, {
            field: '-',
            title: '-',
            width: 200
        }, {
            field: '-',
            title: '-',
            width: 200
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '库存信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '库存信息',          //表格工作区名称
            tableName: '库存信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//处理搜索，刷新table
function searchStor() {
    $('#stor_data').bootstrapTable('refresh');
}


// 添加店铺
function addStorModal() {
    $('#stor_modal').modal()
}

// 保存店铺信息 (店铺 = 仓库)
function saveStor() {
    let wareHouse = {
        'site': $('#current_site').val(),
        'warehouseid': $('#wareHouseID').val(),
        'warehousename': $('#wareHouseName').val(),
        'active': $('#active').val(),
        'warehousetypeDb': 'T',
        'wareHousetype': '店仓'
    }
    $.ajax({
        url: '/ware/addWareHouse',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(wareHouse),
        dataType: "json"
    }).done(function (data) {
        // 请求成功
        layer.msg(data.msg)
        if (data.success) {
            $('#storClose').click()
            $('#stor_data').bootstrapTable('refresh')
            cleanStor()
        }
    }).fail(function (jqXHR, textStatus, errorThrown) {
        // net::ERR_CONNECTION_REFUSED 发生时，也能进入
        // alert("请求超时,网络出现问题")
        if (jqXHR.status == 0) {
            layer.alert("网络连接异常:  "+jqXHR.statusText);
            console.info("网络出错");
        }
        if (jqXHR.status == 403) {
            //判断是否是session超时
            layer.alert("用户登录信息过期,请重新登陆", function () {
                window.location.href = "/login";
            });
        }

    });
}

$('#storClose').click(function () {
    cleanStor()
})

function cleanStor() {
    $('#editWareHouseID').val('')
    $('#editWareHouseName').val('')
    $('#editActive').val('Y')
}

// 编辑店铺 modal
function editStorModal() {
    $('#editWareHouseID').val(currentRow.warehouseid)
    $('#editWareHouseName').val(currentRow.warehousename)
    $('#editActive').val(currentRow.active)
    $('#edit_stor_modal').modal()
}

// 编辑店铺
function updateStor() {
    let wareHouse = {
        warehouseid: $('#editWareHouseID').val(),
        warehousename: $('#editWareHouseName').val(),
        active: $('#active').val(),
        site: $('#current_site').val()
    }

    updateWare(wareHouse)


}


// 删除店铺
function removerWare() {
    layer.confirm('确定要删除选中店铺信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
        let wareHouse = {
            site: currentRow.site,
            active: 'N',
            warehouseid: currentRow.warehouseid,
        }
        updateWare(wareHouse)
    }, function () {

    });
}

// 修改
function updateWare(data) {
    $.ajax({
        url: '/ware/updateWareHouse',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(data),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#editStorClose').click()
                $('#stor_data').bootstrapTable('refresh')
                cleanStor()
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
    var result = "";
    if (row > 0 && col == 0)
        debugger;
    result = "\\@";
    return result;
}

// 日期数字格式化
function generateTimeReqestNumber() {
    var date = new Date();
    return date.getFullYear().toString() + pad2(date.getMonth() + 1) + pad2(date.getDate()) + pad2(date.getHours()) + pad2(date.getMinutes()) + pad2(date.getSeconds());
}

function pad2(n) {
    return n < 10 ? '0' + n : n
}