//公共参数
let tableTags = "forwarder_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    forwarderTableInit()
    forwarderDetailTableInit()
});

//初始化表格
function forwarderTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/forwarder/searchForwarderList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                  //是否显示分页（*）
        sortable: false,                    //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",       //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                'site': $('#current_site').val(),
                'warehousetypeDb': 'T',
                'active': $('#status').val(),
                'warehouseid': $('#warehouseid').val(),
                'warehousename': $('#warehousename').val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'forwarderno',
            title: '物流公司编号'
        }, {
            field: 'forwardername',
            title: '物流公司名称'
        }, {
            field: 'active',
            title: '状态',
            formatter: function (value) {
                if (value == 'Y') {
                    return '启用'
                }
                return '未启用'
            }
        }, {
            field: '-',
            title: '-',
            width: 400
        }, {
            field: '-',
            title: '-',
            width: 400
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
            $('#forwarderDetail_data').bootstrapTable('refresh')
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 400;
            $('#' + tableTags).parents('.fixed-table-container').css("height", height_param + "px");
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '物流信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '物流信息',          //表格工作区名称
            tableName: '物流信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//初始化表格
function forwarderDetailTableInit() {
    let forwarderno = currentRow != null ? currentRow.forwarderno : ''
    $('#forwarderDetail_data').bootstrapTable({
        url: '/forwarder/searchForwarderDetailList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        //  toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                  //是否显示分页（*）
        sortable: false,                    //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",       //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                forwarderNo: forwarderno
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'deliveryMethod',
            title: '发货方式',
            width: 200
        }, {
            field: 'logisticsBilling',
            title: '物流单价',
            width: 200,
            align: 'right',
        }, {
            field: 'pickupMethod',
            title: '取货方式',
            width: 200
        }, {
            field: 'tax',
            title: '是否包税',
            width: 200,
            formatter: function (value) {
                if (value == 'Y') {
                    return '包税'
                }
                return '不包税'
            }
        }, {
            field: 'weightLv',
            title: '重量等级',
            width: 200,
            align: 'right'
        }, {
            field: 'status',
            title: '状态',
            formatter: function (value) {
                if (value == 'Y') {
                    return '启用'
                }
                return '未启用'
            }
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 362;
            $('#forwarderDetail_data').parents('.fixed-table-container').css("height", height_param + "px");
        },

    });
}


//处理搜索，刷新table
function searchForwarder() {
    $('#forwarder_data').bootstrapTable('refresh');
}


// 添加店铺
function addForwarderDetail() {

    $('#addForwarderDetail').modal()
}


function saveForwarderDetail() {

    let forwarderDetail = {
        createdBy: "Admin1",
        createdDate: "2021-05-18T15:40:35.000+08:00",
        deliveryMethod: "海运",
        forwarderNo: " 1001",
        logisticsBilling: 47.1,
        pickupMethod: "上门取件",
        status: "Y",
        tax: "Y",
        weightLv: 50,
    }
    $.ajax({
        url: '/ware/addWareHouse',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(forwarderDetail),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#storClose').click()
                $('#stor_data').bootstrapTable('refresh')
                cleanStor()
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}


// 编辑店铺 modal
function editStorModal() {
    $('#edit_stor_modal').modal()
}

// 编辑店铺
function updateStor() {


}


// 删除店铺
function removerWare() {
    layer.confirm('确定要删除选中店铺信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
    }, function () {

    });
}

