/*页面加载完成事件绑定二级li的点击事件*/
$(function(){
	var window_width = $(window).width();
	$(".main-show").css({
		"width": window_width-5,
        "left": 2,
	});
	//给只有二级菜单的li绑定事件负责背景颜色
	$("li.second-li").bind("click", function(){
		$(this).parents("ul.custom-style").find("li").removeClass("active");
		$(this).addClass("active");
	});
	$("ul").on("hide.bs.dropdown", function(){
		return false;
	});
	//失去open后的事件
	$("li.first-li").bind("click", function(){
		$(this).siblings("li.open").find("li").removeClass("active");
		if($(this).hasClass('open')){
			$(this).removeClass("open");
		}else{
			$(this).addClass("open");
		}
	});
	//负责有三级菜单的二级li的图标控制和ul的伸展和塑回
	$("li.dropdown-submenu").bind("click", function(){
		if($(this).hasClass('open')){
			$(this).removeClass("open");
			$(this).removeClass("active");
			$(this).find("ul.second-menu").removeAttr("display");
		}else{
			$(this).addClass("open");
			$(this).find("ul.second-menu").attr("display", "block");
		}
	});
	//数据展示
	$("a.header-show").bind("click", function(){
		var url = $(this).attr("href");
		$.ajax({
	        url: url,
	        type:"GET",
	        data:{},// 你的formid
	        dataType:"Html",
	        success: function (data) {
	        	$(".main-show").html(data);
	        },
	        error: function(data) {
	        	var responseText = data.responseText;
	        	var json_str = JSON.parse(responseText);
	        	var status = json_str.status;
	        	var message = json_str.message;
	        	//判断是否是session超时
	        	if(403==status){
	        		layer.alert(message,function(){
	        			window.location.href="/login";
	        		});
	        	}
	        	layer.closeAll('loading');
	        }
	    })
		return false;
		
	});
});

/* 停止隐藏ul */
function stop(){
	 event.stopPropagation();
}


//展示修改密码模态框
function editPasswordPage(){
	$("#first_password").val("");
	$("#confirm_password").val("");
	$("#user_password").modal();
}

//密码修改验证
$("input.checkedPassword").bind("blur",function(){
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if(first_password==""){
		layer.msg("密码不能为空！");
		return false;
	}
	if(confirm_password==""){
		layer.msg("确认密码不能为空！");
		return false;
	}
	if(confirm_password!=first_password){
		layer.msg("确认密码和密码必须相同！");
		return false;
	}
});

//提交使用
function checkedPassword(){
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if(first_password==""){
		layer.msg("密码不能为空！");
		return false;
	}
	if(confirm_password==""){
		layer.msg("确认密码不能为空！");
		return false;
	}
	if(confirm_password!=first_password){
		layer.msg("确认密码和密码必须相同！");
		return false;
	}
}

//修改密码
function passwordSave(){
	checkedPassword();
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if (first_password==''){
		layer.msg("新密码不能为空");
		return false;
	}
	if (confirm_password==''){
		layer.msg("重复密码不能为空");
		return false;
	}
	$.ajax({
        url: "/user/passwordSave",
        type:"POST",
        data:{"id": $("#current_id").val(),
        	  "password": first_password,
        	  "confirm_password": confirm_password 
        	  },// 你的formid
        dataType:"JSON",
        success: function (data) {
               if (data.success) {
				layer.msg(data.msg);
				$("#password_cancel").click();
				window.location.href="/login";
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//清除输入内容
function clear(){
	//初始化信息
	$("#username").val("");
	$("#display").val("");
	$("#password").val("");
   	$("#user_des").val("");
   	$("#id").val("0");
 	$("#user_status").val("0");
}

//修改用户页面
function editUserPage(){
	clear();
	var id = $("#current_id").val();
	var username = $("#current_username").val();
	var display = $("#current_display").val();
	$("#operate_username").val(username);
   	$("#operate_display").val(display);
   	$("#operate_id").val(id);
   	//显示隐藏的数据
   	$("#operate_user_modal").modal();
}

//用户的更新和新增
function operateUserSave(){
	var username = $.trim($("#operate_username").val());
   	var display = $.trim($("#operate_display").val());
	if (username=="") {
		layer.msg("请输入用户账号!");
		return false;
	}
	if (display=="") {
		layer.msg("请输入用户名称!");
		return false;
	}
	layer.load(2);
	/**
	 * 保存数据
	 */
	$.ajax({
        url: "/user/operateUserSave",
        type:"POST",
        data:$('#operate_user_form').serialize(),// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				clear();
				$("#operate_user_cancel").click();
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

//获取当天日期时间
function getNowFormatDate() {
    var date = new Date();
    var seperator1 = "-";
    var seperator2 = ":";
    var month = date.getMonth() + 1;
    var strDate = date.getDate();
    if (month >= 1 && month <= 9) {
        month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
        strDate = "0" + strDate;
    }
    var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
            + " " + date.getHours() + seperator2 + date.getMinutes()
            + seperator2 + date.getSeconds();
    return currentdate;
}

//获取当天日期时间
function getNowFormatYMDHm() {
    var date = new Date();
    var seperator1 = "-";
    var seperator2 = ":";
    var month = date.getMonth() + 1;
    var strDate = date.getDate();
    var hour = date.getHours();
    var minutes = date.getMinutes();
    if (month >= 1 && month <= 9) {
        month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
        strDate = "0" + strDate;
    }
    if (hour >= 0 && hour <= 9){
    	hour = "0" + hour;
    }
    if (minutes >= 0 && minutes <= 9){
    	minutes = "0" + minutes;
    }
    var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
            + " " + hour + seperator2 + minutes;
    return currentdate;
}

//获取当天日期时间
function getNowDate() {
	var nowDate = new Date();
	 var year = nowDate.getFullYear();
	 var month = nowDate.getMonth() + 1 < 10 ? "0" + (nowDate.getMonth() + 1)
	  : nowDate.getMonth() + 1;
	 var day = nowDate.getDate() < 10 ? "0" + nowDate.getDate() : nowDate
	  .getDate();
	 var dateStr = year + "-" + month + "-" + day;
	 return dateStr;
}
