//定制模态框的参数
let currentModalId = 0;
let currentSearchCon = '';
let customerTableUrl = '';//table请求的url
let tableColumns = '';//table的列集合
let customerTableColumns = '';//table的列数组
let customerTableWidth = 0;//定制table的宽度
let customerTableHeight = 0;//定制table的高度
let customerTableTop = 0;//定制table距离顶部div的高度
let customerTableBottom = 0;//定制table距离底部div的高度
let customerSearchDivWidth = 0;
let customerSearchDivHeight = 0;
let customerSearchDivTop = 0;
let customerSearchDivBottom = 0;
let customerSearchDivColumns;//定制模态框查询的列
let customerSqlColumnMap;//查询数据的字段
let customerSqlConFlag = "N";//查询数据的标记
let customerSearchConFlag = 'N';//查询div的标记
let customerReturnField;//定制table的返回字段
let selectDataFlag = 'N';//是否选择好数据的标记
let customerModalData;
let customerReturnData;//负责接收换回的数据
/*$(function(){
	全局时间选择器
	$(".date-pickers").datetimepicker({//日期选择器
		format : 'hh:ii',//显示格式
		maxView : 0,//最高能展示的时间,Number, String类型  默认值：4, 年
		minView : 2,//日期时间选择器所能够提供的最精确的时间选择视图 
		autoclose : true,//选择后自动关闭
		todayBtn : true,//开启选择今天的按钮
		todayHighlight: true,//今天日期高亮显示 如果为true, 高亮当前日期。Boolean类型 ,默认值：false ,
		language : 'zh-CN'//语言选择中文
	});

	//时间选择器 时:分
	lay('.time-pickers').each(function(){
	  laydate.render({
		elem: this
		,type: 'time'
	    ,format: 'H:mm'
		,trigger: 'click'
	  });
	});
});*/
//公共方法
// 获取选择格式的时间 + n天
function getStringTimeByNow(AddDay, separator){
	let date = new Date();
	date.setDate(date.getDate()+AddDay);
    let year = date.getFullYear();
    let month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1;
    let day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate();
    return year + separator + month + separator + day;
}

//获取指定日期的字符串日期
function getStringTimeByStartDay(startDay, AddDay, separator){
	let date = new Date(startDay.replace(/-/g,'/'));
	date.setDate(date.getDate()+AddDay);
    let year = date.getFullYear();
    let month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1;
    let day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate();
    return year + separator + month + separator + day;
}

//获取时间段数据
function getStringPeriodByStartDay(startDay, AddDay, separator){
	let date = new Date(startDay.replace(/-/g,'/'));
	date.setDate(date.getDate()+AddDay);
    let year = date.getFullYear();
    let month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1;
    let day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate();
    let hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
    let minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
    return year + separator + month + separator + day + " " + hours + ":" + minutes;
}

//获取只到分钟的字符串
function getStringToMinuteByNow(AddDay, separator){
	let date = new Date();
	date.setDate(date.getDate()+AddDay);
    let year = date.getFullYear();
    let month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1;
    let day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate();
    let hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
    let minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
    return year + separator + month + separator + day + " " + hours + ":" + minutes;
}

//比较字符串的日期
function compareStringTime(startDay, endDay){
	let start_date = new Date(startDay.replace(/-/g,'/'));
	let end_date = new Date(endDay.replace(/-/g,'/'));
    if(start_date.getTime() > end_date.getTime()){
    	 return false;
    }else{
    	 return true;
    }
}

//获取时间格式（年月日时分）
function getStringTimeWithHours(strDate, addHours, separator){
	let date = new Date();
	if(null != strDate){
		date = new Date(strDate.replace(/-/g,'/'));
	}
	//判断是否转时间
	let milliSeconds = parseInt((addHours*60*60*1000).toFixed(0));
	date.setTime(date.getTime() + milliSeconds);
    let year = date.getFullYear();
    let month =  date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1;
    let day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate();
    let hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours();
    let minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes();
    return year+separator+month+separator+day+" "+hours+":"+minutes;
}

//获取当天日期时间
function getNowDate() {
	let date = new Date();
	let seperator1 = "-";
	let seperator2 = ":";
	let month = date.getMonth() + 1<10? "0"+(date.getMonth() + 1):date.getMonth() + 1;
	let strDate = date.getDate()<10? "0" + date.getDate():date.getDate();
	let hours = date.getHours()<10? "0" + date.getHours():date.getHours();
	let minutes = date.getMinutes()<10? "0" + date.getMinutes():date.getMinutes();
	let seconds = date.getSeconds()<10? "0" + date.getSeconds():date.getSeconds();
	let currentdate = date.getFullYear() + seperator1  + month  + seperator1  + strDate
			+ " "  + hours  + seperator2  + minutes;
	return currentdate;
}

//获取当前时间，格式YYYY-MM-DD
function getNowFormatDate() {
    let date = new Date();
    let seperator1 = "-";
    let year = date.getFullYear();
    let month = date.getMonth() + 1;
    let strDate = date.getDate();
    if (month >= 1 && month <= 9) {
        month = "0" + month;
    }
    if (strDate >= 0 && strDate <= 9) {
        strDate = "0" + strDate;
    }
    let currentdate = year + seperator1 + month + seperator1 + strDate;
    return currentdate;
}

/*通过不同的参数个数来实现方法的重载*/
function getStringTime(startDay, AddDay, separator){
	if(arguments.length == 2){
		return getStringTimeByNow(startDay, AddDay);
	}else if(arguments.length == 3){
		return getStringTimeByStartDay(startDay, AddDay, separator);
	}
    str = str+day;
    return str;
}

//格式化Linux时间戳
function formatLinuxDate(value) {
    if (value && value!='') {
        let date = new Date(value);
        let month =  date.getMonth() < 9 ? '0'+(date.getMonth()+1):date.getMonth()+1;
        let days = date.getDate() <= 9 ? '0' +date.getDate() : date.getDate();
        let hours = date.getHours()<= 9 ? '0' +date.getHours() : date.getHours();
        let minutes = date.getMinutes() <= 9 ? '0' +date.getMinutes() : date.getMinutes();
        let seconds = date.getSeconds() <= 9 ? '0' +date.getSeconds() : date.getSeconds();
        let datestring = date.getFullYear() + "-" + month + "-" + days+" "+hours+":"+minutes;
        return datestring;
    }
    return "";
}

//判断当前输入的时间是否是一整天
function whetherAllDay(strDay){
	//判断是否是空值 空字符串
	if(null == strDay || '' == strDay){
		return false;
	}
	//获取全部日期对应的数据
	let str_date = new Date(strDay.replace(/-/g,'/'));
	//获取整天对应的数据
	let all_day = new Date(strDay.substring(0, 10).replace(/-/g,'/'));
	//判断数值是否相同
    //if(str_date.getTime() == all_day.getTime()){
	if(str_date - all_day == 0){
    	return true;
    }else{
    	return false;
    }
}

//处理集合的参数
function processColumnArray(){
	//初始化数组
	customerTableColumns = new Array();
	//循环处理数据
	for(let i = 0; i < tableColumns.length; i++){
		let tempRow = tableColumns[i];
		let columnFormatter = tempRow.columnFormatter;
		if(null == columnFormatter || 'null' == columnFormatter || '' == columnFormatter){
			//let currentRow = ;
			customerTableColumns.push({
				field: tableColumns[i].tableColumn, 
				title: tableColumns[i].columnDesc, 
				width: parseInt(tempRow.columnWidth),
				valign: 'middle',
                align: 'center',
				});
		}else{
			let currentRow = {field: tempRow.tableColumn, title: tempRow.columnDesc, valign: 'middle',
					align: 'center', width: parseInt(tempRow.columnWidth), formatter: tempRow.columnFormatter};
			customerTableColumns.push(currentRow);
		}
	}
}

//处理查询条件的map
function processCustomerSqlCon(row, sqlColumns){
	customerSqlColumnMap = {};
	//循环处理map数据
	for(let i = 0; i < sqlColumns.length; i++){
		let key = sqlColumns[i];
		let tempValue = row[key];
		customerSqlColumnMap[key] = tempValue;
	}	
	//填充是否解析map的标记
	customerSqlColumnMap.sqlConFlag = "Y";
	//填充开发人员自定义的查询的sql
	customerSqlColumnMap.searchCon = currentSearchCon;
	//设置modalId
	customerSqlColumnMap.modalId = currentModalId;
}

//处理查询div样式
function processCustomerSearchDiv(rows){
	let tags = '';
	//循环产生div
	for(let i = 0; i < rows.length; i++){
		let row = rows[i];
		tags+='<span class="customer-modal-span">' + row.searchColumnDesc + ':</span>';
		tags+='<input id="' + row.searchColumnId+ '" class="customer-modal-input" value="'
		+ row.searchColumnDefault + '" style="width:' + row.searchColumnWidth + 'px;">';
	}
	//设置div
	$('#customer_page_con_div').html(tags);
}

//处理定制表格的列名以及相关的参数
function processCustomerModal(modalId, row){
	$.ajax({
        url: "/modal/processCustomerModal",
        type: "POST",
        async: false,
        contentType: 'application/x-www-form-urlencoded',
        data: {"site": $("#current_site").val(),
        		"modalId": modalId},
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
            	   let obj = data.obj;
            	   //设置modal的参数
            	   customerTableUrl = obj.modalUrl;//table请求的url
            	   $('.customer-legend').html(obj.modalLegend);
            	   //table的样式
            	   customerTableWidth = obj.tableWidth;
            	   customerTableHeight = obj.tableHeight;
            	   customerTableTop = obj.tableTop;
            	   customerTableBottom = obj.tableBottom;
            	   //查询页面的样式
            	   customerSearchDivWidth = obj.pageSearchWidth;
            	   customerSearchDivHeight = obj.pageSearchHeight;
            	   customerSearchDivTop = obj.pageSearchTop;
            	   customerSearchDivBottom = obj.pageSearchBottom;
            	   //目前仅设置高度的样式
            	   $('#customer_page_con_div').css('height', customerSearchDivHeight+"px");
            	   customerReturnField = obj.returnField;
            	   customerSqlConFlag = obj.sqlConFlag;
            	   customerSearchConFlag = obj.pageConFlag;
            	   //设置样式
            	   $('#custom_form').parents('.modal-dialog').css("width", obj.modalWidth+"px");
            	   $('#customer_table_div').css('margin-top', customerTableTop+"px");
            	   $('#customer_table_div').css('margin-bottom', customerTableBottom+"px");
            	   tableColumns = obj.tableColumns;
            	   //处理集合，整理成当前table的列
            	   processColumnArray();
            	   //判断是否继续处理查询条件的赋值
            		if("Y" == customerSqlConFlag){
            			//处理查询的数据（填充查询条件）
            			processCustomerSqlCon(row, obj.sqlColumns);
            		}
            		//处理查询div的输入框
            		$('#customer_page_con_div').html('');
            		if("Y" == customerSearchConFlag){
            			processCustomerSearchDiv(obj.searchColumns);
            			customerSearchDivColumns = obj.searchColumns;
            		}
            	   
			}
        },
        error: function(data) {
        	let responseText = data.responseText;
        	let json_str = JSON.parse(responseText);
        	let status = json_str.status;
        	let message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//添加页面的查询值到map中
function addSearchDivParams(){
	let rows = customerSearchDivColumns;
	//循环处理数据
	for(let i = 0; i < rows.length; i < i++){
		let row = rows[i];
		let key = row.sqlColumnId;
		let value = $.trim($('#'+ row.searchColumnId).val());
		customerSqlColumnMap[key] = value;
	}
}

//初始化定制的modal
function customerTableInit(){
	$('#customer_modal_table').bootstrapTable({
        url: customerTableUrl,         //请求后台的URL（*）
        method: 'POST',                      //请求方式（*）
        contentType:'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType : "undefined",   //排序方式
        queryParams: function queryParams(params) { 
        	//设置查询参数
            let param = {
            };
            //添加页面上的查询条件
            if('Y' == customerSearchConFlag){
            	 addSearchDivParams();
            }
            //覆盖
            param = customerSqlColumnMap;
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut:1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                      //是否显示父子表
        columns: customerTableColumns,
        onPostHeader: function(){
        	$('#customer_modal_table').parents('.fixed-table-container').css("height", customerTableHeight+"px");
        },
        onPostBody: function(data){
        	$('#customer_modal_table').parents('.fixed-table-container').css("height", customerTableHeight+"px");
        },
        onLoadSuccess: function (data){
        	$('#customer_modal_table').parents('.fixed-table-container').css("height", customerTableHeight+"px");
		},
		onDblClickRow: function(row, $element, field){
			//获取数据
			if(null == customerReturnField || "null" == customerReturnField || "" == customerReturnField){
				customerReturnData = row;
			}else{
				customerReturnData = row[customerReturnField];
			}
			//设置取到数据
			selectDataFlag = 'Y';
			//隐藏模态框
			$('#hide_customer_modal').click();
		}
    });
}

//处理通用table(modalId: modal的编号 row: 查询数据的row searchCon：另外的查询条件)
function customerModal(modalId, row, searchCon){
	//覆盖原来的参数
	currentModalId = modalId;
	currentSearchCon = searchCon;
	//1.处理查询的table的列名和url
	processCustomerModal(modalId, row);
	//2.先销毁表格
	$('#customer_modal_table').bootstrapTable('destroy');
	//3.加载表格数据
	console.log(customerTableColumns);
	customerTableInit();
	//展示模态框
	$('#customer_modal').modal();
}

//刷新table的数据
function refreshCustomerTable(){
	$('#customer_modal_table').bootstrapTable('refresh');
}

//卷的打印单个标签通用方法
function printSingleLabel(row){
	$("#iframe_for_print").attr("src", '/print/getPrintDataWithCondition?searchStr=' + escape(JSON.stringify(row)));
}

//卷批量打印的方法
function batchPrintLabel(row){
	$("#iframe_for_print").attr("src", '/print/batchPrintLabel?searchStr=' + escape(JSON.stringify(row)));
}

//通用的按钮控制方法
function customerBtnControl(tableTags, row, statusCode){
	//判断是会否选中行
	if(row == null || "" == row){
		$("button.control-btn").prop("disabled", true);
	}else{
		$("button.control-btn").prop("disabled", false);
	}
	//根据不同的状态码设置不同的参数
	if("deleted" == statusCode){
		$("button.control-btn").prop("disabled", true);
	}
	//判断是否存在rows
	let rows = $('#'+tableTags).bootstrapTable("getData");
	let len = rows.length;
	//不存在数据则禁用所有的按钮
	if(len == 0){
		$("button.control-btn").prop("disabled", true);
	}else{
		//释放下载
		$("#download_button").prop("disabled", false);
	}
	
}

/*判断终端是手机还是电脑--用于判断文件是否导出(电脑需要导出)*/
function phoneOrPc(){
	var sUserAgent = navigator.userAgent.toLowerCase();  
	var bIsIpad = sUserAgent.match(/ipad/i) == "ipad";  
	var bIsIphoneOs = sUserAgent.match(/iphone os/i) == "iphone os";  
	var bIsMidp = sUserAgent.match(/midp/i) == "midp";  
	var bIsUc7 = sUserAgent.match(/rv:1.2.3.4/i) == "rv:1.2.3.4";  
	var bIsUc = sUserAgent.match(/ucweb/i) == "ucweb";  
	var bIsAndroid = sUserAgent.match(/android/i) == "android";  
	var bIsCE = sUserAgent.match(/windows ce/i) == "windows ce";  
	var bIsWM = sUserAgent.match(/windows mobile/i) == "windows mobile";  
	if (bIsIpad || bIsIphoneOs || bIsMidp || bIsUc7 || bIsUc || bIsAndroid || bIsCE || bIsWM) {  
		return false;  
	} else {  
	    return true; 
	}  
}


//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
	var result = "";
	if (row > 0 && col == 0)
		debugger;
	result = "\\@";
	return result;
}

// 日期数字格式化
function generateTimeReqestNumber() {
	var date = new Date();
	return date.getFullYear().toString() + pad2(date.getMonth() + 1) + pad2(date.getDate()) + pad2(date.getHours()) + pad2(date.getMinutes()) + pad2(date.getSeconds());
}

function pad2(n) {
	return n < 10 ? '0' + n : n
}

// 时间搜索框
function InfoDate(date){
//	var default_date = getNowFormatDate();
//	$("#"+date).val(default_date);
	$.fn.datetimepicker.dates['zh-CN'] = {
		days: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六", "星期日"],
		daysShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六", "周日"],
		daysMin:  ["日", "一", "二", "三", "四", "五", "六", "日"],
		months: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
		monthsShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
		today: "今天",
		suffix: [],
		meridiem: ["上午", "下午"]
	};
	//初始化模态框的日期
	$("#"+date).datetimepicker({
		format : 'yyyy-mm-dd',//显示格式
		startView: "month", //初始化视图是‘年’
		maxView : 4,//最高能展示的时间,Number, String类型  默认值：4, 年
		minView : 'year',//日期时间选择器所能够提供的最精确的时间选择视图
		autoclose : true,//选择后自动关闭
		todayBtn : true,//开启选择今天的按钮
		todayHighlight: true,//今天日期高亮显示 如果为true, 高亮当前日期。Boolean类型 ,默认值：false ,
		language : 'zh-CN'//语言选择中文
	});
}


// 判断 是否是数字
function myIsNaN(value) {
	return typeof value === 'number' && !isNaN(value);
}



