//公共参数
var authTrees;//权限树结构
var currentPageStatus = 'Y';//原页面是否打开

//获取权限树结构
function getAuthTree(){
	$.ajax({
      url: "/base/getMenuTreesByUsername",
      type: "POST",
      async: false,
      data: {"username": $("#current_username").val()},// 你的formid
      dataType: "JSON",
      success: function (data) {
      if (data.success) {
    	  authTrees = data.rows;
      	}else{
      		authTrees = new Array();
      		layer.msg('查无菜单!');
      	}
      },
      error: function(data) {
      	var responseText = data.responseText;
      	var json_str = JSON.parse(responseText);
      	var status = json_str.status;
      	var message = json_str.message;
      	//判断是否是session超时
      	if(403==status){
      		layer.alert(message,function(){
      			window.location.href="/login";
      		});
      	}
      	layer.closeAll('loading');
      }
  });
}

//初始化树结构
function initAuthTree(){
	//权限的标签
	var authTags = '';
	//循环处理标签
	for(var i = 0; i < authTrees.length; i++){
		//处理标签逻辑
		authTag = processAuthTags(authTrees[i]);
		authTags += authTag;
	}
	//替换标签	
	$("#main-nav").html(authTags);
}

//处理权限的菜单
function processAuthTags(authTree){
	//公共参数
	var id = authTree.id;
	var fontLabel = authTree.fontLabel;
	var url = authTree.url;
	var name = authTree.name;
	var menuSet = authTree.menuSet;
	var authTag = '';
	var haveChild = authTree.haveChild;
	var newTab = authTree.newTab;
	var showMark = authTree.showMark;//是否显示菜单
	var showClass = "show-menu";
	if('Y' == showMark){
		showClass = "show-menu";
	}else{
		showClass = "hide-menu";
	}
	//不同等级的class不同
	if('Y' == haveChild){
		authTag = '<li class="first-li '+ showClass + '">';
	}else{
		authTag = '<li class="second-li '+ showClass + '">';
	}
	//判断是否存在子级
	if('Y' == haveChild){
		authTag += '<a href="#' + menuSet + '" class="nav-header collapsed" data-toggle="collapse">';
		//添加字体图标
		authTag += '<i class="' + fontLabel + '"></i>' + name;
		//添加向下的按钮
		authTag += '<span class="pull-right glyphicon glyphicon-chevron-toggle"></span>';
	}else{
		//判断是否是需要另外弹出页面的菜单
		if("Y" == newTab){
			authTag += '<a href="' + url + '" class="tab-show '+ showClass +'" newTab="Y" target="_blank" id="' + id + '">';
		}else{
			authTag += '<a href="' + url + '" class="tab-show '+ showClass + '" id="' + id + '">';
		}
		//添加字体图标
		authTag += '<i class="' + fontLabel + '"></i>' + name;
	}
	//a标签结束
	authTag += '</a>';
	//当存在子级的时候添加子级的内容(拼接子级内容)
	if('Y' == haveChild){
		var subNodes = authTree.subNodes;
		for(var i = 0; i < subNodes.length; i++){
			var subNode = subNodes[i];
			//第一个添加标记
			if(i == 0){
				authTag += '<ul id="' + menuSet + '" class="nav nav-list custom-style collapse">';	
			}
			//中间拼写标签
			var subNodeTag = processAuthTags(subNode);
			authTag += subNodeTag; 
			//最后添加标记
			if(i == subNodes.length - 1){
				authTag += '</ul>';
			}
		}
	}
	//最后填充li结束
	authTag += '</li>';
	return authTag;
}

//初始化homePage
function initHomePage(){
	//加载新的页签
	//1.加载心的页签
	$('#main-tabs').append('<li id="tab_home" class="active"><a data-toggle="tab" ' 
			+ 'href="#tab_content_home">首页</a></li>');
	//2.加载新的iframe
	$('.tab-content').append('<div id="tab_content_home" class="active" style="">'
			+ '<iframe id="iframeTabHome" name="iframepage" frameborder="0" scrolling="no"'
			+ 'src="/home"></iframe></div>');
	//重置iframe的高度和宽度
	resetIframeWidthAndHeight();
	return false;
}

//给只有一级菜单级菜单的li绑定事件负责背景颜色
function bindFirstClick(){
	$("li.first-li > a").bind("click", function(){
		if($(this).hasClass('active')){
			$(this).removeClass("active");
		}else{
			$(this).addClass("active");
		}
	});
}

//给只有二级菜单的li绑定事件负责背景颜色
function bindSecondClick(){
	$("li.second-li > a").bind("click", function(){
		$("li.second-li").find("a").removeClass("active");
		if(!$(this).hasClass('active')){
			$(this).addClass("active");
		}
	});
}

//数据展示绑定事件
function bindMenuClick(){
	//数据展示
	$("a.tab-show").bind("click", function(){
		//当前的url
		var content_url = $(this).attr("href");
		var tab_id = "tab-"+$(this).attr("id");
		var tab_text = $.trim($(this).text());
		var tab_content_id = "tab-content-"+$(this).attr("id");
		var newTab = $(this).attr("newTab");
		//填充页签
		if('Y' == newTab){
			getPageStatus($(this).attr("id"));
			if("Y" == currentPageStatus){
				layer.msg('请先关闭车间工作平台页签!');
			}else{
				//重置标记
				currentPageStatus = 'Y';
				//打开或者刷新页面
				window.open(content_url, '车间工作平台');	
			}
		}else{
			openTabLabel(tab_id, tab_content_id, tab_text, content_url, false);
		}
		return false;
	});
}

/*页面加载完成事件绑定二级li的点击事件*/
$(function(){
	//初始化权限数据
	getAuthTree();
	//初始化树结构
	initAuthTree();
	var window_width = $(window).width();
	$(".main-show").css({
		"width": window_width-5,
        "left": 2,
	});
	//初始化page页面
	initHomePage();
	//加载一级权限点击事件
	bindFirstClick();
	//加载二级权限的事件
	bindSecondClick();
	//加载菜单的点击事件
	bindMenuClick();
});

//打开页签加载内容
function openTabLabel(tab_id, tab_content_id, tab_text, content_url, innerTab){
	//判断是否已经打开过了
	if($('#main-tabs #' + tab_id).length > 0){
		//如果存在当前的页签则直接显示
		$('#main-tabs #' + tab_id + ' a').tab('show');
	}else{
		//不隐藏下划线
		$('#main-tabs').removeClass('none-topline');
		//加载新的页签
		//1.隐藏当前的所有的页签
		$('#main-tabs > li').removeClass('active');
		//2.加载心的页签
		$('#main-tabs').append('<li id=' +tab_id +' class="active"><a data-toggle="tab" ' 
				+ 'href="#' + tab_content_id +'">'+ tab_text 
				+ '<i class="fa fa-times" aria-hidden="true"></i></a></li>');
		//3.隐藏显示的iframe
		$('.tab-content > div').removeClass('active');
		//4.加载新的iframe
		$('.tab-content').append('<div id="' + tab_content_id + '" class="active" style="">'
				+ '<iframe id="iframe' + tab_content_id + '" name="iframepage"'
				+'style="" frameborder="0" scrolling="no" src="' + content_url 
				+ '"></iframe></div>');
	}
	//重置iframe的高度和宽度
	resetIframeWidthAndHeight();
	//绑定移除事件
	addRemoveFuntion(tab_id)
	return false;
};

//绑定移除事件
function addRemoveFuntion(tabId){
	$('#'+tabId).find('i.fa.fa-times').bind('click', function(){
		var tabId = $(this).parents('li').attr('id');
		var resourceCode = tabId.substring(4);
		removeTabLabel(resourceCode);
	});
	return false;
}

//初始化计算合高度
function resetIframeWidthAndHeight(){
	//可视区域的宽度和高度
	var width = $(window).width();
	var height = $(window).height();
	//左侧侧边栏的宽度
	var leftNavWidth = $("#main-nav").width();
	//右侧的nav高度
	var rightNavHeight = $("#right-nav").height();
	//页签的高度
	var tabHeight = $("#main-tabs").height();
	//计算iframe的宽度和高度
	var iframeWidth = width - leftNavWidth - 5;
	var iframeHeight = height - rightNavHeight - tabHeight - 34;
	//重置高度和宽度
	$("iframe").css("width", iframeWidth + "px");
	$("iframe").css("height", iframeHeight +"px");
	return false;
}

//根据resourceCode移除
function removeTabLabel(resourceCode){
	//获取当前resourceCode标签
	var tabId = "tab-" + resourceCode;
	var tabContentId = "tab-content-" + resourceCode;
	//1.移除页签
	$('#' + tabId).remove();
	//2.移除页签iframe
	$('#' + tabContentId).remove();
	//判断是否存在最后一个标签
	var tabSize = $('#main-tabs').find('li').length;
	if(1 == tabSize){
		//不用管了 不存在子级的元素了
		$('#main-tabs #tab_home a').tab('show');
	}else{
		var lastTabId = $('#main-tabs').find('li:last').attr('id');
		var resourceCode = lastTabId.substring(4);
		var lastTabContentId = 'tab-content-' + resourceCode;
		//当前的最后一个显示
		$('#main-tabs #' + lastTabId + ' a').tab('show');
		//$('#' + lastTabId).addClass('active');
		//$('#' + lastTabContentId).addClass('active');
	}
}

//展示修改密码模态框
function editPasswordPage(){
	$("#first_password").val("");
	$("#confirm_password").val("");
	$("#user_password").modal();
}

/*//密码修改验证
$("input.checkedPassword").bind("blur",function(){
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if(first_password==""){
		layer.msg("密码不能为空！");
		return false;
	}
	if(confirm_password==""){
		layer.msg("确认密码不能为空！");
		return false;
	}
	if(confirm_password!=first_password){
		layer.msg("确认密码和密码必须相同！");
		return false;
	}
});*/
function editPasswordPage(){
	$("#first_password").val("");
	$("#confirm_password").val("");
	$("#user_password").modal();
}
//修改密码
function savePassword(){
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if(first_password==""){
		layer.msg("密码不能为空！");
		return false;
	}
	if(confirm_password==""){
		layer.msg("确认密码不能为空！");
		return false;
	}
	if(confirm_password!=first_password){
		layer.msg("确认密码和密码必须相同！");
		return false;
	}
	$.ajax({
        url: "/user/uodatasetpassword",
        type:"POST",
        data:{"id": $("#current_id").val(),
        	  "password": first_password,
        	  "confirmpassword": confirm_password
        	  },// 你的formid
        dataType:"JSON",
        success: function (data) {
               if (data.success) {
				layer.msg(data.msg);
				$("#password_cancel").click();
				if (data.success==true){
					window.location.href="/login";
				}

			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//清除输入内容
function clear(){
	//初始化信息
	$("#username").val("");
	$("#display").val("");
	$("#password").val("");
   	$("#user_des").val("");
   	$("#id").val("0");
 	$("#user_status").val("0");
}

//修改用户页面
function editUserPage(){
	clear();
	var id = $("#current_id").val();
	var username = $("#current_username").val();
	var display = $("#current_display").val();
	$("#operate_username").val(username);
   	$("#operate_display").val(display);
   	$("#operate_id").val(id);
   	//显示隐藏的数据
   	$("#operate_user_modal").modal();
}

//用户的更新和新增
function operateUserSave(){
	var username = $.trim($("#operate_username").val());
   	var display = $.trim($("#operate_display").val());
	if (username=="") {
		layer.msg("请输入用户账号!");
		return false;
	}
	if (display=="") {
		layer.msg("请输入用户名称!");
		return false;
	}
	layer.load(2);
	/**
	 * 保存数据
	 */
	$.ajax({
        url: "/user/operateUserSave",
        type:"POST",
        data:$('#operate_user_form').serialize(),// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				clear();
				$("#operate_user_cancel").click();
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

//公共方法
//子级页面的菜单调用
function subCallBackParentMenu(id){
	$('#'+id).trigger('click');
}
//子级调用父级删除某一个子菜单
function subCallBackRemoveMenu(id){
	removeTabLabel(id);
}

//子级页面的菜单调用
function subCallBackReload(){
	window.location.reload();
}

//公共方法
//获取当前时间，格式YYYY-MM-DD
function getNowFormatDate() {
	var date = new Date();
	var seperator1 = "-";
	var year = date.getFullYear();
	var month = date.getMonth() + 1;
	var strDate = date.getDate();
	if (month >= 1 && month <= 9) {
		month = "0" + month;
	}
	if (strDate >= 0 && strDate <= 9) {
		strDate = "0" + strDate;
	}
	var currentdate = year + seperator1 + month + seperator1 + strDate;
	return currentdate;
}

//获取菜单是否关闭了
function getPageStatus(pageId){
	var pageKey = 'page-' + pageId;
	var pageStatus = $.cookie(pageKey);
	if(undefined == pageStatus){
		//初始化参数
		currentPageStatus = 'N';
		$.cookie(pageKey, currentPageStatus, {
			expires: 1,
			path: '/'
		});
	}else{
		currentPageStatus = pageStatus;
	}
	/*$.ajax({
	    url: "/produce/getPageStatus",
	    type: "POST",
	    async: false,
	    data: {"pageId": pageId},// 你的formid
	    dataType:"JSON",
	    success: function (data) {
	         if(data.success){
	        	 currentPageStatus = data.obj;
	         }
	    },
	    error: function(data) {
	    	var responseText = data.responseText;
	    	var json_str = JSON.parse(responseText);
	    	var status = json_str.status;
	    	var message = json_str.message;
	    	//判断是否是session超时
	    	if(403==status){
	    		layer.alert(message,function(){
	    			 window.parent.subCallBackReload();
	    		});
	    	}
	    	
	    	layer.closeAll('loading');
	    }
	});*/
}

//打开打印机设置的页面
function editPrinterModal(){
	//置空下拉框
	$("#operator_printer").html('');
	//添加下拉框
	CLODOP.Create_Printer_List(document.getElementById('operator_printer'));
	//CLODOP.Create_Printer_List($('#operator_printer'));
	$("#operator_printer").prepend("<option value='-1'>先预览后打印</option>");
	//判断是否打开设计模式
	if("admin" == $("#current_username").val()){
		$("#operator_printer").prepend("<option value='-2'>设计模式</option>");
	}
	$("#operator_printer").val($('#current_printer_index').val());
	
	//显示modal
	$('#printer_modal').modal();
}

//保存或修改用户的打印机
function savePrinter(){
	let site = $('#current_site').val();
	let username = $("#current_username").val();
	let printerId = $("#printer_id").val();
	let printerIndex = $.trim($("#operator_printer").val());
	let printerName = $("#operator_printer").find('option:selected').text();
	let printerMethod = "print";
	//判断打印方式
	if(-2 == printerIndex){
		printerMethod = "design";
	}else if(-1 == printerIndex){
		printerMethod = "preview";
	}
	let currentRow = {"id": printerId, "site": site, "username": username, "labelNo": '', "printerIndex": printerIndex,
			"printerName": printerName, "printerMethod": printerMethod, "status": 'Y'}
	/**
	 * 保存数据
	 */
	$.ajax({
        url: "/user/savePrinter",
        type: "POST",
        contentType: 'application/json;charset=utf-8',
        data: JSON.stringify(currentRow),// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				$("#printer_cancel").click();
				layer.msg(data.msg);
				window.location.reload();
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.location.href="/login";
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}