/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xjfast.entity.Inventorystock;
import com.xjfast.entity.Transdetail;
import com.xjfast.entity.Transheader;
import com.xjfast.entity.query.InventoryStockQuery;
import com.xjfast.entity.vo.InventoryStockVo;
import com.xjfast.entity.vo.TransDetailVo;
import com.xjfast.mapper.InventorystockMapper;
import com.xjfast.mapper.TransdetailMapper;
import com.xjfast.mapper.TransheaderMapper;
import com.xjfast.service.InventoryStockService;
import com.xjfast.utils.DateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InventoryStockServiceImpl
extends ServiceImpl<InventorystockMapper, Inventorystock>
implements InventoryStockService {
    @Autowired
    private InventorystockMapper inventorystockMapper;
    @Autowired
    private TransheaderMapper transheaderMapper;
    @Autowired
    private TransdetailMapper transdetailMapper;

    public List<InventoryStockVo> searchInventoryList(InventoryStockQuery inventoryStockQuery) {
        return this.inventorystockMapper.searchInventoryList(inventoryStockQuery);
    }

    public void saveInventoryList(List<List<Object>> list, String userName, String site) {
        List inventorystocks = this.list();
        ArrayList<TransDetailVo> transDetailVos = new ArrayList<TransDetailVo>();
        for (List<Object> objects : list) {
            for (Object object : objects) {
                TransDetailVo c = (TransDetailVo)object;
                transDetailVos.add(c);
            }
        }
        String procedureName = "dbo.UpdateTransNo";
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        Integer year = calendar.get(1);
        Integer month = calendar.get(2) + 1;
        Transheader transheaderOr = new Transheader();
        transheaderOr.setTranstypeDb("OR");
        transheaderOr.setTranstype("\u5176\u5b83\u5165\u5e93");
        transheaderOr.setWarehouseid(((TransDetailVo)transDetailVos.get(0)).getWarehouseid());
        String or = this.transheaderMapper.getTransNo(site, "OR");
        transheaderOr.setTransno(or);
        transheaderOr.setSite(site);
        transheaderOr.setTransdate(DateUtils.parseDate((String)DateUtils.getStringDate((Date)date), (String)"yyyy-MM-dd"));
        transheaderOr.setUsername(userName);
        transheaderOr.setReceiver(userName);
        transheaderOr.setPartnertype("*");
        transheaderOr.setPartnerid("*");
        transheaderOr.setAuthorizeflag("N");
        transheaderOr.setTransferflag("N");
        transheaderOr.setEnterdate(new Date());
        transheaderOr.setTransyear(Double.valueOf(year.doubleValue()));
        transheaderOr.setTransmonth(Double.valueOf(month.doubleValue()));
        Transheader transheaderOc = new Transheader();
        transheaderOc.setTranstypeDb("OC");
        transheaderOc.setTranstype("\u5176\u5b83\u51fa\u5e93");
        transheaderOc.setWarehouseid(((TransDetailVo)transDetailVos.get(0)).getWarehouseid());
        String oc = this.transheaderMapper.getTransNo(site, "OC");
        transheaderOc.setTransno(oc);
        transheaderOc.setSite(site);
        transheaderOc.setTransdate(DateUtils.parseDate((String)DateUtils.getStringDate((Date)date), (String)"yyyy-MM-dd"));
        transheaderOc.setUsername(userName);
        transheaderOc.setReceiver(userName);
        transheaderOc.setPartnertype("*");
        transheaderOc.setPartnerid("*");
        transheaderOc.setAuthorizeflag("N");
        transheaderOc.setTransferflag("N");
        transheaderOc.setEnterdate(new Date());
        transheaderOc.setTransyear(Double.valueOf(year.doubleValue()));
        transheaderOc.setTransmonth(Double.valueOf(month.doubleValue()));
        List transdetailList = transDetailVos.stream().map(item -> {
            Transdetail transdetail = new Transdetail();
            for (Inventorystock inventorystock : inventorystocks) {
                if (!inventorystock.getWarehouseid().equals(item.getWarehouseid()) || !inventorystock.getPartno().equals(item.getPartno())) continue;
                Double number = inventorystock.getQtyonhand() - item.getQtyonhand();
                transdetail.setPartno(item.getPartno());
                transdetail.setTransqty(Double.valueOf(number > 0.0 ? number : -number.doubleValue()));
                transdetail.setSite(site);
                transdetail.setPartno(item.getPartno());
                transdetail.setBatchno("*");
                transdetail.setLocationid("*");
                transdetail.setStandcost(Double.valueOf(0.0));
                transdetail.setActualcost(Double.valueOf(0.0));
                if (number < 0.0) {
                    transdetail.setTransno(transheaderOr.getTransno());
                    transdetail.setDirection("+");
                } else {
                    transdetail.setTransno(transheaderOc.getTransno());
                    transdetail.setDirection("-");
                }
                if (number == 0.0) {
                    return null;
                }
                return transdetail;
            }
            transdetail.setTransno(transheaderOr.getTransno());
            transdetail.setTransqty(item.getQtyonhand());
            transdetail.setSite(site);
            transdetail.setPartno(item.getPartno());
            transdetail.setDirection("+");
            transdetail.setBatchno("*");
            transdetail.setLocationid("*");
            transdetail.setStandcost(Double.valueOf(0.0));
            transdetail.setActualcost(Double.valueOf(0.0));
            return transdetail;
        }).filter(item -> item != null).collect(Collectors.toList());
        if (transdetailList.size() > 0) {
            Map<String, List<Transdetail>> listMap = transdetailList.stream().collect(Collectors.groupingBy(Transdetail::getDirection));
            ArrayList<Transdetail> transdetails = new ArrayList<Transdetail>();
            ArrayList<Transheader> transheaders = new ArrayList<Transheader>();
            if (listMap.size() > 0) {
                for (String key : listMap.keySet()) {
                    int i;
                    List<Transdetail> transdetails1 = listMap.get(key);
                    Transheader transheader = new Transheader();
                    if (key.equals("-")) {
                        transheader = transheaderOc;
                        for (i = 0; i < transdetails1.size(); ++i) {
                            transdetails1.get(i).setItemno(Double.valueOf(1.0 + (double)i));
                        }
                    }
                    if (key.equals("+")) {
                        transheader = transheaderOr;
                        for (i = 0; i < transdetails1.size(); ++i) {
                            transdetails1.get(i).setItemno(Double.valueOf(1.0 + (double)i));
                        }
                    }
                    transheaders.add(transheader);
                    transdetails.addAll(transdetails1);
                }
            }
            if (transheaders.size() > 0) {
                this.transheaderMapper.saveTransHeaderList(transheaders);
            }
            if (transdetails.size() > 0) {
                this.transdetailMapper.saveTransDetaiList(transdetails);
            }
            this.transheaderMapper.updateTranNo(procedureName, site, "OR");
            this.transheaderMapper.updateTranNo(procedureName, site, "OC");
        }
    }
}

