/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.aop;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xjfast.entity.vo.UserOutData;
import com.xjfast.utils.R;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class RepeatSubmitAspect {
    private static final Cache<String, Object> caches = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();

    @Pointcut(value="@annotation(com.xjfast.annotation.RepeatSubmit)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object submitAop(ProceedingJoinPoint pjp) throws Exception {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HttpSession session = request.getSession();
        UserOutData user = (UserOutData)session.getAttribute("user");
        if (null == user) {
            HttpServletResponse response = attributes.getResponse();
            response.sendError(403, "Session is expired!");
            return response;
        }
        String username = user.getUsername();
        String url = request.getRequestURI();
        String key = username + "-" + url;
        if (!StringUtils.isEmpty((CharSequence)key)) {
            if (caches.getIfPresent((Object)key) == null) {
                caches.put((Object)key, (Object)key);
            } else {
                return R.error((int)405, (String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
        }
        try {
            return pjp.proceed();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

