//公共参数
let tableTags = "skuInfo_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    skuInfoTableInit();

});

// 初始化人员信息
function selectOption(url,departmentId) {
    let user = {
        'status' : 'Y'
    }
    $.ajax({
        url: url,
        type: "POST",
        contentType:'application/json;charset=utf-8',
        async: false,
        data:JSON.stringify(user),
        dataType: "json",
        success: function (data) {
            console.log(data)
            var resultTags = '';
            var obj = data.rows;
            for (var i = 0; i < obj.length; i++) {
                resultTags += '<option value="' + obj[i].username + '">' + obj[i].display + '</option>';
            }
            $('#'+departmentId).html(resultTags);
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    });

}

// 初始化SKU表格
function skuInfoTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/part/searchPartList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                active: $('#status').val(),
                partno: $("#partNo").val(),
                partdescription: $("#partDescription").val(),
                 parttypeDb: 'F'
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'partno',
            title: '物料编号',
            width: 200,
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200,
        }, {
            field: 'parttype',
            title: '类型',
            width: 200,
        },{
            field: 'groupName',
            title: '分组名称',
            width: 200,
        }, {
            field: 'active',
            title: '状态',
            formatter: function (value, row, index) {
                if ('Y' == value) {
                    return '启用';
                } else {
                    return '禁用';
                }
            },
            width: 200,
        },{
            field: 'othergroup2',
            title: '运营'
        }, {
            field: '-',
            title: '-'
        }],
        onClickRow: function(row, $element){
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 92;
            $('#'+ tableTags).parents('.fixed-table-container').css("height", height_param+"px");
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: 'SKU信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: 'SKU信息表',          //表格工作区名称
            tableName: 'SKU信息表',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

// 查询
function searchSkuInfo() {
    $('#' + tableTags).bootstrapTable('refresh')
}






//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
    var result = "";
    if (row > 0 && col == 0)
        debugger;
    result = "\\@";
    return result;
}

// 日期数字格式化
function generateTimeReqestNumber() {
    var date = new Date();
    return date.getFullYear().toString() + pad2(date.getMonth() + 1) + pad2(date.getDate()) + pad2(date.getHours()) + pad2(date.getMinutes()) + pad2(date.getSeconds());
}

function pad2(n) {
    return n < 10 ? '0' + n : n
}
