//公共参数
let tableTags = "ware_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    wareTableInit();
});

// 初始化店铺信息
function storInit() {

}

//初始化表格
function wareTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/inventory/searchInventoryList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                'site': $('#current_site').val(),
                'warehouseid': $('#warehouseid').val(),
                'wareHouseName': $('#warehousename').val(),
                "partNo": $("#partNo").val(),
                "partDescription": $("#partDescription").val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'warehouseid',
            title: '仓库编号',
            width: 200,
        }, {
            field: 'warehousename',
            title: '仓库名称',
            width: 200,
        }, {
            field: 'partno',
            title: '物料编号',
            width: 200,
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200,
        }, {
            field: 'qtyonhand',
            title: '库存数量',
            width: 200,
            align : 'right',
        }, {
            field: 'warehousetype',
            title: '仓库类型',
            width: 200
        },{
            field: '-',
            title: '-',
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '库存信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '库存信息',          //表格工作区名称
            tableName: '库存信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//处理搜索，刷新table
function searchWare() {
    $('#ware_data').bootstrapTable('refresh');
}

// 产品入库
function addWareModal() {
    $('#ware_modal').modal()
}

// 添加库存
function addWare() {

}

// 编辑库存model
function editWareModal() {

}

// 编辑库存
function editWare() {

}

//删除库存信息确认
function removerWare() {
    layer.confirm('确定要删除选中SKU信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
    }, function () {

    });
}



//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
    var result = "";
    if (row > 0 && col == 0)
        debugger;
    result = "\\@";
    return result;
}

// 日期数字格式化
function generateTimeReqestNumber() {
    var date = new Date();
    return date.getFullYear().toString() + pad2(date.getMonth() + 1) + pad2(date.getDate()) + pad2(date.getHours()) + pad2(date.getMinutes()) + pad2(date.getSeconds());
}

function pad2(n) {
    return n < 10 ? '0' + n : n
}