//公共参数
let tableTags = "productionPlanData";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    productionPlanInit();
});


//初始化备货计划建议
function productionPlanInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/shopOrderRequisition/searchShopOrderRequisitionList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {

            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'partNo',
            title: 'SKU编号'
        }, {
            field: 'partDescription',
            title: 'SKU名称'
        }, {
            field: 'qtyRequired',
            title: '要求生产数量',
            width: 100,
            align : 'right',
        }, {
            field: 'needDate',
            title: '要求生产完成时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            },
            width: 100
        }, {
            field: 'createdBy',
            title: '录入人'
        }, {
            field: 'createdDate',
            title: '录入时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 16);
                return date;
            },
            width: 120
        }, {
            field: 'status',
            title: '状态'
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        onDblClickRow: function (row, $element) {
            currentRow = row;
            openCalculationDetails()
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '生产计划' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '计划信息',          //表格工作区名称
            tableName: '计划信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

function search(){
    $('#productionPlanData').bootstrapTable('refresh')
}


// 生产 production
function  production(){

}
// 打开计算详情
function openCalculationDetails(){
    $('#infoPartDescription').text(currentRow.partDescription)
    $('#infoPartNo').text(currentRow.partNo)
    calculationDetails()
    $('#productionInfo').bootstrapTable('refresh')
    $('#production_modal').modal()
}

// 计算详情
function calculationDetails(){
    $('#productionInfo').bootstrapTable({
        url: '/replenishment/searchMrpPlanDataList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            let param = {
                partNo: currentRow.partNo,
                site: currentRow.site,
                calculationType: 'MPS'
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*//*{
            field: 'wareHouseId',
            title: '店铺编号'
        }, {
            field: 'warehousename',
            title: '店铺名称'
        }, {
            field: 'partNo',
            title: 'SKU编号'
        }, {
            field: 'partdescription',
            title: 'SKU名称'
        },*/ {
            field: 'planQty',
            title: '数量',
            align : 'right',
        }, {
            field: 'direction',
            title: '方向'
        }, {
            field: 'planDesc',
            title: '描述'
        }, {
            field: 'planQtys',
            title: '库存',
            align : 'right',
            formatter: function (value, row, index) {
                row.planQtys = $('#productionInfo').bootstrapTable('getData')[index].planQty;
                if (index == 0) {
                    if (row.direction == '+'){
                        row.planQtys = $('#productionInfo').bootstrapTable('getData')[0].planQty
                    }else {
                        row.planQtys = -$('#productionInfo').bootstrapTable('getData')[0].planQty
                    }

                } else {
                    if (row.direction == '+') {
                        row.planQtys = $('#productionInfo').bootstrapTable('getData')[index - 1].planQtys + row.planQty
                    } else {
                        row.planQtys = $('#productionInfo').bootstrapTable('getData')[index - 1].planQtys - row.planQty
                    }
                }

                return row.planQtys;
            }
        }, {
            field: 'planDate',
            title: '时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            }
        }, {
            field: 'status',
            title: '状态'
        }],
        onLoadSuccess: function (data) {
            $('#productionInfo').parents('.fixed-table-container').addClass("table-height");
        }
    });
}




