//公共参数
let tableTags = "deliveryRequisition_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    wareTableInit();
    InfoDate('startDate')
    InfoDate('endDate')
});


//初始化备货计划建议
function wareTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/replenishment/searchReplenishmentList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                'site': $('#current_site').val(),
                'warehousename': $('#warehousename').val(),
                "partdescription": $("#partDescription").val(),
                'warehousetypeDb': 'T'
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'wareHouseId',
            title: '店铺编号'
        }, {
            field: 'warehousename',
            title: '店铺名称'
        }, {
            field: 'partNo',
            title: 'SKU编号'
        }, {
            field: 'partdescription',
            title: 'SKU名称'
        }, {
            field: 'qtyRequired',
            title: '需求数量',
            width: 100,
            align : 'right',
        }, {
            field: 'needDate',
            title: '要求到货时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            },
            width: 100
        }, {
            field: 'createdBy',
            title: '录入人',
            width: 100
        }, {
            field: 'createdDate',
            title: '录入时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 16);
                return date;
            },
            width: 120
        }, {
            field: 'status',
            title: '状态',
            width: 100
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 92;
            $('#'+ tableTags).parents('.fixed-table-container').css("height", height_param+"px");
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        onDblClickRow: function (row, $element) {
            currentRow = row;
            editDeliveryModal()
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '库存信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '库存信息',          //表格工作区名称
            tableName: '库存信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//处理搜索，刷新table
function search() {
    $('#deliveryRequisition_data').bootstrapTable('refresh');
}

// 选择补货
function calculation() {
    $('#delivery_modal').modal()
}
// 补货
function addDelivey() {
    let mrpPlanDataQuery = {
        createdBy: $('#current_username').val(),
        site: $('#current_site').val(),
        days: $('#days').val(),
        wareHouseId: $("#wareHouseId").val(),
        partNo: $('#partNo').val(),
        calculationType: 'MS',
        wareHouseTypeDb: 'T',
        otherGroup2: $('#current_username').val()
    }
    $.ajax({
        url: '/mrpPlan/updateMrpPlanCalculation',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(mrpPlanDataQuery),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#skuInfoClose').click()
                $('#deliveryRequisition_data').bootstrapTable('refresh')
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}



let lod = 'N'

// 计划详情
function editDeliveryModal() {
    $('#infoWareHouseName').text(currentRow.warehousename)
    $('#infoPartDescription').text(currentRow.partdescription)
    deliveryInfoTable()
    $('#deliveryRequisition_info').bootstrapTable('refresh')
    $('#edit_modal').modal()
}

// 计划详情列表
function deliveryInfoTable() {
    $('#deliveryRequisition_info').bootstrapTable({
        url: '/replenishment/searchMrpPlanDataList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            let param = {
                wareHouseId: currentRow.wareHouseId,
                partNo: currentRow.partNo,
                site: currentRow.site,
                planDesc: '临时补货',
                calculationType: 'MS'
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*//*{
            field: 'wareHouseId',
            title: '店铺编号'
        }, {
            field: 'warehousename',
            title: '店铺名称'
        }, {
            field: 'partNo',
            title: 'SKU编号'
        }, {
            field: 'partdescription',
            title: 'SKU名称'
        },*/ {
            field: 'planQty',
            title: '数量',
            align : 'right',
        }, {
            field: 'direction',
            title: '方向'
        }, {
            field: 'planDesc',
            title: '描述'
        }, {
            field: 'planQtys',
            title: '库存',
            align : 'right',
            formatter: function (value, row, index) {
                row.planQtys = $('#deliveryRequisition_info').bootstrapTable('getData')[index].planQty;
                if (index == 0) {
                    if (row.direction == '+'){
                        row.planQtys = $('#deliveryRequisition_info').bootstrapTable('getData')[0].planQty
                    }else {
                        row.planQtys = -$('#deliveryRequisition_info').bootstrapTable('getData')[0].planQty
                    }
                } else {
                    if (row.direction == '+') {
                        row.planQtys = $('#deliveryRequisition_info').bootstrapTable('getData')[index - 1].planQtys + row.planQty
                    } else {
                        row.planQtys = $('#deliveryRequisition_info').bootstrapTable('getData')[index - 1].planQtys - row.planQty
                    }
                }

                return row.planQtys;
            }
        }, {
            field: 'planDate',
            title: '时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            }
        }, {
            field: 'status',
            title: '状态'
        }],
        onLoadSuccess: function (data) {

            $('#deliveryRequisition_info').parents('.fixed-table-container').addClass("table-height");
        }
    });
}




// 删除计划
function removeDelivery(){
    layer.confirm('确定要删除选中的信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
        let mrpPlanDataQuery = {
            id: currentRow.id
        }
        $.ajax({
            url: '/replenishment/removeDeliveryRequisition',
            contentType: 'application/json',
            type: "POST",
            async: false,
            data: JSON.stringify(mrpPlanDataQuery),
            dataType: "json",
            success: function (data) {
                layer.msg(data.msg)
                if (data.success) {
                    $('#deliveryRequisition_data').bootstrapTable('refresh')
                }
            },
            error: function (data) {
                var responseText = data.responseText;
                var json_str = JSON.parse(responseText);
                var status = json_str.status;
                var message = json_str.message;
                //判断是否是session超时
                if (403 == status) {
                    layer.alert(message, function () {
                        window.location.href = "/login";
                    });
                }
                layer.closeAll('loading');
            }
        })
    }, function () {

    });

}

//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
    var result = "";
    if (row > 0 && col == 0)
        debugger;
    result = "\\@";
    return result;
}

// 日期数字格式化
function generateTimeReqestNumber() {
    var date = new Date();
    return date.getFullYear().toString() + pad2(date.getMonth() + 1) + pad2(date.getDate()) + pad2(date.getHours()) + pad2(date.getMinutes()) + pad2(date.getSeconds());
}

function pad2(n) {
    return n < 10 ? '0' + n : n
}

// 时间搜索框
function InfoDate(date) {
//	var default_date = getNowFormatDate();
//	$("#"+date).val(default_date);
    $.fn.datetimepicker.dates['zh-CN'] = {
        days: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六", "星期日"],
        daysShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六", "周日"],
        daysMin: ["日", "一", "二", "三", "四", "五", "六", "日"],
        months: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
        monthsShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
        today: "今天",
        suffix: [],
        meridiem: ["上午", "下午"]
    };
    //初始化模态框的日期
    $("#" + date).datetimepicker({
        format: 'yyyy-mm-dd',//显示格式
        startView: "month", //初始化视图是‘年’
        maxView: 4,//最高能展示的时间,Number, String类型  默认值：4, 年
        minView: 'year',//日期时间选择器所能够提供的最精确的时间选择视图
        autoclose: true,//选择后自动关闭
        todayBtn: true,//开启选择今天的按钮
        todayHighlight: true,//今天日期高亮显示 如果为true, 高亮当前日期。Boolean类型 ,默认值：false ,
        language: 'zh-CN'//语言选择中文
    });
}
