/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.utils;

import com.xjfast.entity.dto.FileInfoDto;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class FTPManager {
    private static Logger logger = LoggerFactory.getLogger(FTPManager.class);
    @Value(value="${com.ftp.ftpHost}")
    private String ftpHost;
    @Value(value="${com.ftp.ftpPort}")
    private Integer ftpPort;
    @Value(value="${com.ftp.ftpUser}")
    private String ftpUser;
    @Value(value="${com.ftp.ftpPassword}")
    private String ftpPassword;
    @Value(value="${com.ftp.ftpDir}")
    private String ftpDir;
    private FTPClient ftpClient = new FTPClient();
    private static FTPManager ftpManager = null;

    public FTPManager() {
        this.ftpClient.setControlEncoding("GBK");
        FTPClientConfig conf = new FTPClientConfig();
        conf.setServerLanguageCode("zh");
        this.ftpClient.configure(conf);
    }

    public void setInfo(String host, int port, String user, String password, String dir) {
        this.ftpHost = host;
        this.ftpPort = port;
        this.ftpUser = user;
        this.ftpPassword = password;
        this.ftpDir = dir;
    }

    public static synchronized FTPManager getInstance() {
        if (ftpManager == null) {
            ftpManager = new FTPManager();
        }
        return ftpManager;
    }

    public boolean connect() throws Exception {
        boolean flag = false;
        if (!this.ftpClient.isConnected()) {
            try {
                this.ftpClient.connect(this.ftpHost, this.ftpPort.intValue());
                this.ftpClient.setControlEncoding("GBK");
                FTPClientConfig conf = new FTPClientConfig("WINDOWS");
                conf.setServerLanguageCode("zh");
                this.ftpClient.configure(conf);
                this.ftpClient.enterLocalPassiveMode();
                this.ftpClient.setBufferSize(1024);
                flag = this.ftpClient.login(this.ftpUser, this.ftpPassword);
                this.ftpClient.setFileType(2);
            }
            catch (SocketException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return flag;
    }

    public void disconnect() throws Exception {
        if (null != this.ftpClient && this.ftpClient.isConnected()) {
            this.ftpClient.disconnect();
        }
    }

    public boolean delete(String remotePath, boolean isAbsolutePath) throws Exception {
        boolean flag = false;
        this.connect();
        flag = isAbsolutePath ? this.ftpClient.deleteFile("/" + remotePath) : this.ftpClient.deleteFile(this.getFtpDir() + remotePath);
        return flag;
    }

    public boolean deleteEmptyDictory(String remotePath, boolean isAbsolutePath) throws Exception {
        boolean flag = false;
        flag = isAbsolutePath ? this.ftpClient.removeDirectory("/" + remotePath) : this.ftpClient.removeDirectory(this.getFtpDir() + remotePath);
        return flag;
    }

    public String download(String bpath, String localPath, boolean isAbsolutePath) throws Exception {
        System.out.println("\u4e0b\u8f7d\u8def\u5f84\uff1a" + bpath);
        boolean flag = false;
        this.connect();
        File localFile = new File(localPath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(localFile);
            String dir = "";
            dir = isAbsolutePath ? "/" + bpath : this.getFtpDir() + bpath;
            this.createDir(dir.substring(0, dir.lastIndexOf("/")));
            this.isDirExist(dir);
            flag = this.ftpClient.retrieveFile(dir, (OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                IOUtils.closeQuietly((Closeable)fos);
                fos.close();
            }
            this.disconnect();
        }
        return localPath;
    }

    public void changePath(String path) throws Exception {
        this.connect();
        String dir = path;
        if (!this.ftpClient.printWorkingDirectory().equalsIgnoreCase(dir)) {
            this.ftpClient.changeWorkingDirectory(dir);
        }
    }

    private void createDir(String path) throws Exception {
        if (path != null) {
            String[] splitPath;
            path = path.replace('\\', '/');
            path = path.replace("//", "/");
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            if ((splitPath = path.split("/")) != null && splitPath.length > 0) {
                for (int i = 0; i < splitPath.length; ++i) {
                    if (splitPath[i] == null || splitPath[i].trim().length() <= 0) continue;
                    this.ftpClient.changeWorkingDirectory(splitPath[i]);
                    String dir = this.ftpClient.printWorkingDirectory();
                    String temppath0 = dir.substring(dir.lastIndexOf("/") + 1, dir.length());
                    if (splitPath[i].equals(temppath0)) {
                        this.ftpClient.changeWorkingDirectory(splitPath[i]);
                        continue;
                    }
                    if (!this.isDirExist(splitPath[i])) {
                        this.ftpClient.makeDirectory(splitPath[i]);
                    }
                    this.ftpClient.changeWorkingDirectory(splitPath[i]);
                }
            }
        }
    }

    private boolean isDirExist(String dir) throws IOException {
        boolean exist = false;
        this.ftpClient.enterLocalPassiveMode();
        FTPFile[] files = this.ftpClient.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getType() != 1 || !files[i].getName().equalsIgnoreCase(dir)) continue;
                exist = true;
                break;
            }
        }
        return exist;
    }

    public boolean checkFileExist(String filePath, String fileName) throws Exception {
        boolean existFlag = false;
        try {
            String[] fileNames;
            this.connect();
            if (filePath != null && !filePath.equals("")) {
                if (filePath.indexOf("/") != -1) {
                    int index = 0;
                    while ((index = filePath.indexOf("/")) != -1) {
                        this.ftpClient.changeWorkingDirectory(filePath.substring(0, index));
                        filePath = filePath.substring(index + 1, filePath.length());
                    }
                    if (!filePath.equals("")) {
                        this.ftpClient.changeWorkingDirectory(filePath);
                    }
                } else {
                    this.ftpClient.changeWorkingDirectory(filePath);
                }
            }
            if ((fileNames = this.ftpClient.listNames()) != null && fileNames.length > 0) {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (fileNames[i] == null || !fileNames[i].substring(0, fileNames[i].length() - 1).trim().equals(fileName)) continue;
                    existFlag = true;
                    break;
                }
            }
            this.ftpClient.changeToParentDirectory();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.disconnect();
        }
        return existFlag;
    }

    private String getFtpDir() {
        return this.ftpDir == null || this.ftpDir.length() == 0 ? "/nccw/CQXT" : "/" + this.ftpDir + "/";
    }

    public boolean deleteFile(String UserUrl) {
        boolean flag = false;
        File f = new File(UserUrl);
        if (f.exists()) {
            flag = f.delete();
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfoDto upLoad(FileInfoDto fileInfoDto, FileInputStream fis, boolean isAbsolutePath) throws Exception {
        boolean flag = false;
        String dir = "";
        String remotePath = fileInfoDto.getFilePath();
        logger.info("382" + remotePath);
        logger.info("385" + isAbsolutePath);
        try {
            boolean bl = this.connect();
            dir = isAbsolutePath ? "/" + remotePath : this.getFtpDir() + remotePath;
            this.createDir(dir.substring(0, dir.lastIndexOf("/")));
            this.ftpClient.enterLocalPassiveMode();
            flag = this.ftpClient.storeFile(dir, (InputStream)fis);
            logger.info("395" + dir);
            logger.info("396" + fis);
        }
        catch (FileNotFoundException e) {
            logger.info("398" + e.getMessage());
        }
        catch (IOException e) {
            logger.info("400" + e.getMessage());
        }
        catch (Exception e) {
            logger.info("402" + e.getMessage());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            this.disconnect();
        }
        if (flag) {
            fileInfoDto.setFilePath(dir);
            return fileInfoDto;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getInputStream(String ftpDirName, String ftpFileName) throws Exception {
        try {
            String dir;
            this.connect();
            if ("".equals(ftpDirName)) {
                ftpDirName = "/";
            }
            if (!this.ftpClient.changeWorkingDirectory(dir = new String(ftpDirName.getBytes("GBK"), "iso-8859-1"))) {
                System.out.println("\u5207\u6362\u76ee\u5f55\u5931\u8d25\uff1a" + ftpDirName);
                byte[] byArray = null;
                return byArray;
            }
            String fileName = new String(ftpFileName.getBytes("GBK"), "iso-8859-1");
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            InputStream inputStream = this.ftpClient.retrieveFileStream(fileName);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            this.ftpClient.getReply();
            this.ftpClient.logout();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u6d41\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.disconnect();
        }
    }
}

