/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class AjaxExpiredSessionException
extends LoginUrlAuthenticationEntryPoint {
    public AjaxExpiredSessionException(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String header = request.getHeader("X-Requested-With");
        boolean isAjax = "XMLHttpRequest".equals(header);
        if (isAjax) {
            response.sendError(403, "Session is expired!");
        } else {
            super.commence(request, response, authException);
        }
    }
}

