//公共参数
let tableTags = "part_plan_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    storTableInit();
    addPartPlanInfoTable();
    selectPartPlan();
});

//初始化表格
function storTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/part/searchPartPlanInfoList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                  //是否显示分页（*）
        sortable: false,                    //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",       //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                site: $('#current_site').val(),
                active: $('#status').val(),
                partdescription: $('#partdescription').val(),
                warehousename: $('#warehousename').val(),
                operating: 0,
                wareHouseTypeDb: 'T',
                othergroup2: ''
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: false,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'wareHouseId',
            title: '店铺编号',
            width: 200
        }, {
            field: 'warehousename',
            title: '店铺名称',
            width: 200
        }, {
            field: 'partNo',
            title: '物料编号',
            width: 200
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200
        }, {
            field: 'averageConsumeQty',
            title: '日消耗数量',
            align: 'right',
        }, {
            field: 'coverDays',
            title: '维持天数',
            align: 'right',
        }, {
            field: 'othergroup2',
            title: '运营',
            align: 'right',
        }],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 92;
            $('#' + tableTags).parents('.fixed-table-container').css("height", height_param + "px");
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '库存信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '库存信息',          //表格工作区名称
            tableName: '库存信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//处理搜索，刷新table
function searchPartPlanInfo() {
    $('#part_plan_data').bootstrapTable('refresh');
}


// 编辑 物料库存水平
function editPartPlanDataModal() {
    $('#skuName').val(currentRow.partdescription)
    $('#editWareHouseName').val(currentRow.warehousename)
    $('#averageConsumeQty').val(currentRow.averageConsumeQty)
    $('#coverDays').val(currentRow.coverDays)
    $('#edit_modal').modal()
}

// 编辑物料库存水平
function updatePartPlanInfo() {
    let partPlanInfo = {
        id: currentRow.id,
        averageConsumeQty: $('#averageConsumeQty').val(),
        coverDays: $('#coverDays').val()
    }
    $.ajax({
        url: '/part/updatePartPlanInfo',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(partPlanInfo),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#editClose').click()
                $('#part_plan_data').bootstrapTable('refresh')
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })


}

// 删除提示
function remove() {
    layer.confirm('确定要删除选中的信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
        removePartPlanInfo()
    }, function () {

    });
}

// 确认删除
function removePartPlanInfo() {
    let partPlanInfo = {
        id: currentRow.id
    }
    $.ajax({
        url: '/part/removePartPlanInfo',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(partPlanInfo),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#part_plan_data').bootstrapTable('refresh')
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

// 未设置安全水平的物料库存水平列表
function addPartPlanInfoTable() {
    $('#partMainTenance').bootstrapTable({
        url: '/part/searchPartPlanInfoList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                site: $('#current_site').val(),
                active: $('#status').val(),
                partdescription: $('#addPartDescription').val(),
                warehousename: $('#addWarehouseName').val(),
                // operating: 1,
                othergroup2: $('#current_username').val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //  height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [{
            checkbox: true
        }, {
            field: 'wareHouseId',
            title: '店铺编号',
            width: 200
        }, {
            field: 'warehousename',
            title: '店铺名称',
            width: 200
        }, {
            field: 'partNo',
            title: '物料编号',
            width: 200
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200
        }, {
            field: 'averageConsumeQty',
            title: '日消耗数量',
            align: 'right',
        }, {
            field: 'coverDays',
            title: '维持天数',
            align: 'right',
        }, {
            field: 'othergroup2',
            title: '运营',
            align: 'right',
        }],
        onLoadSuccess: function (data) {
            $('#partMainTenance').parents('.bootstrap-table').css("margin-left", "10px");
            $('#partMainTenance').parents('.fixed-table-container').css("width", 670 + "px");
            $('#partMainTenance').parents('.fixed-table-container').css("height", '300');
        }
    });
}

// 赛选 物料
function searchPart() {
    $('#partMainTenance').bootstrapTable('refresh');
}

// 添加模态框
function add() {
    $('#partMainTenance').bootstrapTable('refresh')
    $('#add_modal').modal()
}

// 初始化页面显示的列
function selectPartPlan() {
    $('#partPlanList').bootstrapTable({
        //   url: '/part/searchPartPlanInfoList',         //请求后台的URL（*）
        //  method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        //     contentType: 'application/json;charset=utf-8',
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                site: $('#current_site').val(),
                active: $('#status').val(),
                partdescription: $('#partdescription').val(),
                warehousename: $('#warehousename').val(),
                operating: 1,
                othergroup2: ''
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //  height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [{
            field: 'wareHouseId',
            title: '店铺编号',
            width: 200
        }, {
            field: 'warehousename',
            title: '店铺名称',
            width: 200
        }, {
            field: 'partNo',
            title: '物料编号',
            width: 200
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200
        }, {
            field: 'averageConsumeQty',
            title: '日消耗数量',
            align: 'right', cellStyle: function () {
                return {css: {"text-align": "center"}}
            },
            formatter: function (value, row, index) {
                if (value == null) {
                    value = 0
                }
                let averageConsumeQty = ' <input type="text" class=".parentNumber" name="averageConsumeQty"  value=' + value + ' style="width: 165px;border-style:none;" autocomplete="off"  onkeyup="value=value.replace(/[^\\d]/g,\'\')">'
                return averageConsumeQty
            }
        }, {
            field: 'coverDays',
            title: '维持天数',
            align: 'right',
            formatter: function (value, row, index) {
                if (value == null) {
                    value = 0
                }
                let coverDays = ' <input type="text" class=".parentNumber" name="coverDays"  value=' + value + ' style="width: 165px;border-style:none;" autocomplete="off" onkeyup="value=value.replace(/[^\\d]/g,\'\')">'
                return coverDays
            }
        }, {
            field: 'othergroup2',
            title: '运营',
            align: 'right',
        }],
        onPostHeader: function (data) {
            $('#partPlanList').parents('.bootstrap-table').css("margin-left", "10px");
            $('#partPlanList').parents('.fixed-table-container').css("width", 670 + "px");
            $('#partPlanList').parents('.fixed-table-container').css("height", '260');
        }
    });
}

var inputs

// 选择需要设置 库存水平的 物料
function addPartPlanInfo() {
    let partPlanList = $("#partMainTenance").bootstrapTable('getSelections')
    console.log(partPlanList)
    $('#partPlanList').bootstrapTable('load', partPlanList);
    $("#select_modal").modal()
    inputs = document.getElementById("partPlanList").getElementsByTagName("input");
    $("input").keydown(function (event) {
        var thisinput = $(this)[0];
        getfocus(thisinput);
    });
}

//回车和小键盘切换input焦点
function getfocus(thisinput) {
    inputs = document.getElementsByTagName("input");
    let code = event.keyCode
    switch (code){
        case 13:
        case 40:
        case 39:
            for (var i = 0; i < inputs.length; i++) {
                if (thisinput == inputs[i]) {
                    if (i == (inputs.length - 1)) {
                        inputs[0].focus();
                        break;
                    } else {
                        inputs[i + 1].focus();
                        break;
                    }
                }
            }
            break;
        case 37:
        case 38:
            for (var i = 0; i < inputs.length; i++) {
                if (thisinput == inputs[i]) {
                    if (i != 0) {
                        inputs[i - 1].focus();
                        break;
                    } else {
                        inputs[inputs.length - 1].focus();
                        break;
                    }
                }
            }
            break;

    }
}



// 保存选中的 物料信息
function savePartPlanInfo() {
    let bool = false
    let bool1 = false
    let data = []
    let partPlanList = $("#partPlanList").bootstrapTable('getData')
    let averageConsumeQtyList = $("[name='averageConsumeQty']")
    let coverDaysList = $("[name='coverDays']")
    averageConsumeQtyList.each((index, item) => {
        if ($(item).val() == '' || $(item).val() == null) {
            bool = true
        }
        if ($(coverDaysList [index]).val() == '' || $(coverDaysList [index]).val() == null) {
            bool1 = true
        }
        let partPlan = {
            id: partPlanList[index].id,
            wareHouseType: 'T',
            averageConsumeQty: $(item).val(),
            coverDays: $(coverDaysList [index]).val(),
            partNo: partPlanList[index].partNo,
            site: partPlanList[index].site,
            wareHouseId: partPlanList[index].wareHouseId
        }
        data.push(partPlan)
    })
    if (bool) {
        layer.alert('日消耗数不能为空')
        return
    }
    if (bool1) {
        layer.alert('维持天数不能为空')
        return;
    }
    $.ajax({
        url: '/part/savePartPlanInfoList',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(data),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#saveClose').click()
                $('#partMainTenance').bootstrapTable('refresh')
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

