//公共参数
let tableTags = "user_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function(){
	//初始化车间信息
	userTableInit();
	//初始化工厂
	initSiteChoose();

	s();
});

//初始化表格
function userTableInit(){
	$('#'+ tableTags).bootstrapTable({
        url: '/user/getUserDataByCon',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType:'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType : "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                username : $("#search_username").val(),
                display : $("#search_display").val(),
                status : $("#search_status").val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut:1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'username',
            title: '账号'
        },{
            field: 'display',
            title: '姓名'
        },{
            field: 'createdBy',
            title: '创建人'
        },{
            field: 'createdDate',
            title: '创建时间',
            formatter : function(value, row){
            	if(null == value || "" == value){
            		return null
            	}else{
            		return value.substring(0, 19);
            	}
            }
        },{
            field: 'status',
            title: '状态',
            formatter : function(value, row, index){
            	if('Y' == value){
            		return '启用';
            	}else{
            		return '禁用';
            	}
            }
        }],
		onClickRow: function(row, $element){
			$('.check_back').removeClass('check_back');
	        $($element).addClass('check_back');
	        currentRow = row;
	        //状态判断
	        let statusCode = null;
	        if("D" == row.status){
	        	statusCode = "deleted";
	        }
	        //调用自定义按钮的控制类
	        customerBtnControl(tableTags, row, statusCode);
		},
        onLoadSuccess: function (data){
        	//调用自定义按钮的控制类
        	customerBtnControl(tableTags, null, null)
		},
		onDblClickRow: function(row, $element, field){
			currentRow = row;
		},
		//>>>>>>>>>>>>>>导出excel表格设置
       showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
       exportDataType: "basic",              //basic', 'all', 'selected'.
       exportTypes:['excel','xlsx'],	    //导出类型
       exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
       exportOptions:{  
          ignoreColumn: [8,8],            //忽略某一列的索引  
          fileName: '用户信息维护表',              //文件名称设置
          worksheetName: '用户信息维护表',          //表格工作区名称
          tableName: '用户信息维护表',
          excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],  
          onMsoNumberFormat: DoOnMsoNumberFormat  
       }
	   //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//格式化数字
function DoOnMsoNumberFormat(cell, row, col) {
    var result = "";
    if (row > 0 && col == 0)

        result = "\\@";
    return result;
}
function editPasswordPage(){
	$("#first_password").val("");
	$("#confirm_password").val("");
	$("#user_password").modal();
}

//修改密码
function savePassword(){
	var first_password = $.trim($("#first_password").val());
	var confirm_password = $.trim($("#confirm_password").val());
	if(first_password==""){
		layer.msg("密码不能为空！");
		return false;
	}
	if(confirm_password==""){
		layer.msg("确认密码不能为空！");
		return false;
	}
	if(confirm_password!=first_password){
		layer.msg("确认密码和密码必须相同！");
		return false;
	}
	$.ajax({
		url: "/user/uodatasetpassword",
		type:"POST",
		data:{"id": currentRow.id,
			"password": first_password,
			"confirmpassword": confirm_password
		},// 你的formid
		dataType:"JSON",
		success: function (data) {
			if (data.success) {
				layer.msg(data.msg);
				$("#password_cancel").click();
				if (data.success==true){
					window.location.href="/login";
				}
			}else{
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.location.href="/login";
				});
			}
			layer.closeAll('loading');
		}
	});
}
//初始化工厂用于选择
function initSiteChoose(){
	$.ajax({
        url: "/base/getsite",
        type: "POST",
        data: {},// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
            if (data.success) {
            	var rows = data.rows
            	var siteTags = '';
            	for(var i = 0; i< rows.length; i++){
            		siteTags += '<option value="'+rows[i].siteID+'">'+rows[i].siteID+'-'+rows[i].siteName+'</option>';
        		}
            	$("#user_site").html(siteTags);
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}



//添加角色
function addModal(){
	clear();
  //显示隐藏的数据
   	$("#user_modal").modal();
}

//角色编辑
function editUserModal(){
	//初始化参数
	f2()
   	$("#usernames").val(currentRow.username);
   	$("#displays").val(currentRow.display);
   	$("#ids").val(currentRow.id);
	$("#user_statuss").val(currentRow.status);

	$("#user_sites").val(currentRow.site);
	$("#user_mailboxs").val(currentRow.mailbox);
   	//显示隐藏的数据
   	$("#user_modalNo1").modal();
}
function f2() {
	$("#usernames").val("");
	$("#displays").val("");
	$("#ids").val("");
	$("#user_statuss").val("");
	$("#user_sites").change("");
	$("#user_mailboxs").val("");
	//显示隐藏的数据
}
//初始化工厂用于选择
function s() {
	$.ajax({
		url: "/base/getsite",
		type: "POST",
		data: {},// 你的formid
		dataType:"JSON",
		success: function (data) {
			layer.closeAll('loading');
			if (data.success) {
				var rows = data.rows
				var siteTags = '';
				for(var i = 0; i< rows.length; i++){
					siteTags += '<option value="'+rows[i].siteID+'">'+rows[i].siteID+'-'+rows[i].siteName+'</option>';
				}
				$("#user_sites").html(siteTags);
			}else{
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.parent.subCallBackReload();
				});
			}
			layer.closeAll('loading');
		}
	})
}

function saveUsers(){
	var username = $.trim($("#usernames").val());
	var display = $.trim($("#displays").val());
	var id = $("#ids").val();
	var site = $('#user_sites').val();
	var mailbox= $('#user_mailboxs').val();
	var updatedBy=$('#current_username').val();
	if (username == "") {
		layer.msg("请输入用户账号!");
		return false;
	}
	if (display == "") {
		layer.msg("请输入用户名称!");
		return false;
	}
	if (site == "") {
		layer.msg("请选择工厂编号!");
		return false;
	}

	/**
	 * 保存数据
	 */
	$.ajax({
		url: "/user/updateusermapper",
		type:"POST",
		data:{"username":username,"display":display,"id":id,"site":site,"mailbox":mailbox,"updatedBy":updatedBy},// 你的formid
		dataType: "json",
		success: function (data) {
			layer.closeAll('loading');
			if (data.success) {
				layer.msg(data.msg);
				$("#user_cancels").click();
				$('#user_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.parent.subCallBackReload();
				});
			}
			layer.closeAll('loading');
		}
	})
}
function f() {
	$('#auth_modalsd').modal();
}
function f1() {
	var password=$('#passsss').val();
	if (password==''){
		layer.msg("密码为空!");
		return false;
	}
	$.ajax({
		url: "/user/updateuserpasswordid",
		type:"POST",
		data:{"id":currentRow.id,"password":password},// 你的formid
		dataType: "json",
		success: function (data) {
			layer.closeAll('loading');
			if (data.success) {
				layer.msg(data.msg);
				$("#auth_cancelsd").click();
				$('#user_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
		},
		error: function(data) {
			var responseText = data.responseText;
			var json_str = JSON.parse(responseText);
			var status = json_str.status;
			var message = json_str.message;
			//判断是否是session超时
			if(403==status){
				layer.alert(message,function(){
					window.parent.subCallBackReload();
				});
			}
			layer.closeAll('loading');
		}
	})
}



//用户的更新和新增
function saveUser(){
	var username = $.trim($("#username").val());
   	var display = $.trim($("#display").val());
    var id = $("#id").val();
    var site = $('#user_site').val();
	var mailbox= $('#user_mailbox').val();
	if (username == "") {
		layer.msg("请输入用户账号!");
		return false;
	}
	if (display == "") {
		layer.msg("请输入用户名称!");
		return false;
	}
	if (site == "") {
		layer.msg("请选择工厂编号!");
		return false;
	}

	/**
	 * 保存数据
	 */
	$.ajax({
        url: "/user/saveUser",
        type:"POST",
        data:$('#user_form').serialize(),// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
            if (data.success) {
				layer.msg(data.msg);
				$("#user_cancel").click();
				$('#user_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

//处理搜索，刷新table
function search(){
	$('#user_data').bootstrapTable('refresh');
}

//清除输入内容
function clear(){
	//初始化信息
	$("#username").val("");
	$("#display").val("");
	$("#password").val("");
   	var createdBy = $('#current_username').val();
   	var site = $('#current_site').val();
   	$('#created_by').val(createdBy);
	$('#updated_by').val(createdBy);
	$("#user_site option:first").prop("selected", 'selected');
	$("#user_department option:first").prop("selected", 'selected');
	$("#business_category option:first").prop("selected", 'selected');
	$("#shift_class option:first").prop("selected", 'selected');
   	$("#id").val("0");
 	$("#user_status").val("Y");
 	$("#user_mailbox").val("");
}

//删除用户确认
function delUserModal(){
	layer.confirm('确定要删除选中用户!', {
		btn : [ '确定', '取消' ]
	// 按钮
	}, function() {
		delUserById(currentRow);
	}, function() {

	});
}

//删除角色操作
function delUserById(row){
	$.ajax({
        url:"/user/delUserById",
        type:"POST",
        contentType: 'application/json;charset=utf-8',
        data:JSON.stringify({"id": row.id, "username": row.username, 
        	"updatedBy":$('#current_username').val(), "status": 'D'}),
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				$('#user_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//角色授权
function authModal(){
	$("#authr_user_display").text(currentRow.display);
	$("#auth_user_name").val(currentRow.username);
	treeInit(currentRow.username);
	$("#auth_modal").modal();
}

//加载树形表格
function treeInit(username){
	var setting = {
		check: {
			enable: true
		},
		simpleData: {
			enable: true,
			idKey:"id",
			idPKey:"pId", 
			rootPId : 0
		}
	};
	//加载树结构
	$.ajax({
        url:"/user/getTreeDataByUsername",
        type: "POST",
        data: {"username": username},
        dataType: "JSON",
        success: function (data) {
        	layer.closeAll('loading');
            if (data.success) {
            	$.fn.zTree.init($("#tree"), setting, data.rows);
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//保存权限
function saveAuth(){
	var username = $("#auth_user_name").val();
	var treeObj=$.fn.zTree.getZTreeObj("tree");
    var nodes=treeObj.getCheckedNodes(true);
    var values = [];
	for(var i=0;i<nodes.length;i++){
		values.push(nodes[i].id);
	}
	$.ajax({
        url: "/user/saveUserRole",
        type: "post",
        data: {"username": username,
        	   "auths": values.join(','),
        	   "account": $("#current_username").val()},
        dataType: "json",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				$("#auth_cancel").click();
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}