//公共参数
let tableTags = 'role_data';
let currentRow;//当前的行

//var audioElement = document.createElement('audio');
//audioElement.setAttribute('src', '/out_file/classic.mp3');

//初始化
$(function(){
	roleTableInit();
});

//初始化表格
function roleTableInit(){
	$('#'+tableTags).bootstrapTable({
        url: '/user/getRoleDataByCon',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType:'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType : "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                roleName : $("#search_rolename").val(),
                status: $("#search_status").val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut:1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: true,
        height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'roleName',
            title: '角色名称'
        },{
            field: 'roleDesc',
            title: '角色描述'
        },{
			field: 'status',
			title: '状态',
			formatter:function(value,row){
				if(value=="Y"){
					return "启用";
				}else if(value=="N"){
					return "禁用";
				}else if (value=="D"){
					return "删除"
				}
			},
			cellStyle: function(){
				return {css:{"text-align":"center"}}
			},
		},{
            field: 'createdBy',
            title: '创建人',
        },{
            field: 'createdDate',
            title: '创建时间',
            formatter : function(value, row){
            	if(null == value || "" == value){
            		return null
            	}else{
            		return value.substring(0, 19);
            	}
            }
        }],
        onLoadSuccess: function (data){
        	//调用自定义按钮的控制类
        	customerBtnControl(tableTags, null, null)
		},
		onClickRow: function(row, $element){
			$('.check_back').removeClass('check_back');
	        $($element).addClass('check_back');
	        currentRow = row;
	        //状态判断
	        let statusCode = null;
	        if("D" == row.status){
	        	statusCode = "deleted";
	        }
	        //调用自定义按钮的控制类
	        customerBtnControl(tableTags, row, statusCode);
		},
		onDblClickRow: function(row, $element, field){
			currentRow = row;
		},
		//>>>>>>>>>>>>>>导出excel表格设置
       showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
       exportDataType: "basic",              //basic', 'all', 'selected'.
       exportTypes:['excel','xlsx'],	    //导出类型
       exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
       exportOptions:{  
          ignoreColumn: [8,8],            //忽略某一列的索引  
          fileName: '角色信息维护',              //文件名称设置
          worksheetName: '角色信息维护',          //表格工作区名称
          tableName: '角色信息维护',
          excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],  
          //onMsoNumberFormat: DoOnMsoNumberFormat  
       }
	   //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//播放音乐声音
//function playAudio(){
//	/*var audio = document.getElementById("play"); 
//	audio.play();*/
//	audioElement.play();
//}

//添加角色
function addRoleModal(){
	//清空数据
	clear();
  //显示隐藏的数据
   	$("#role_modal").modal();
}

//角色编辑
function editRoleModal(){
	//清空数据
	clear();
	//初始化参数
   	$("#add_role_name").val(currentRow.roleName);
   	$("#add_role_desc").val(currentRow.roleDesc);
   	$("#role_id").val(currentRow.id);
   	$("#add_role_status").val(currentRow.status);
   	//显示隐藏的数据
   	$("#role_modal").modal();
}

//角色的更新和新增
function saveRole(){
	var roleNname = $.trim($("#add_role_name").val());
   	var roleDesc = $.trim($("#add_role_desc").val());
    var id = $("#add_role_id").val();
	if (name=="") {
		layer.msg("角色名称不能为空!");
		return false;
	}
	layer.load(2);
	/**
	 * 保存数据
	 */
	$.ajax({
        url: "/user/saveRole",
        type:"POST",
        data:$('#role_form').serialize(),// 你的formid
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				clear();
				$("#role_cancel").click();
				$('#role_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    })
}

//处理搜索，刷新table
function searchPage(){
	$('#role_data').bootstrapTable('refresh');
}

//清除输入内容
function clear(){
	//初始化信息
	$("#add_role_name").val("");
	var createdBy = $('#current_username').val();
   	var site = $('#current_site').val();
   	$('#created_by').val(createdBy);
	$('#updated_by').val(createdBy);
   	$('#role_site').val(site);
   	$("#add_role_desc").val("");
   	$("#role_id").val("0");
 	$("#role_status").val("Y");
}

//删除角色确认
function delRoleModal(){
	layer.confirm('确定要删除选中角色!', {
		btn : [ '确定', '取消' ]
	// 按钮
	}, function() {
		delRoleById(currentRow);
	}, function() {

	});
}

//删除角色操作
function delRoleById(row){
	$.ajax({
        url:"/user/delRoleById",
        contentType:'application/json;charset=utf-8',
        type:"POST",
        data:JSON.stringify({"id": row.id, "deletedBy": $("#current_username").val(), status: 'D'}),
        dataType:"JSON",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				$('#role_data').bootstrapTable('refresh');
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//角色授权
function authModal(){
	$("#authr_role_name").text(currentRow.roleName);
	$("#auth_role_id").val(currentRow.id);
	treeInit(currentRow.id);
	$("#auth_modal").modal();
}

//加载树形表格
function treeInit(roleId){
	var setting = {
		check: {
			enable: true
		},
		simpleData: {
			enable: true,
			idKey:"id",
			idPKey:"pId", 
			rootPId : 0
		}
	};
	$.ajax({
        url:"/user/getTreeDataByRoleId",
        type: "POST",
        data: {"roleId" : roleId},
        dataType: "JSON",
        success: function (data) {
        	layer.closeAll('loading');
            if (data.success) {
            	$.fn.zTree.init($("#tree"), setting, data.rows);
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}

//保存权限
function saveAuth(){
	var roleId = $("#auth_role_id").val();
	var treeObj=$.fn.zTree.getZTreeObj("tree");
    var nodes=treeObj.getCheckedNodes(true);
    var values = [];
	for(var i=0;i<nodes.length;i++){
		values.push(nodes[i].id);
	}
	$.ajax({
        url:"/user/saveRoleResource",
        type:"post",
        data:{"roleId" : roleId,
        	  "auths" : values.join(','),
        	  "username": $('#current_username').val()},
        dataType:"json",
        success: function (data) {
        	layer.closeAll('loading');
               if (data.success) {
				layer.msg(data.msg);
				clear();
				$("#auth_cancel").click();
			}else{
				layer.msg(data.msg);
			}
        },
        error: function(data) {
        	var responseText = data.responseText;
        	var json_str = JSON.parse(responseText);
        	var status = json_str.status;
        	var message = json_str.message;
        	//判断是否是session超时
        	if(403==status){
        		layer.alert(message,function(){
        			window.parent.subCallBackReload();
        		});
        	}
        	layer.closeAll('loading');
        }
    });
}


//菜单重载
function initMenus(){
	$.ajax({
	    url: "/user/initMenus",
	    type:"POST",
	    async: false,
	    data: {},
	    dataType:"JSON",
	    success: function (data) {
	    	layer.closeAll('loading');
	    	if (data.success) {
	    		layer.msg(data.msg);
			}
	    },
	    error: function(data) {
	    	var responseText = data.responseText;
	    	var json_str = JSON.parse(responseText);
	    	var status = json_str.status;
	    	var message = json_str.message;
	    	//判断是否是session超时
	    	if(403==status){
	    		layer.alert(message,function(){
	    			 window.parent.subCallBackReload();
	    		});
	    	}
	    	layer.closeAll('loading');
	    }
	});
}