//公共参数
let tableTags = "activity_data";//表格的id
let currentRow;//临时的参数行

//初始化
$(function () {
    InfoDate('startDate')
    InfoDate('finishDate')
    activityTableInit();
    partTable();
    selectPart();
});

//初始化表格
function activityTableInit() {
    $('#' + tableTags).bootstrapTable({
        url: '/promotion/searchPromotionHistList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        toolbar: '#toolbar',                //工具按钮用哪个容器
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                  //是否显示分页（*）
        sortable: false,                    //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",       //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                site: $('#current_site').val(),
                wareHouseName: $('#warehousename').val(),
                partDescription: $('#partDescription').val(),
                status: $('#status').val()
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",            //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                        //每页的记录行数（*）
        pageList: [10, 25, 50, 100],         //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,              //最少允许的列数
        clickToSelect: true,                 //是否启用点击选中行
        singleSelect: false,
        height: 400,                         //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                      //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                     //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [/*{
            checkbox: true
        },*/{
            field: 'wareHouseId',
            title: '店铺编号'
        }, {
            field: 'warehousename',
            title: '店铺名称'
        }, {
            field: 'partNo',
            title: 'SKU编号'
        }, {
            field: 'partdescription',
            title: 'SKU名称'
        }, {
            field: 'startDate',
            title: '开始时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            },
            width: 100
        }, {
            field: 'finishDate',
            title: '结束时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            },
            width: 100
        }, {
            field: 'averageConsumeQty',
            title: '日均消耗',
            width: 100,
            align: 'right',
        }, {
            field: 'promotionDesc',
            title: '描述',
            width: 200
        }, {
            field: 'createdBy',
            title: '创建人',
            width: 100
        }, {
            field: 'createdDate',
            title: '创建时间',
            formatter: function (value, row) {
                var date = formatLinuxDate(value);
                date = date.substring(0, 10);
                return date;
            },
            width: 100
        }
            // , {
            //     field: 'status',
            //     title: '状态',
            //     width: 100
            // }
        ],
        onClickRow: function (row, $element) {
            $('.check_back').removeClass('check_back');
            $($element).addClass('check_back');
            currentRow = row;
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, row, null);
        },
        onLoadSuccess: function (data) {
            var height_param = $(window).height() - 92;
            $('#' + tableTags).parents('.fixed-table-container').css("height", height_param + "px");
            //调用自定义按钮的控制类
            customerBtnControl(tableTags, null, null)
        },
        //>>>>>>>>>>>>>>导出excel表格设置
        showExport: false,              //是否显示导出按钮(此方法是自己写的目的是判断终端是电脑还是手机,电脑则返回true,手机返回falsee,手机不显示按钮)
        exportDataType: "basic",              //basic', 'all', 'selected'.
        exportTypes: ['excel', 'xlsx'],	    //导出类型
        exportButton: $('#download_button'),     //为按钮btn_export  绑定导出事件  自定义导出按钮(可以不用)
        exportOptions: {
            ignoreColumn: [8, 8],            //忽略某一列的索引
            fileName: '库存信息' + generateTimeReqestNumber(),              //文件名称设置
            worksheetName: '库存信息',          //表格工作区名称
            tableName: '库存信息',
            excelstyles: ['background-color', 'color', 'font-size', 'font-weight'],
            onMsoNumberFormat: DoOnMsoNumberFormat
        }
        //导出excel表格设置<<<<<<<<<<<<<<<<
    });
}

//处理搜索，刷新table
function searchPromontion() {
    $('#' + tableTags).bootstrapTable('refresh');
}

// 活动添加 模态框
function addPromotionModal() {
    $('#partList').bootstrapTable('refresh')
    $('#addPromotionModal').modal()
}

// part列表
function partTable() {
    $('#partList').bootstrapTable({
        url: '/part/searchPartWareHouseList',         //请求后台的URL（*）
        method: 'post',                      //请求方式（*）
        //contentType:'application/x-www-form-urlencoded',
        contentType: 'application/json;charset=utf-8',
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                othergroup2: $('#current_username').val(),
                partdescription: $('#addPartDescription').val(),
                warehousename: $('#addWarehouseName').val(),
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //  height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [{
            checkbox: true
        }, {
            field: 'defaultwarehouseid',
            title: '店铺编号',
            width: 200
        }, {
            field: 'warehousename',
            title: '店铺名称',
            width: 200
        }, {
            field: 'partno',
            title: '物料编号',
            width: 200
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200
        }, {
            field: 'othergroup2',
            title: '运营',
            align: 'right',
        }],
        onLoadSuccess: function (data) {
            $('#partList').parents('.bootstrap-table').css("margin-left", "10px");
            $('#partList').parents('.fixed-table-container').css("width", 670 + "px");
            $('#partList').parents('.fixed-table-container').css("height", '300');
        }
    });
}

// 查询part列表
function searchPart() {
    $('#partList').bootstrapTable('refresh')
}

// 初始化页面显示的列
function selectPart() {
    $('#partTable').bootstrapTable({
        striped: true,                      //是否显示行间隔色
        cache: false,                       //是否使用缓存，默认为true，所以一般情况下需要设置一下这个属性（*）
        pagination: false,                   //是否显示分页（*）
        sortable: false,                     //是否启用排序
        sortOrder: "asc",                   //排序方式
        queryParamsType: "undefined",   //排序方式
        queryParams: function queryParams(params) {   //设置查询参数
            var param = {
                site: $('#current_site').val(),
                active: $('#status').val(),
                partdescription: $('#partdescription').val(),
                warehousename: $('#warehousename').val(),
                operating: 1,
                othergroup2: ''
            };
            return JSON.stringify(param);
        },
        sidePagination: "server",           //分页方式：client客户端分页，server服务端分页（*）
        pageNumber: 1,                       //初始化加载第一页，默认第一页
        pageSize: 10,                       //每页的记录行数（*）
        pageList: [10, 25, 50, 100],        //可供选择的每页的行数（*）
        search: false,                       //是否显示表格搜索，此搜索是客户端搜索，不会进服务端，所以，个人感觉意义不大
        searchTimeOut: 1000,
        //  	: true,
        showColumns: false,                  //是否显示所有的列
        showRefresh: false,                  //是否显示刷新按钮
        minimumCountColumns: 2,             //最少允许的列数
        clickToSelect: true,                //是否启用点击选中行
        singleSelect: false,
        //  height: 400,                        //行高，如果没有设置height属性，表格自动根据记录条数觉得表格高度
        uniqueId: "id",                     //每一行的唯一标识，一般为主键列
        //    showToggle: true,                    //是否显示详细视图和列表视图的切换按钮
        cardView: false,                    //是否显示详细视图
        detailView: false,                   //是否显示父子表
        columns: [{
            field: 'defaultwarehouseid',
            title: '店铺编号',
            width: 200
        }, {
            field: 'warehousename',
            title: '店铺名称',
            width: 200
        }, {
            field: 'partno',
            title: '物料编号',
            width: 200
        }, {
            field: 'partdescription',
            title: '物料名称',
            width: 200
        }, {
            field: 'averageConsumeQty',
            title: '日均消耗',
            align: 'right',
            formatter: function (value, row, index) {
                let averageConsumeQty = ' <input type="text" class=".parentNumber" name="averageConsumeQty"  value="" style="width: 100px;border-style:none;" autocomplete="off"  onkeyup="value=value.replace(/[^\\d]/g,\'\')">'
                return averageConsumeQty
            }
        }, {
            field: 'remark',
            title: '备注',
            formatter: function (value, row, index) {
                let promotionDesc = ' <input type="text" class=".parentNumber" name="remark"  value="" style="width: 165px;border-style:none;" autocomplete="off" >'
                return promotionDesc
            }
        }],
        onPostHeader: function (data) {
            $('#partTable').parents('.bootstrap-table').css("margin-left", "10px");
            $('#partTable').parents('.fixed-table-container').css("width", 670 + "px");
            $('#partTable').parents('.fixed-table-container').css("height", '260');
        }
    });
}
var inputs
function addPromotionHist() {
    let partList = $("#partList").bootstrapTable('getSelections')
    $('#partTable').bootstrapTable('load', partList);
    $("#select_modal").modal()
     inputs = document.getElementById("partList").getElementsByTagName("input");
    $("input").keydown(function (event) {
        var thisinput = $(this)[0];
        getfocus(thisinput);
    });
}

//回车和小键盘切换input焦点
function getfocus(thisinput) {
    inputs = document.getElementsByTagName("input");
    let code = event.keyCode
    switch (code){
        case 13:
        case 40:
        case 39:
            for (var i = 0; i < inputs.length; i++) {
                if (thisinput == inputs[i]) {
                    if (i == (inputs.length - 1)) {
                        inputs[0].focus();
                        break;
                    } else {
                        inputs[i + 1].focus();
                        break;
                    }
                }
            }
            break;
        case 37:
        case 38:
            for (var i = 0; i < inputs.length; i++) {
                if (thisinput == inputs[i]) {
                    if (i != 0) {
                        inputs[i - 1].focus();
                        break;
                    } else {
                        inputs[inputs.length - 1].focus();
                        break;
                    }
                }
            }
            break;

    }
}

// 添加活动计划
function addPromotion() {
    let startTime = $('#startDate').val()
    let finisTime = $('#finishDate').val()
    let nowTime = getNowFormatDate()
    console.log(startTime + "----------" + finisTime + "----------" + nowTime)
    if (startTime > finisTime) {
        alert("活动结束时间不能在活动开始时间之前")
        return;
    }

    if (startTime < nowTime) {
        alert("活动开始时间必须在大于等于当前时间")
        return;
    }
    let bool = false
    let promotionHistList = []
    let partList = $("#partList").bootstrapTable('getData')
    let averageConsumeQtyList = $("[name='averageConsumeQty']")
    let remarkList = $("[name='remark']")
    averageConsumeQtyList.each((index, item) => {
        if ($(item).val() == '' || $(item).val() == null) {
            bool = true;
        }
        let partPlan = {
            site: $('#current_site').val(),
            wareHouseId: partList[index].defaultwarehouseid,
            partNo: partList[index].partno,
            promotionDesc: $('#promotionDesc').val(),
            coverDays: partList[index].coverDays,
            startDate: $('#startDate').val(),
            finishDate: $('#finishDate').val(),
            averageConsumeQty: $(item).val(),
            remark: $(remarkList[index]).val(),
            createdBy: $('#current_username').val(),
            status: '进行中'
        }
        promotionHistList.push(partPlan)
    })

    if ($('#startDate').val() == '' || $('#startDate').val() == null) {
        layer.alert('开始时间不能为空')
        return;
    }
    if ($('#finishDate').val() == '' || $('#finishDate').val() == null) {
        layer.alert('结束时间不能为空')
        return;
    }
    if ($('#startDate').val() > $('#finishDate').val()) {
        layer.alert('结束时间不能早于开始时间')
        return;
    }
    if (bool) {
        layer.alert('日消耗数不能为空')
        return;
    }
    $.ajax({
        url: '/promotion/savePromotionHistList',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(promotionHistList),
        dataType: "json",
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#saveClose').click()
                $('#addClose').click()
                $('#activity_data').bootstrapTable('refresh')

            }
        },
        error: function (data) {
            if (data.status == 0) {
                layer.alert("网络连接异常:  "+data.statusText);
                console.info("网络出错");
            }
            if (data.status == 403) {
                //判断是否是session超时
                var responseText = data.responseText;
                var json_str = JSON.parse(responseText);
                var status = json_str.status;
                var message = json_str.message;
                //判断是否是session超时
                if (403 == status) {
                    layer.alert(message, function () {
                        window.location.href = "/login";
                    });
                }
            }
        }
    })
}

// 结束活动
function updatePromotion() {
    let promotionHis = {
        id: currentRow.id,
        status: "已结束"
    }
    $.ajax({
        url: '/promotion/updatePromotionHist',
        contentType: 'application/json',
        type: "POST",
        async: false,
        data: JSON.stringify(promotionHis),
        dataType: "json",
        //timeout: 5000,
        success: function (data) {
            layer.msg(data.msg)
            if (data.success) {
                $('#activity_data').bootstrapTable('refresh')
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    }).done(function (data) {
        // 请求成功
        alert("请求成功")
    }).fail(function (jqXHR, textStatus, errorThrown) {
        // net::ERR_CONNECTION_REFUSED 发生时，也能进入
        alert("请求超时,网络出现问题")
        console.info("网络出错");
    });

}

// 删除活动
function removePromotion() {
    layer.confirm('确定要删除选中的活动信息!', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
        let promotionHis = {
            id: currentRow.id
        }
        $.ajax({
            url: '/promotion/removePromotionHis',
            contentType: 'application/json',
            type: "POST",
            async: false,
            data: JSON.stringify(promotionHis),
            dataType: "json",
            success: function (data) {
                layer.msg(data.msg)
                if (data.success) {
                    $('#activity_data').bootstrapTable('refresh')
                }
            },
            error: function (data) {
                var responseText = data.responseText;
                var json_str = JSON.parse(responseText);
                var status = json_str.status;
                var message = json_str.message;
                //判断是否是session超时
                if (403 == status) {
                    layer.alert(message, function () {
                        window.location.href = "/login";
                    });
                }
                layer.closeAll('loading');
            }
        })
    }, function () {

    });
}





