/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.utils;

import com.xjfast.utils.ImportExcelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImportExcelUtil {
    private static final String REGEX = "[a-zA-Z]";
    private static final Logger log = LoggerFactory.getLogger(ImportExcelUtil.class);

    public static List<List<Object>> importExcelMultipartFile(MultipartFile multipartFile, int startRow, int endRow, Class<?> clazz) throws Exception {
        if (multipartFile == null || multipartFile.isEmpty()) {
            throw new IOException("Excel\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\uff01");
        }
        String name = "Excel" + System.currentTimeMillis();
        File file = File.createTempFile(name, null);
        multipartFile.transferTo(file);
        if (!file.exists()) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a" + file.getName() + "Excel\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        return ImportExcelUtil.importExcelFile((File)file, (int)startRow, (int)endRow, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Object>> importExcelFile(File file, int startRow, int endRow, Class<?> clazz) throws Exception {
        ArrayList<List<Object>> sheetsData = new ArrayList<List<Object>>();
        if (!file.exists()) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a" + file.getName() + "Excel\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        FileInputStream inputStream = null;
        try (Workbook wb = null;){
            inputStream = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)inputStream);
            for (int sheetNumber = 0; sheetNumber < wb.getNumberOfSheets(); ++sheetNumber) {
                ArrayList<Row> rowList = new ArrayList<Row>();
                Sheet sheet = wb.getSheetAt(sheetNumber);
                int lastRowNum = sheet.getLastRowNum();
                Row row = null;
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                for (int i = startRow; i <= lastRowNum + endRow; ++i) {
                    boolean isEmptyRow = true;
                    row = sheet.getRow(i);
                    if (row == null) continue;
                    for (int j = 0; j < row.getLastCellNum(); ++j) {
                        String value = p.matcher(ImportExcelUtil.getCellValue((Cell)row.getCell(j))).replaceAll("");
                        if (value.trim().equals("")) continue;
                        isEmptyRow = false;
                    }
                    if (isEmptyRow) continue;
                    rowList.add(row);
                }
                sheetsData.add(ImportExcelUtil.returnObjectList(rowList, clazz));
            }
        }
        return sheetsData;
    }

    private static List<Object> returnObjectList(List<Row> rowList, Class<?> clazz) {
        ArrayList<Object> objectList = null;
        Object obj = null;
        String attribute = null;
        String value = null;
        int j = 0;
        try {
            objectList = new ArrayList<Object>();
            Field[] declaredFields = clazz.getDeclaredFields();
            for (Row row : rowList) {
                j = 0;
                obj = clazz.newInstance();
                for (Field field : declaredFields) {
                    try {
                        attribute = field.getName().toString();
                        value = ImportExcelUtil.getCellValue((Cell)row.getCell(j));
                        ImportExcelUtil.setAttrributeValue(obj, (String)attribute, (String)value.trim());
                        ++j;
                    }
                    catch (Exception e) {
                        log.info("\u5c5e\u6027\u6620\u5c04\u51fa\u9519\uff0c\u5c5e\u6027\u540d\uff1a" + attribute + "\u5c5e\u6027\u503c\uff1a" + value);
                        e.printStackTrace();
                    }
                }
                objectList.add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectList;
    }

    private static String getCellValue(Cell cell) {
        Object result = "";
        if (cell != null) {
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    result = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    result = cell.getNumericCellValue();
                    break;
                }
                case 3: {
                    result = cell.getBooleanCellValue();
                    break;
                }
                case 4: {
                    result = cell.getCellFormula();
                    break;
                }
                case 5: {
                    result = cell.getErrorCellValue();
                    break;
                }
                case 6: {
                    break;
                }
            }
        }
        return result.toString();
    }

    private static void setAttrributeValue(Object obj, String attribute, String value) {
        Method[] methods;
        if (value == null || value.trim().equals("")) {
            return;
        }
        String method_name = ImportExcelUtil.convertToMethodName((String)attribute, obj.getClass(), (boolean)true);
        for (Method method : methods = obj.getClass().getMethods()) {
            if (!method.getName().equals(method_name)) continue;
            Class<?>[] parameterC = method.getParameterTypes();
            try {
                if (parameterC[0] == Integer.TYPE || parameterC[0] == Integer.class) {
                    int index = value.lastIndexOf(".");
                    if (index != -1) {
                        value = value.substring(0, index);
                    }
                    try {
                        method.invoke(obj, Integer.valueOf(value));
                    }
                    catch (Exception e) {
                        System.out.println(value);
                        e.printStackTrace();
                    }
                    break;
                }
                if (parameterC[0] == Float.TYPE || parameterC[0] == Float.class) {
                    method.invoke(obj, Float.valueOf(value));
                    break;
                }
                if (parameterC[0] == Double.TYPE || parameterC[0] == Double.class) {
                    method.invoke(obj, Double.valueOf(value));
                    break;
                }
                if (parameterC[0] == Byte.TYPE || parameterC[0] == Byte.class) {
                    method.invoke(obj, Byte.valueOf(value));
                    break;
                }
                if (parameterC[0] == Boolean.TYPE || parameterC[0] == Boolean.class) {
                    method.invoke(obj, Boolean.valueOf(value));
                    break;
                }
                if (parameterC[0] == Date.class) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    Date date = null;
                    try {
                        date = sdf.parse(value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    method.invoke(obj, date);
                    break;
                }
                method.invoke(obj, parameterC[0].cast(value));
                break;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    private static String convertToMethodName(String attribute, Class<?> objClass, boolean isSet) {
        Pattern p = Pattern.compile("[a-zA-Z]");
        Matcher m = p.matcher(attribute);
        StringBuilder sb = new StringBuilder();
        if (isSet) {
            sb.append("set");
        } else {
            try {
                Field attributeField = objClass.getDeclaredField(attribute);
                if (attributeField.getType() == Boolean.TYPE || attributeField.getType() == Boolean.class) {
                    sb.append("is");
                } else {
                    sb.append("get");
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (attribute.charAt(0) != '_' && m.find()) {
            sb.append(m.replaceFirst(m.group().toUpperCase()));
        } else {
            sb.append(attribute);
        }
        return sb.toString();
    }
}

