/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.service.impl;

import com.xjfast.entity.ZTreeOutData;
import com.xjfast.entity.dto.RoleInData;
import com.xjfast.entity.dto.RoleMenuInData;
import com.xjfast.entity.dto.UserRoleInData;
import com.xjfast.entity.vo.RoleMenuOutData;
import com.xjfast.entity.vo.RoleOutData;
import com.xjfast.entity.vo.UserRoleOutData;
import com.xjfast.mapper.RoleMapper;
import com.xjfast.mapper.UserMapper;
import com.xjfast.service.RoleService;
import com.xjfast.utils.R;
import com.xjfast.utils.menu.MenuLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ServletContext servletContext;

    public List<RoleOutData> getRolesByCon(RoleInData inData) {
        return this.roleMapper.getRolesByCon(inData);
    }

    public List<ZTreeOutData> getTreeDataByUsername(String username) {
        ArrayList<ZTreeOutData> list = new ArrayList<ZTreeOutData>();
        List roles = this.roleMapper.getALLRolesByCon();
        List userRoles = this.roleMapper.getUserRolesByUsername(username);
        HashMap checked_map = new HashMap();
        for (UserRoleOutData ur : userRoles) {
            checked_map.put(ur.getRoleId(), null);
        }
        for (RoleOutData role : roles) {
            ZTreeOutData tree = new ZTreeOutData();
            tree.setId(String.valueOf(role.getId()));
            tree.setName(role.getRoleName());
            if (checked_map.containsKey(role.getId())) {
                tree.setChecked(true);
            }
            list.add(tree);
        }
        return list;
    }

    public R saveUserRole(String username, String auths, String account) {
        this.roleMapper.delUserRoleByUsername(username);
        if (auths.length() > 0) {
            String[] temp_arr = auths.split(",");
            ArrayList<UserRoleInData> userRoleList = new ArrayList<UserRoleInData>();
            for (int i = 0; i < temp_arr.length; ++i) {
                UserRoleInData temp = new UserRoleInData(username, Integer.parseInt(temp_arr[i]), account, new Date());
                userRoleList.add(temp);
            }
            if (userRoleList.size() > 0) {
                this.roleMapper.batchInsertUserRoles(userRoleList);
            }
        }
        String itemType = String.valueOf(this.servletContext.getAttribute("itemType"));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("menuType", "M");
        paramMap.put("username", username);
        paramMap.put("itemType", itemType);
        List pcUserMenus = this.userMapper.getUserMenus(paramMap);
        paramMap.put("menuType", "P");
        List pdaUserMenus = this.userMapper.getUserMenus(paramMap);
        MenuLoader.processSingleUserMenuTreeMap((List)pcUserMenus, (String)username, (String)"pc_menu_map", (ServletContext)this.servletContext);
        MenuLoader.processSingleUserMenuTreeMap((List)pdaUserMenus, (String)username, (String)"pda_menu_map", (ServletContext)this.servletContext);
        return R.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public R saveRole(RoleInData inData) {
        if (0 == inData.getId()) {
            inData.setCreatedDate(new Date());
            this.roleMapper.insertRole(inData);
            return R.ok((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        inData.setUpdatedDate(new Date());
        this.roleMapper.updateRoleById(inData);
        return R.ok((String)"\u66f4\u65b0\u6210\u529f");
    }

    @Transactional
    public R delRoleById(Map<String, Object> inMap) {
        int roleId = Integer.parseInt(String.valueOf(inMap.get("id")));
        int nums = this.roleMapper.countRoleUser(roleId);
        if (0 == nums) {
            inMap.put("updatedDate", new Date());
            this.roleMapper.delRoleById(inMap);
            this.roleMapper.delRoleResourceByCon(roleId);
            return R.ok((String)"\u5220\u9664\u6210\u529f");
        }
        return R.error((int)500, (String)"\u5220\u9664\u5931\u8d25\uff01\u5f53\u524d\u89d2\u8272\u5b58\u5728\u4f7f\u7528\u7684\u7528\u6237\uff01");
    }

    public List<ZTreeOutData> getTreeDataByRoleId(int roleId) {
        ArrayList<ZTreeOutData> list = new ArrayList<ZTreeOutData>();
        String itemType = String.valueOf(this.servletContext.getAttribute("itemType"));
        List userMenus = this.roleMapper.getAllResources(itemType);
        List checked_function = this.roleMapper.getCheckedMenus(roleId);
        HashMap<String, String> checked_map = new HashMap<String, String>();
        for (String str : checked_function) {
            checked_map.put(str, str);
        }
        for (RoleMenuOutData rm : userMenus) {
            if (!"1".equals(rm.getParentResource())) continue;
            list.add(this.findSubNodes(rm, userMenus, checked_map));
        }
        return list;
    }

    private ZTreeOutData findSubNodes(RoleMenuOutData rm, List<RoleMenuOutData> userMenus, Map<String, Object> checked_map) {
        ZTreeOutData tree = new ZTreeOutData();
        String id = rm.getResourceId();
        tree.setId(id);
        tree.setName(rm.getResourceName());
        tree.setpId(rm.getParentResource());
        if (checked_map.containsKey(id)) {
            tree.setChecked(true);
        }
        ArrayList<ZTreeOutData> childrens = new ArrayList<ZTreeOutData>();
        for (RoleMenuOutData subMenu : userMenus) {
            if (!rm.getResourceId().equals(subMenu.getParentResource())) continue;
            childrens.add(this.findSubNodes(subMenu, userMenus, checked_map));
        }
        if (childrens.size() > 0) {
            tree.setChildren(childrens);
        }
        return tree;
    }

    @Transactional
    public R saveRoleResource(int roleId, String auths, String username) {
        this.roleMapper.delRoleResourceByCon(roleId);
        if (auths.length() > 0) {
            String[] temp_arr = auths.split(",");
            ArrayList<RoleMenuInData> tempMenus = new ArrayList<RoleMenuInData>();
            for (int i = 0; i < temp_arr.length; ++i) {
                RoleMenuInData tempMenu = new RoleMenuInData(temp_arr[i], roleId, username, new Date());
                tempMenus.add(tempMenu);
            }
            if (tempMenus.size() > 0) {
                this.roleMapper.batchInsertRoleResource(tempMenus);
            }
        }
        String itemType = String.valueOf(this.servletContext.getAttribute("itemType"));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("menuType", "M");
        paramMap.put("username", null);
        paramMap.put("itemType", itemType);
        List pcUserMenus = this.userMapper.getUserMenus(paramMap);
        paramMap.put("menuType", "P");
        List pdaUserMenus = this.userMapper.getUserMenus(paramMap);
        MenuLoader.processUserMenuTreeMap((List)pcUserMenus, (String)"pc_menu_map", (ServletContext)this.servletContext);
        MenuLoader.processUserMenuTreeMap((List)pdaUserMenus, (String)"pda_menu_map", (ServletContext)this.servletContext);
        return R.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

