/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xjfast.entity.MrpPlanData;
import com.xjfast.entity.query.CodelheaderQuery;
import com.xjfast.entity.query.MrpPlanDataQuery;
import com.xjfast.entity.query.PromotionHistQuery;
import com.xjfast.entity.vo.MrpPlanDataVo;
import com.xjfast.entity.vo.PromotionHistVo;
import com.xjfast.mapper.CodelheaderMapper;
import com.xjfast.mapper.MrpPlanDataMapper;
import com.xjfast.mapper.PromotionHistMapper;
import com.xjfast.service.MrpPlanDataService;
import com.xjfast.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MrpPlanDataServiceImpl
extends ServiceImpl<MrpPlanDataMapper, MrpPlanData>
implements MrpPlanDataService {
    @Autowired
    private MrpPlanDataMapper mrpPlanDataMapper;
    @Autowired
    private CodelheaderMapper codelheaderMapper;
    @Autowired
    private PromotionHistMapper promotionHistMapper;

    public void removeMrpPlan(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.removeMrpPlan(mrpPlanDataQuery);
    }

    public List<MrpPlanDataVo> searchMrpPlanDataList(MrpPlanDataQuery mrpPlanDataQuery) {
        return this.mrpPlanDataMapper.searchMrpPlanDataList(mrpPlanDataQuery);
    }

    public void globalPlan(MrpPlanDataQuery mrpPlanDataQuery) {
        this.insertMrpPlanData(mrpPlanDataQuery);
        MrpPlanDataQuery planDataQuery = mrpPlanDataQuery;
        planDataQuery.setWareHouseId(mrpPlanDataQuery.getWareHouseId());
        planDataQuery.setPartNo(mrpPlanDataQuery.getPartNo());
        planDataQuery.setSite(mrpPlanDataQuery.getSite());
        planDataQuery.setWareHouseTypeDb("P");
        planDataQuery.setCalculationType("MPS");
        this.insertProductionPlan(planDataQuery);
    }

    public void insertMrpPlanData(MrpPlanDataQuery mrpPlanDataQuery) {
        String partNo = mrpPlanDataQuery.getPartNo();
        String wareHouseId = mrpPlanDataQuery.getWareHouseId();
        if ("%".equals(wareHouseId)) {
            mrpPlanDataQuery.setWareHouseId("");
        }
        if ("%".equals(partNo)) {
            mrpPlanDataQuery.setPartNo("");
        }
        this.deleteMrpPlanData(mrpPlanDataQuery);
        this.insertMrpInventoryStock(mrpPlanDataQuery);
        this.insertMrpCode(mrpPlanDataQuery);
        this.insertDaysMrp(mrpPlanDataQuery);
        this.searchPromotionHistList(mrpPlanDataQuery);
        this.insertInventoryMaintain(mrpPlanDataQuery);
        this.temporaryStocking(mrpPlanDataQuery);
        this.removeDelivryRequisition(mrpPlanDataQuery);
        mrpPlanDataQuery.setPlanDesc("\u4e34\u65f6\u8865\u8d27");
        this.insertDelivryRequisition(mrpPlanDataQuery);
        this.removeMrpPlanLs(mrpPlanDataQuery);
    }

    public void insertProductionPlan(MrpPlanDataQuery mrpPlanDataQuery) {
        String partNo = mrpPlanDataQuery.getPartNo();
        String wareHouseId = mrpPlanDataQuery.getWareHouseId();
        if ("%".equals(wareHouseId)) {
            mrpPlanDataQuery.setWareHouseId("");
        }
        if ("%".equals(partNo)) {
            mrpPlanDataQuery.setPartNo("");
        }
        this.deleteMrpPlanData(mrpPlanDataQuery);
        this.insertMrpInventoryStock(mrpPlanDataQuery);
        this.insertShopMrp(mrpPlanDataQuery);
        this.insertMpsPlan(mrpPlanDataQuery);
        this.insertInventoryMaintain(mrpPlanDataQuery);
        this.removerShopOrderRequisiton(mrpPlanDataQuery);
        this.insertShopOrderRequisition(mrpPlanDataQuery);
    }

    public void insertShoppingPlan(MrpPlanDataQuery mrpPlanDataQuery) {
        String partNo = mrpPlanDataQuery.getPartNo();
        String wareHouseId = mrpPlanDataQuery.getWareHouseId();
        if ("%".equals(wareHouseId)) {
            mrpPlanDataQuery.setWareHouseId("");
        }
        if ("%".equals(partNo)) {
            mrpPlanDataQuery.setPartNo("");
        }
        this.deleteMrpPlanData(mrpPlanDataQuery);
        this.insertMrpInventoryStock(mrpPlanDataQuery);
    }

    private void deleteMrpPlanData(MrpPlanDataQuery mrpPlanDataQuery) {
        MrpPlanData delMroPlan = new MrpPlanData();
        delMroPlan.setWareHouseId(mrpPlanDataQuery.getWareHouseId());
        delMroPlan.setPartNo(mrpPlanDataQuery.getPartNo());
        this.mrpPlanDataMapper.removeMrpPlan(mrpPlanDataQuery);
    }

    private void insertMrpInventoryStock(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.insertMrpInventoryStock(mrpPlanDataQuery);
    }

    private void insertMrpCode(MrpPlanDataQuery mrpPlanDataQuery) {
        String partNo = mrpPlanDataQuery.getPartNo();
        String wareHouseId = mrpPlanDataQuery.getWareHouseId();
        CodelheaderQuery codelheaderQuery = new CodelheaderQuery();
        codelheaderQuery.setWarehouseId(wareHouseId);
        codelheaderQuery.setPartNo(partNo);
        codelheaderQuery.setActive("Y");
        codelheaderQuery.setCalculationType(mrpPlanDataQuery.getCalculationType());
        codelheaderQuery.setOtherGroup2(mrpPlanDataQuery.getOtherGroup2());
        this.mrpPlanDataMapper.insertMrpCode(codelheaderQuery);
    }

    private void insertShopMrp(MrpPlanDataQuery mrpPlanDataQuery) {
        MrpPlanDataQuery query = new MrpPlanDataQuery();
        BeanUtils.copyProperties((Object)mrpPlanDataQuery, (Object)query);
        query.setPlanDate(DateUtils.getFastDate((int)mrpPlanDataQuery.getDays()));
        this.mrpPlanDataMapper.insertShopMrp(mrpPlanDataQuery);
    }

    private void insertDaysMrp(MrpPlanDataQuery mrpPlanDataQuery) {
        for (int i = 0; i < mrpPlanDataQuery.getDays(); ++i) {
            Date date = DateUtils.getFastDate((int)i);
            MrpPlanDataQuery query = new MrpPlanDataQuery();
            query.setWareHouseTypeDb(mrpPlanDataQuery.getWareHouseTypeDb());
            query.setPlanDate(date);
            query.setCalculationType(mrpPlanDataQuery.getCalculationType());
            query.setWareHouseId(mrpPlanDataQuery.getWareHouseId());
            query.setPartNo(mrpPlanDataQuery.getPartNo());
            query.setOtherGroup2(mrpPlanDataQuery.getOtherGroup2());
            this.mrpPlanDataMapper.insertDaysMrp(query);
        }
    }

    private void temporaryStocking(MrpPlanDataQuery mrpPlanDataQuery) {
        for (int i = 0; i < mrpPlanDataQuery.getDays() + 1; ++i) {
            Date date = DateUtils.getFastDate((int)i);
            MrpPlanDataQuery query = new MrpPlanDataQuery();
            query.setWareHouseTypeDb(mrpPlanDataQuery.getWareHouseTypeDb());
            query.setPlanDate(date);
            query.setCalculationType(mrpPlanDataQuery.getCalculationType());
            query.setSite(mrpPlanDataQuery.getSite());
            query.setOtherGroup2(mrpPlanDataQuery.getOtherGroup2());
            this.mrpPlanDataMapper.insertTemporaryStocking(query);
        }
    }

    private void searchPromotionHistList(MrpPlanDataQuery mrpPlanDataQuery) {
        Integer day;
        PromotionHistQuery promotionHistQuery = new PromotionHistQuery();
        promotionHistQuery.setSite(mrpPlanDataQuery.getSite());
        promotionHistQuery.setPartNo(mrpPlanDataQuery.getPartNo());
        promotionHistQuery.setWareHouseId(mrpPlanDataQuery.getWareHouseId());
        promotionHistQuery.setStatus("\u8fdb\u884c\u4e2d");
        promotionHistQuery.setOtherGroup2(mrpPlanDataQuery.getOtherGroup2());
        List promotionHistVos = this.promotionHistMapper.searchPromotionHistList(promotionHistQuery);
        ArrayList<MrpPlanData> list = new ArrayList<MrpPlanData>();
        Date startDate = null;
        Date endDate = null;
        if (promotionHistVos.size() > 0) {
            startDate = ((PromotionHistVo)promotionHistVos.get(0)).getStartDate();
            endDate = ((PromotionHistVo)promotionHistVos.get(0)).getFinishDate();
            for (int i = 0; i < promotionHistVos.size(); ++i) {
                PromotionHistVo promotionHistVo = (PromotionHistVo)promotionHistVos.get(i);
                promotionHistVo.setAverageConsumeQty(promotionHistVo.getAverageConsumeQty());
                boolean bool = this.mrpPlanDataMapper.updateMrpHis(promotionHistVo);
                if (bool) continue;
                MrpPlanData mrpPlanData = new MrpPlanData();
                mrpPlanData.setPlanDesc("\u6d3b\u52a8\u6d88\u8017");
                mrpPlanData.setDirection("-");
                mrpPlanData.setCalculationType("MS");
                mrpPlanData.setWareHouseId(promotionHistVo.getWareHouseId());
                mrpPlanData.setPlanQty(Double.valueOf(promotionHistVo.getAverageConsumeQty().doubleValue()));
                mrpPlanData.setSite(promotionHistVo.getSite());
                mrpPlanData.setPartNo(promotionHistVo.getPartNo());
                mrpPlanData.setCreatedBy(promotionHistVo.getCreatedBy());
                list.add(mrpPlanData);
            }
        }
        if ((day = Integer.valueOf(DateUtils.differentDaysByMillisecond(startDate, endDate))) > mrpPlanDataQuery.getDays()) {
            day = mrpPlanDataQuery.getDays();
        }
        for (int i = 0; i <= day; ++i) {
            Date planDate = DateUtils.specifiedTimeDay((Date)startDate, (int)i);
            List mrpPlanDataList = list.stream().map(item -> {
                item.setPlanDate(planDate);
                return item;
            }).collect(Collectors.toList());
            if (mrpPlanDataList.size() <= 0) continue;
            this.mrpPlanDataMapper.insertMrpPlanList(mrpPlanDataList);
        }
    }

    private void insertMpsPlan(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.insertMpsPlan(mrpPlanDataQuery);
    }

    private void insertInventoryMaintain(MrpPlanDataQuery mrpPlanDataQuery) {
        mrpPlanDataQuery.setPlanDate(DateUtils.getFastDate((int)mrpPlanDataQuery.getDays()));
        this.mrpPlanDataMapper.insertInventoryMaintain(mrpPlanDataQuery);
    }

    private void removeDelivryRequisition(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.removeDelivryRequisition(mrpPlanDataQuery);
    }

    private void removerShopOrderRequisiton(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.reomveShopOrderRequisition(mrpPlanDataQuery);
    }

    private void insertDelivryRequisition(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.addMrpPlanData(mrpPlanDataQuery);
        this.mrpPlanDataMapper.addDelivryRequisition(mrpPlanDataQuery);
    }

    private void insertShopOrderRequisition(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.insertMrpShopOrder(mrpPlanDataQuery);
        this.mrpPlanDataMapper.insertShopOrderRequisition(mrpPlanDataQuery);
    }

    private void removeMrpPlanLs(MrpPlanDataQuery mrpPlanDataQuery) {
        this.mrpPlanDataMapper.removeMrpPlanLs(mrpPlanDataQuery);
    }
}

