/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.service.impl;

import com.xjfast.entity.FileInfoData;
import com.xjfast.entity.dto.FileInfoDto;
import com.xjfast.mapper.FileInfoMapper;
import com.xjfast.service.FileInfoService;
import com.xjfast.service.FileService;
import com.xjfast.utils.FTPManager;
import com.xjfast.utils.FTPUtils;
import com.xjfast.utils.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    @Autowired
    FileInfoMapper fileInfoMapper;
    @Autowired
    private FileInfoService fileInfoService;
    @Value(value="${file.information.path}")
    private String path;
    @Value(value="${com.ftp.ftpHost}")
    private String ftpHost;
    @Value(value="${com.ftp.ftpPort}")
    private Integer ftpPort;
    @Value(value="${com.ftp.ftpUser}")
    private String ftpUser;
    @Value(value="${com.ftp.ftpPassword}")
    private String ftpPassword;
    @Value(value="${com.ftp.ftpDir}")
    private String ftpDir;
    @Value(value="${com.ftp.down}")
    private String downPath;

    public List<File> download(String[] arr, HttpServletResponse response) {
        FTPManager mana = FTPManager.getInstance();
        ArrayList<File> fileslist = new ArrayList<File>();
        String host = this.ftpHost;
        Integer port = this.ftpPort;
        String user = this.ftpUser;
        String password = this.ftpPassword;
        String dir = this.ftpDir;
        String path = "";
        String localPath = "";
        File file = null;
        mana.setInfo(host, port.intValue(), user, password, dir);
        try {
            for (int i = 0; i < arr.length; ++i) {
                List inData = this.fileInfoMapper.getbyid(Integer.parseInt(arr[i]));
                String ph = ((FileInfoData)inData.get(0)).getFilePath().substring(((FileInfoData)inData.get(0)).getFilePath().lastIndexOf("."));
                String fileName = ((FileInfoData)inData.get(0)).getFileName();
                if (".pdf".equals(ph)) {
                    localPath = File.separator + fileName;
                    path = mana.download(((FileInfoData)inData.get(0)).getFilePath(), localPath, true);
                    file = new File(File.separator + fileName);
                } else if (".sv".equals(ph)) {
                    localPath = File.separator + fileName;
                    path = mana.download(((FileInfoData)inData.get(0)).getFilePath(), localPath, true);
                    localPath = File.separator + "DWG_" + ((FileInfoData)inData.get(0)).getFileName() + ".pdf";
                    file = new File(File.separator + ((FileInfoData)inData.get(0)).getFileName() + ".pdf");
                } else {
                    localPath = File.separator + fileName;
                    path = mana.download(((FileInfoData)inData.get(0)).getFilePath(), localPath, true);
                    file = new File(path);
                }
                response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
                fileslist.add(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileslist;
    }

    public Map<String, Object> downloadFile(String fileName, HttpServletResponse response) {
        return FTPUtils.downFtpFile((String)this.ftpHost, (int)this.ftpPort, (String)this.ftpUser, (String)this.ftpPassword, (String)this.ftpDir, (String)fileName, (HttpServletResponse)response);
    }

    public Map<String, Object> downloadFileUrl(String fileUrl, HttpServletResponse response) {
        String fileName = fileUrl.substring(fileUrl.lastIndexOf(47) + 1);
        String path = fileUrl.substring(1, fileUrl.length() - fileName.length());
        return FTPUtils.downFtpFile((String)this.ftpHost, (int)this.ftpPort, (String)this.ftpUser, (String)this.ftpPassword, (String)path, (String)fileName, (HttpServletResponse)response);
    }

    public HttpServletResponse downloadFiles(String fileName, HttpServletResponse response) {
        String filePath = this.path + "\\" + fileName;
        return FTPUtils.download((String)filePath, (HttpServletResponse)response);
    }

    public R uploadFile(FileInfoDto fileInfoDto) {
        R r = new R();
        String name = fileInfoDto.getFile().getOriginalFilename().replaceAll(" ", "_");
        String names = name.substring(0, name.lastIndexOf("."));
        String prefix = name.substring(name.lastIndexOf(".") + 1);
        String dir = this.ftpDir + '/' + fileInfoDto.getFolder();
        String fileName = names + "." + prefix;
        String pathFile = dir + "/" + fileName;
        fileInfoDto.setFileType(prefix);
        fileInfoDto.setFilePath(pathFile);
        fileInfoDto.setOriFileName(name);
        fileInfoDto.setEnteredBy(fileInfoDto.getUsername());
        fileInfoDto.setEnteredDate(new Date());
        fileInfoDto.setDeleteFlag("N");
        fileInfoDto.setStatus("Y");
        try {
            InputStream inputStream = fileInfoDto.getFile().getInputStream();
            FileInputStream fs = (FileInputStream)inputStream;
            this.fileInfoService.insert(fileInfoDto);
            r = FTPUtils.uploadFtpFile((String)this.ftpDir, (int)this.ftpPort, (String)this.ftpUser, (String)this.ftpPassword, (String)fileInfoDto.getFolder(), (FileInputStream)fs, (String)pathFile);
        }
        catch (Exception e) {
            r.put("flag", (Object)false);
            r.put("rows", (Object)e);
            r.put("msg", (Object)e.getMessage());
        }
        return r;
    }
}

