/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class CustomUserDetailsService
implements UserDetailsService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        List users = this.jdbcTemplate.queryForList("SELECT * FROM Users WHERE Status = 'N' AND UserID = ?", new Object[]{username});
        if (users.size() == 0) {
            throw new BadCredentialsException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Map user = (Map)users.get(0);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if ("Y".equals(user.get("Administrator"))) {
            authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        }
        this.logger.info("\u7528\u6237\u767b\u5f55\u6210\u529f\uff1a" + username);
        String password = this.passwordEncoder.encode((CharSequence)String.valueOf(user.get("Password")));
        return new User(user.get("UserID").toString(), password, authorities);
    }
}

