/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.controller;

import com.xjfast.entity.Warehouse;
import com.xjfast.entity.query.WarehouseQuery;
import com.xjfast.service.WareHouseService;
import com.xjfast.utils.ParameterUtils;
import com.xjfast.utils.R;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"ware"})
@RestController
public class WareHouseController {
    @Autowired
    private WareHouseService wareHouseService;

    @PostMapping(value={"searchWareHouseList"})
    public R searchWareHouseList(@RequestBody WarehouseQuery warehouseQuery) {
        try {
            List warehouseVos = this.wareHouseService.searchWareHouseList(warehouseQuery);
            return R.ok().put("rows", (Object)warehouseVos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((int)500, (String)("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38:" + e.getMessage()));
        }
    }

    @PostMapping(value={"addWareHouse"})
    public R addWareHouse(@RequestBody Warehouse warehouse) {
        try {
            if (!ParameterUtils.validParams((Object[])new Object[]{warehouse.getWarehouseid()}) && this.wareHouseService.getWarehouse(warehouse) != null) {
                return R.error((int)500, (String)"\u5e97\u94fa\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            if (this.wareHouseService.addWareHouse(warehouse).booleanValue()) {
                return R.ok((String)"\u6dfb\u52a0\u5e97\u94fa\u4fe1\u606f\u6210\u529f");
            }
            return R.ok((String)"\u6dfb\u52a0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((int)500, (String)"\u6dfb\u52a0\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
        }
    }

    @PostMapping(value={"updateWareHouse"})
    public R updateWareHouse(@RequestBody Warehouse warehouse) {
        try {
            if (this.wareHouseService.updateWareHouse(warehouse).booleanValue()) {
                return R.ok((String)"\u4fee\u6539\u5e97\u94fa\u4fe1\u606f\u6210\u529f");
            }
            return R.error((int)200, (String)"\u4fee\u6539\u5e97\u94fa\u4fe1\u606f\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.error((int)500, (String)("\u4fee\u6539\u5e97\u94fa\u4fe1\u606f\u5931\u8d25" + e.getCause()));
        }
    }
}

