/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.controller;

import com.xjfast.entity.dto.RoleInData;
import com.xjfast.entity.dto.UserInData;
import com.xjfast.service.RoleService;
import com.xjfast.service.UserService;
import com.xjfast.utils.R;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u7528\u6237\u8d44\u6e90"})
@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @PostMapping(value={"/getUserDataByCon"})
    @ResponseBody
    public R getUserDataByCon(@RequestBody UserInData inData) {
        R r = new R();
        try {
            List users = this.userService.getUserDataByCon(inData);
            r.put("rows", (Object)users);
            r.put("total", (Object)users.size());
        }
        catch (Exception e) {
            r.put("msg", (Object)e.getMessage());
            r.put("code", (Object)"500");
        }
        return r;
    }

    @PostMapping(value={"/getTreeDataByUsername"})
    @ResponseBody
    public R getTreeDataByUsername(String username) {
        R r = new R();
        try {
            List resultList = this.roleService.getTreeDataByUsername(username);
            r.put("rows", (Object)resultList);
            r.put("size", (Object)resultList.size());
        }
        catch (Exception e) {
            r.put("msg", (Object)e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/getRoleDataByCon"})
    @ResponseBody
    public R getRoleDataByCon(@RequestBody RoleInData inData) {
        R r = new R();
        try {
            List rows = this.roleService.getRolesByCon(inData);
            r.put("rows", (Object)rows);
            r.put("total", (Object)rows.size());
        }
        catch (Exception e) {
            r.put("msg", (Object)e.getMessage());
            r.put("code", (Object)"500");
        }
        return r;
    }

    @PostMapping(value={"/saveRole"})
    @ResponseBody
    public R saveRole(RoleInData inData) {
        R r = new R();
        try {
            r = this.roleService.saveRole(inData);
        }
        catch (Exception e) {
            R.error((int)500, (String)e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/delRoleById"})
    @ResponseBody
    public R delRole(@RequestBody Map<String, Object> inMap) {
        R r = new R();
        try {
            r = this.roleService.delRoleById(inMap);
        }
        catch (Exception e) {
            R.error((int)500, (String)e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/saveUserRole"})
    @ResponseBody
    public R saveUserRole(String username, String auths, String account) {
        R r = new R();
        try {
            r = this.roleService.saveUserRole(username, auths, account);
        }
        catch (Exception e) {
            R.error((int)500, (String)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/getTreeDataByRoleId"})
    @ResponseBody
    public R getTreeDataByRoleId(int roleId) throws Exception {
        R r = new R();
        try {
            List resultList = this.roleService.getTreeDataByRoleId(roleId);
            r.put("rows", (Object)resultList);
            r.put("total", (Object)resultList.size());
        }
        catch (Exception e) {
            r.put("msg", (Object)e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/saveRoleResource"})
    @ResponseBody
    public R saveAuth(int roleId, String auths, String username) {
        R r = new R();
        try {
            r = this.roleService.saveRoleResource(roleId, auths, username);
        }
        catch (Exception e) {
            R.error((int)500, (String)e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/initMenus"})
    @ResponseBody
    public R initMenus() {
        R r = new R();
        try {
            this.userService.initMenus();
            R.ok((String)"\u83dc\u5355\u521d\u59cb\u5316\u6210\u529f!");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return r;
    }

    @PostMapping(value={"/getaddname"})
    @ResponseBody
    public R getaddname() throws Exception {
        R r = new R();
        try {
            List resultList = this.userService.getaddname();
            r.put("rows", (Object)resultList);
            r.put("total", (Object)resultList.size());
        }
        catch (Exception e) {
            R.error((int)500, (String)e.getMessage());
        }
        return r;
    }
}

