/*
 * Decompiled with CFR 0.152.
 */
package com.xjfast.controller;

import com.xjfast.entity.query.InventoryStockQuery;
import com.xjfast.entity.vo.TransDetailVo;
import com.xjfast.service.InventoryStockService;
import com.xjfast.utils.ImportExcelUtil;
import com.xjfast.utils.R;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"inventory"})
@RestController
public class InventoryStockController {
    @Autowired
    private InventoryStockService inventoryStockService;

    @PostMapping(value={"searchInventoryList"})
    public R searchInventoryList(@RequestBody InventoryStockQuery inventoryStockQuery) {
        try {
            List inventoryStockVos = this.inventoryStockService.searchInventoryList(inventoryStockQuery);
            return R.ok().put("rows", (Object)inventoryStockVos);
        }
        catch (Exception e) {
            return R.error((int)500, (String)e.getMessage());
        }
    }

    @PostMapping(value={"saveInventoryList"})
    public R saveInventoryList(@RequestParam(value="file") MultipartFile file, @RequestParam(value="userName") String userName, @RequestParam(value="site") String site) {
        List excelData = null;
        try {
            excelData = ImportExcelUtil.importExcelMultipartFile((MultipartFile)file, (int)1, (int)0, TransDetailVo.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (excelData == null || excelData.isEmpty()) {
            return R.error((int)500, (String)"\u5bfc\u5165\u5931\u8d25,Excel\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.inventoryStockService.saveInventoryList(excelData, userName, site);
        return R.ok((String)"\u6570\u636e\u5bfc\u5165\u6210\u529f");
    }
}

