$(function () {
    //	初始化供应商
    initSupplier();

});

//初始化供应商信息
function initSupplier() {
    var jsonData = {
        site: $('#current_site').val(),
    }
    $.ajax({
        url: "/toolPda/getSupplierList",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(jsonData),//你的formid
        dataType: "JSON",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                var rows = data.rows;
                $("#supplier_table").html('');
                var str = ''
                for (var i = 0; i < rows.length; i++) {
                    let supplier = rows[i].supplierid+"|" +rows[i].suppliername
                    str += '<tr>' +
                        '<th class="" >' +
                        '<button  data-toggle="modal" onclick="goPurchaseReturn(\'' + supplier + '\')" style="padding: 3px 10px;">' +
                        '选择</button>' +
                        '<th class="" >' +
                        '<span>' + rows[i].supplierid + '</span></th>' +
                        '<th class="" >' +
                        '<span>' + rows[i].suppliername + '</span></th>' +
                        '</tr>';
                }
                $("#supplier_table").html(str);

            } else if (data.code == '401') {
                window.location.href = "/login";
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}


// 执行返回主界面清除缓存信息
function goBackHome() {
    var token = {
        "token": $.cookie("token")
    }
    $.ajax({
        url: "/qa/goBackHome",
        type: "POST",
        data: token,
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var code = data.code;
            if (code == '200') {
                window.location.href = "/pda/publicMenu?titleName=''&menuId=0";
            }
        },
        error: function (data) {
            layer.alert(data.msg);
        }
    });
}

function goPurchaseReturn(item){
    localStorage.setItem("supplier",item)
    window.location.href='/pda/purchaseReturn'
}