var rollList = []

//物料号bind 回车事件
$("#rollno").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollno").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
            return false;
        } else {
            getRollInfo(rollNo);
            $("#rollNo").val('');
            $("#rollNo").focus();
            return false;
        }
    }
    return true;
});

// 获取扫描卷
function getRollInfo(rollNo) {
    let roll = {
        "rollno": rollNo,
    //    "statusDb": "I"
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/infoRollno",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {

             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                if (!data.cRollinfo){
                    layer.alert("该卷不存在");
                    $('#rollQty').val('')
                    $('#rollno').val('')
                    return;
                }
                if(data.cRollinfo.statusDb != 'I'){
                    layer.alert("该卷的状态为: "+data.cRollinfo.status);
                    $('#rollQty').val('')
                    $('#rollno').val('')
                    return;
                }
                $('#rollQty').val( data.cRollinfo.rollqty)
            } else {
                layer.alert('该卷不存在');
                $('#rollQty').val('')
                $('#rollno').val('')
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }

        },
        error: function (data) {
        }
    });
}



// 拆卷
function splitRoll() {
    $("#roll_table").html('');
    rollList = []
    let rollVo = {
        "rollno": $('#rollno').val(),
        "statusDb": "I",
        "pickQty": $('#pickQty').val(),
    }

    $.ajax({
        url: "/finishedProduct/crollinfo/splitRoll",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollVo),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                roll = data.rollList
                rollList =  data.rollList
                roll.forEach((item, index) => {
                    var str = '<tr id = ' + item.line+item.pickingNo + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollno + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollqty + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button   onclick="printRoll(\'' + item.rollno + '\')" data-toggle="modal"  style="padding: 3px 10px;">' +
                        '打印标签</button></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                })
                $('#rollno').val('')
                $('#pickQty').val('')
                $('#rollQty').val('')
                print(data.rollList)
            }
            if (data.code == 201) {
                layer.alert(data.msg)
            }
            if (data.code == 202) {
                layer.alert(data.msg)
            }else {
                layer.alert(data.msg)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}
// 补打标签
function printRoll(rollno){
    var rolls = rollList.filter( item => item.rollno == rollno)
    print(rolls);
}

// 打印卷标签
function print(val){
    var rollPrintList = val
    if (rollPrintList.length <= 0) {
        return;
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/rollPrint",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollPrintList),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                layer.alert("打印成功")
                rollPrintList = []
            }
            if (data.code == 500){
                layer.alert(data.msg)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}



