//初始化
$(function () {

});


//卷号bind 回车事件
$("#rollNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollNo").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
        } else {
            getRollInfo(rollNo);
            return false;
        }
    }
    return true;
});

var rollList = []
var rollInfoData = {}

function getRollInfo(rollNo) {
    let roll = {
        "rollno": rollNo,
       // "statusDb": "I"
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/outRollno",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                rollInfoData = data.cRollinfo;
                if (rollInfoData) {
                    if(rollInfoData.statusDb != 'I'){
                        layer.alert("该卷的状态为: "+rollInfoData.status);
                        $("#rollNo").val('');
                        $("#rollNo").focus();
                        return;
                    }
                    var rollBool = rollList.some(item => item.rollno === rollInfoData.rollno)
                    if (rollBool) {
                        layer.alert('该卷号已存在');
                        $("#rollNo").val('');
                        $("#rollNo").focus();
                        return
                    }
                    rollList.push(rollInfoData)
                    var str = '<tr id = ' + rollInfoData.rollno + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button  data-toggle="modal" onclick="removeRoll(\'' + rollInfoData.rollno + '\')" style="padding: 3px 10px;">' +
                        '删除</button>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + rollInfoData.rollno + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + rollInfoData.partno + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + rollInfoData.rollqty + '</span></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                    $("#rollNo").val('');
                    $("#rollNo").focus();
                } else {
                    layer.alert('该卷不存在');
                    $("#rollNo").val('');
                    $("#rollNo").focus();
                }
            } else {
                layer.alert('该卷不存在');
            }
            if (data.code == 500) {
                layer.alert(data.msg);
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 删除扫描内容
function removeRoll(rollNo) {
    $table = $("#roll_table tr");
    $("tr[id='" + rollNo + "']").remove();
    rollList = rollList.filter(item => item.rollno != rollNo)
    $("#rollNo").val('');
    $("#rollNo").focus();
}

// 确认其它出库
function otherOutbound() {
    if(rollList.length == 0){
        layer.alert("请扫描卷在出库")
        return
    }
    rollList.map( item => {
        item.status = "已耗用"
        item.statusDb = "D"
        // todo 是否需要同步
        //  item.synchronizedflag="Y"
        return item;
    })
    $.ajax({
        url: "/finishedProduct/crollinfo/batchRollUpdateStatus",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollList),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                $("#rollNo").val('');
                $("tr[id]").remove();
                rollList = []
                layer.alert('出库成功');
            } else {
                layer.alert('出库失败');
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}