/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.Query;
import com.gaotao.modules.sys.dao.SysRoleDao;
import com.gaotao.modules.sys.entity.SysRoleEntity;
import com.gaotao.modules.sys.service.SysMsgService;
import com.gaotao.modules.sys.service.SysRoleMenuService;
import com.gaotao.modules.sys.service.SysRoleService;
import com.gaotao.modules.sys.service.SysUserRoleService;
import com.gaotao.modules.sys.service.SysUserService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysRoleService")
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleDao, SysRoleEntity>
implements SysRoleService {
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysMsgService sysMsgService;

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        String roleName = (String)params.get("roleName");
        Long createUserId = (Long)params.get("createUserId");
        IPage page = this.page(new Query().getPage(params), (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like(StringUtils.isNotBlank((String)roleName), (Object)"role_name", (Object)roleName)).eq(createUserId != null, (Object)"create_user_id", (Object)createUserId)).orderByAsc((Object)"role_id"));
        return new PageUtils(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveRole(SysRoleEntity role) {
        role.setCreateTime(new Date());
        this.save(role);
        this.checkPrems(role);
        this.sysRoleMenuService.saveOrUpdate(role.getRoleId(), role.getMenuIdList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SysRoleEntity role) {
        this.updateById(role);
        this.checkPrems(role);
        this.sysRoleMenuService.saveOrUpdate(role.getRoleId(), role.getMenuIdList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] roleIds) {
        this.removeByIds(Arrays.asList(roleIds));
        this.sysRoleMenuService.deleteBatch(roleIds);
        this.sysUserRoleService.deleteBatch(roleIds);
    }

    @Override
    public List<Long> queryRoleIdList(Long createUserId) {
        return ((SysRoleDao)this.baseMapper).queryRoleIdList(createUserId);
    }

    private void checkPrems(SysRoleEntity role) {
        if (role.getCreateUserId() == 1L) {
            return;
        }
        List<String> menuIdList = this.sysUserService.queryAllMenuId(role.getCreateUserId());
        if (!menuIdList.containsAll(role.getMenuIdList())) {
            throw new XJException(this.sysMsgService.getLanguageMsg("200219"));
        }
    }
}

