/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaotao.common.utils.Constant;
import com.gaotao.common.utils.MapUtils;
import com.gaotao.modules.sys.dao.SysMenuDao;
import com.gaotao.modules.sys.entity.SysMenuEntity;
import com.gaotao.modules.sys.entity.SysObjectLanguageMenu;
import com.gaotao.modules.sys.service.SysMenuService;
import com.gaotao.modules.sys.service.SysObjectLanguageMenuService;
import com.gaotao.modules.sys.service.SysRoleMenuService;
import com.gaotao.modules.sys.service.SysUserService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysMenuService")
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuDao, SysMenuEntity>
implements SysMenuService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysMenuDao sysMenuDao;
    @Resource
    private SysObjectLanguageMenuService sysObjectLanguageMenuService;

    @Override
    public List<SysMenuEntity> queryListParentId(String parentId, List<String> menuIdList, String l, String menuType) {
        List<SysMenuEntity> menuList = this.queryListParentId1(parentId, l, menuType);
        if (menuIdList == null) {
            return menuList;
        }
        ArrayList<SysMenuEntity> userMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity menu : menuList) {
            if (!menuIdList.contains(menu.getMenuId())) continue;
            userMenuList.add(menu);
        }
        return userMenuList;
    }

    @Override
    public List<SysMenuEntity> queryListParentId(String parentId) {
        return ((SysMenuDao)this.baseMapper).queryListParentId(parentId);
    }

    public List<SysMenuEntity> queryListParentId1(String parentId, String l, String menuType) {
        return ((SysMenuDao)this.baseMapper).queryListParentId1(parentId, l, menuType);
    }

    @Override
    public List<SysMenuEntity> queryNotButtonList() {
        return ((SysMenuDao)this.baseMapper).queryNotButtonList();
    }

    @Override
    public List<SysMenuEntity> getUserMenuList(Long userId, String l, String MenuType2) {
        if (userId == 1L) {
            return this.getAllMenuList(null, l, MenuType2);
        }
        List<String> menuIdList = this.sysUserService.queryAllMenuId(userId);
        return this.getAllMenuList(menuIdList, l, MenuType2);
    }

    @Override
    public void delete(String menuId) {
        this.removeById((Serializable)((Object)menuId));
        this.sysRoleMenuService.removeByMap(new MapUtils().put("menu_id", (Object)menuId));
    }

    private List<SysMenuEntity> getAllMenuList(List<String> menuIdList, String l, String menuType) {
        List<Object> menuList = new ArrayList();
        menuList = "pc".equals(menuType) ? this.queryListParentId("0", menuIdList, l, menuType) : this.queryListParentId("950", menuIdList, l, menuType);
        this.getMenuTreeList(menuList, menuIdList, l, menuType);
        return menuList;
    }

    private List<SysMenuEntity> getMenuTreeList(List<SysMenuEntity> menuList, List<String> menuIdList, String l, String menuType) {
        ArrayList<SysMenuEntity> subMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity entity : menuList) {
            if (entity.getType().intValue() == Constant.MenuType.CATALOG.getValue()) {
                entity.setList(this.getMenuTreeList(this.queryListParentId(entity.getMenuId(), menuIdList, l, menuType), menuIdList, l, menuType));
            }
            subMenuList.add(entity);
        }
        return subMenuList;
    }

    @Override
    public List<SysMenuEntity> searchMenuList(SysMenuEntity menu) {
        List menuEntityList = ((QueryChainWrapper)((QueryChainWrapper)this.query().like(menu.getName() != null && !"".equals(menu.getName()), (Object)"name", (Object)menu.getName())).ne((Object)"type", (Object)2)).list();
        return menuEntityList;
    }

    @Override
    public List<SysMenuEntity> listLanguage(String language) {
        List<SysMenuEntity> list = this.sysMenuDao.listLanguage(language);
        return list;
    }

    @Override
    public SysMenuEntity getByIdLanguage(String parentId, String language) {
        SysMenuEntity sysMenuEntity = this.sysMenuDao.getByIdLanguage(parentId, language);
        return sysMenuEntity;
    }

    @Override
    public List<SysObjectLanguageMenu> searchMenuLanguageById(SysObjectLanguageMenu sysObjectLanguageMenu) {
        return ((SysMenuDao)this.baseMapper).searchMenuLanguageById(sysObjectLanguageMenu);
    }

    @Override
    public Boolean saveMenuLanguage(List<SysObjectLanguageMenu> sysObjectLanguageMenu) {
        return this.sysObjectLanguageMenuService.saveSysObjectLanguageMenu(sysObjectLanguageMenu);
    }
}

