/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.report.service.impl;

import com.gaotao.datasource.annotation.DataSource;
import com.gaotao.modules.report.dao.AlsReportDao;
import com.gaotao.modules.report.data.AlsCsvFileHeader;
import com.gaotao.modules.report.data.AlsCsvTidReportInfo;
import com.gaotao.modules.report.service.AlsReportService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AlsReportServiceImpl
implements AlsReportService {
    @Autowired
    private AlsReportDao alsReportDao;
    @Value(value="${query.maxNums}")
    private int maxNums;

    @DataSource(value="slave2")
    public List<AlsCsvTidReportInfo> getAlsTidReportOld(AlsCsvTidReportInfo inData) {
        String orgId = inData.getOrgId().trim();
        String ordSeq = inData.getOrdSeq().trim();
        String retailerName = inData.getRetailerName().trim();
        String salesOrderNumber = inData.getSalesOrderNumber().trim();
        String gtin = inData.getGtin().trim();
        Date startProductionDate = inData.getStartProductionDate();
        Date endProductionDate = inData.getEndProductionDate();
        String tid = inData.getTid().trim();
        String epc = inData.getEpc().trim();
        String searchFlag = inData.getSearchFlag();
        int pageSize = inData.getPageSize();
        int pageIndex = inData.getPageIndex();
        boolean exportFlag = inData.isExportFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return new ArrayList<AlsCsvTidReportInfo>();
        }
        if ((null == orgId || "".equals(orgId)) && (null == retailerName || "".equals(retailerName))) {
            throw new RuntimeException("Org ID and Retailer Name cannot be empty at the same time!");
        }
        if (null != tid && !"".equals(tid) && tid.length() != 24) {
            throw new RuntimeException("TID length is not 24 characters!");
        }
        if (null != epc && !"".equals(epc) && epc.length() != 24) {
            throw new RuntimeException("EPC length is not 24 characters!");
        }
        List<AlsCsvFileHeader> headerList = this.alsReportDao.getAlsCsvFileHeaderByCon(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate);
        if (headerList.size() == 0 || headerList.isEmpty()) {
            return new ArrayList<AlsCsvTidReportInfo>();
        }
        int startIndex = (pageIndex - 1) * pageSize;
        int totalQty = pageIndex * pageSize;
        ArrayList<AlsCsvTidReportInfo> resultList = new ArrayList<AlsCsvTidReportInfo>();
        for (AlsCsvFileHeader fileHeader : headerList) {
            if (!exportFlag && resultList.size() >= totalQty) break;
            String tableName = fileHeader.getTableName();
            int headerId = fileHeader.getId();
            List<AlsCsvTidReportInfo> tempList = this.alsReportDao.getAlsTidInfoReport(headerId, tableName, tid, epc, pageIndex, pageSize);
            if (tempList.size() == 0 || tempList.isEmpty()) continue;
            resultList.addAll(tempList);
        }
        if (!exportFlag && resultList.size() >= totalQty) {
            return resultList.subList(startIndex, totalQty - 1);
        }
        if (!exportFlag && resultList.size() < totalQty) {
            return resultList.subList(startIndex, resultList.size() - 1);
        }
        return resultList;
    }

    @Override
    @DataSource(value="slave2")
    public List<AlsCsvTidReportInfo> getAlsTidReport(AlsCsvTidReportInfo inData) {
        String orgId = inData.getOrgId().trim();
        String ordSeq = inData.getOrdSeq().trim();
        String retailerName = inData.getRetailerName().trim();
        String salesOrderNumber = inData.getSalesOrderNumber().trim();
        String gtin = inData.getGtin().trim();
        Date startProductionDate = inData.getStartProductionDate();
        Date endProductionDate = inData.getEndProductionDate();
        String tid = inData.getTid().trim();
        String epc = inData.getEpc().trim();
        String searchFlag = inData.getSearchFlag();
        String ticketCenterId = inData.getTicketCenterId();
        String deviceBrand = inData.getDeviceBrand();
        String deviceType = inData.getDeviceType();
        String controllerHostName = inData.getControllerHostName();
        String controllerUserName = inData.getControllerUserName();
        int pageSize = inData.getPageSize();
        int pageIndex = inData.getPageIndex();
        boolean exportFlag = inData.isExportFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return new ArrayList<AlsCsvTidReportInfo>();
        }
        if ((null == orgId || "".equals(orgId)) && (null == retailerName || "".equals(retailerName))) {
            throw new RuntimeException("Org ID and Retailer Name cannot be empty at the same time!");
        }
        if (null != tid && !"".equals(tid) && tid.length() != 24) {
            throw new RuntimeException("TID length is not 24 characters!");
        }
        if (null != epc && !"".equals(epc) && epc.length() != 24) {
            throw new RuntimeException("EPC length is not 24 characters!");
        }
        List<Object> resultList = new ArrayList();
        AlsCsvFileHeader alsHeader = this.alsReportDao.getOneAlsCsvFileHeaderByCon(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName);
        if (alsHeader == null) {
            return new ArrayList<AlsCsvTidReportInfo>();
        }
        String tableName = alsHeader.getTableName();
        resultList = exportFlag ? this.alsReportDao.getAlsTidInfoReportWithExport(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, tableName, tid, epc, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName) : this.alsReportDao.getAlsTidInfoReportWithPage(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, tableName, tid, epc, pageIndex, pageSize, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName);
        return resultList;
    }

    @Override
    @DataSource(value="slave2")
    public Integer countAlsTidReport(AlsCsvTidReportInfo inData) {
        String orgId = inData.getOrgId().trim();
        String ordSeq = inData.getOrdSeq().trim();
        String retailerName = inData.getRetailerName().trim();
        String salesOrderNumber = inData.getSalesOrderNumber().trim();
        String gtin = inData.getGtin().trim();
        Date startProductionDate = inData.getStartProductionDate();
        Date endProductionDate = inData.getEndProductionDate();
        String ticketCenterId = inData.getTicketCenterId();
        String deviceBrand = inData.getDeviceBrand();
        String deviceType = inData.getDeviceType();
        String controllerHostName = inData.getControllerHostName();
        String controllerUserName = inData.getControllerUserName();
        String tid = inData.getTid().trim();
        String epc = inData.getEpc().trim();
        String searchFlag = inData.getSearchFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return 0;
        }
        List<AlsCsvFileHeader> headerList = this.alsReportDao.getAlsCsvFileHeaderByCon(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName);
        if (headerList.size() == 0 || headerList.isEmpty()) {
            return 0;
        }
        int countNums = 0;
        for (AlsCsvFileHeader fileHeader : headerList) {
            String tableName = fileHeader.getTableName();
            int headerId = fileHeader.getId();
            Integer tempNums = this.alsReportDao.countAlsTidReport(headerId, tableName, tid, epc);
            if (tempNums <= 0) continue;
            countNums += tempNums.intValue();
        }
        return countNums;
    }

    @Override
    @DataSource(value="slave2")
    public Integer countAlsTidReportWithPage(AlsCsvTidReportInfo inData) {
        String orgId = inData.getOrgId().trim();
        String ordSeq = inData.getOrdSeq().trim();
        String retailerName = inData.getRetailerName().trim();
        String salesOrderNumber = inData.getSalesOrderNumber().trim();
        String gtin = inData.getGtin().trim();
        Date startProductionDate = inData.getStartProductionDate();
        Date endProductionDate = inData.getEndProductionDate();
        String tid = inData.getTid().trim();
        String epc = inData.getEpc().trim();
        String ticketCenterId = inData.getTicketCenterId();
        String deviceBrand = inData.getDeviceBrand();
        String deviceType = inData.getDeviceType();
        String controllerHostName = inData.getControllerHostName();
        String controllerUserName = inData.getControllerUserName();
        String searchFlag = inData.getSearchFlag();
        int pageSize = inData.getPageSize();
        int pageIndex = inData.getPageIndex();
        boolean exportFlag = inData.isExportFlag();
        if ("N".equalsIgnoreCase(searchFlag)) {
            return 0;
        }
        if ((null == orgId || "".equals(orgId)) && (null == retailerName || "".equals(retailerName))) {
            throw new RuntimeException("Org ID and Retailer Name cannot be empty at the same time!");
        }
        if (null != tid && !"".equals(tid) && tid.length() != 24) {
            throw new RuntimeException("TID length is not 24 characters!");
        }
        if (null != epc && !"".equals(epc) && epc.length() != 24) {
            throw new RuntimeException("EPC length is not 24 characters!");
        }
        ArrayList resultList = new ArrayList();
        AlsCsvFileHeader alsHeader = this.alsReportDao.getOneAlsCsvFileHeaderByCon(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName);
        if (alsHeader == null) {
            return 0;
        }
        String tableName = alsHeader.getTableName();
        int countNums = this.alsReportDao.countAlsTidReportWithPage(orgId, retailerName, ordSeq, salesOrderNumber, gtin, startProductionDate, endProductionDate, tableName, tid, epc, ticketCenterId, deviceBrand, deviceType, controllerHostName, controllerUserName);
        return countNums;
    }
}

