/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.utils;

import com.gaotao.common.utils.DateUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DateUtil {
    public static double getTimeforDoule(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String start = sdf.format(date);
        String[] strs = start.split(":");
        int a = Integer.parseInt(strs[0]);
        int b = Integer.parseInt(strs[1]);
        DecimalFormat df = new DecimalFormat("0.00");
        String num = df.format((float)b / 60.0f);
        double c = Double.valueOf(num);
        double d = (double)a + c;
        return d;
    }

    public static String getStringNow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getSDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(date);
    }

    public static String getSTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        return sdf.format(date);
    }

    public static String getStringDate(Date date, String parten) {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        return sdf.format(date);
    }

    public static String getStringYesterday() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return sdf.format(cal.getTime());
    }

    public static String getStringTomorrow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return sdf.format(cal.getTime());
    }

    public static Date getDate(String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(time);
    }

    public static Date getDate2(String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(time);
    }

    public static Date getStringToDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLastMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        Date lastDate = cal.getTime();
        return sdf.format(lastDate);
    }

    public static Date getDateByParten(String date, String parten) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        return sdf.parse(date);
    }

    public static List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static List<String> collectLocalDates(LocalDate start, LocalDate end) {
        return Stream.iterate(start, localDate -> localDate.plusDays(1L)).limit(ChronoUnit.DAYS.between(start, end) + 1L).map(LocalDate::toString).collect(Collectors.toList());
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean termOfValidity(Date nowTime, Date termOfValidity) {
        if (nowTime.getTime() == termOfValidity.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar end = Calendar.getInstance();
        end.setTime(termOfValidity);
        return date.before(end);
    }

    public static boolean compareDate(Date startTime, Date endTime) {
        return startTime.getTime() > endTime.getTime();
    }

    public static Date getDateTime(String time) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(time);
    }

    public static double getHour(Date date1, Date date2) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        long startTime = date1.getTime();
        long endTime = date2.getTime();
        Long Intervals = endTime - startTime;
        Double hour = (double)Intervals.longValue() / 1000.0 / 3600.0;
        DecimalFormat decimalFormat = new DecimalFormat(".0");
        String p = decimalFormat.format(hour);
        hour = Double.parseDouble(p);
        return hour;
    }

    public static String getWeek(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE");
        String week = sdf.format(date);
        return week;
    }

    public static Integer getWeekDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekDay = calendar.get(7);
        weekDay = weekDay == 1 ? 7 : --weekDay;
        return weekDay;
    }

    public static Date getAddDate(Date date, Integer num) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, num);
        date = calendar.getTime();
        return date;
    }

    public static Date getDateTime(String time, String parten) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        return sdf.parse(time);
    }

    public String DateToStringBeginOrEnd(Date date, Boolean flag) {
        String time = null;
        SimpleDateFormat dateformat1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Calendar calendar1 = Calendar.getInstance();
        if (flag.booleanValue()) {
            calendar1.setTime(date);
            calendar1.set(calendar1.get(1), calendar1.get(2), calendar1.get(5), 0, 0, 0);
            Date beginOfDate = calendar1.getTime();
            time = dateformat1.format(beginOfDate);
            System.out.println(time);
        } else {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar1.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
            Date endOfDate = calendar1.getTime();
            time = dateformat1.format(endOfDate);
            System.out.println(time);
        }
        return time;
    }

    public static Date getFirstDayOfWeek(int year, int week) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, year);
        c.set(2, 0);
        c.set(5, 1);
        GregorianCalendar cal = (GregorianCalendar)((Calendar)c).clone();
        ((Calendar)cal).add(5, week * 7);
        return DateUtil.getFirstDayOfWeek(cal.getTime());
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getMinDateMonth(String month) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date nowDate = sdf.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(5, calendar.getActualMinimum(5));
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getMaxDateMonth(String month) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date nowDate = sdf.parse(month);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws ParseException {
        String month = "2021-3-14";
        System.out.println(DateUtils.format(DateUtil.getMinDateMonth(month)));
        System.out.println(DateUtils.format(DateUtil.getMaxDateMonth(month)));
    }
}

