/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.batch;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.gaotao.common.batch.NoahSqlMethod;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractNoahServiceImpl<E extends BaseMapper<T>, T>
extends ServiceImpl<E, T>
implements IService<T> {
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        int i = 0;
        String sqlStatement = SqlHelper.table((Class)this.currentModelClass()).getSqlStatement(NoahSqlMethod.INSERT_BATCH.getMethod());
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            for (T anEntityList : entityList) {
                batchSqlSession.insert(sqlStatement, anEntityList);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        Class cls = this.currentModelClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)cls);
        int i = 0;
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            for (T anEntityList : entityList) {
                if (null != tableInfo && StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
                    Object idVal = ReflectionKit.getFieldValue(anEntityList, (String)tableInfo.getKeyProperty());
                    if (StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal))) {
                        batchSqlSession.insert(SqlHelper.table((Class)this.currentModelClass()).getSqlStatement(NoahSqlMethod.INSERT_BATCH.getMethod()), anEntityList);
                    } else {
                        MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                        param.put((Object)"et", anEntityList);
                        batchSqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
                    }
                    if (i >= 1 && i % batchSize == 0) {
                        batchSqlSession.flushStatements();
                    }
                    ++i;
                } else {
                    throw ExceptionUtils.mpe((String)"Error:  Can not execute. Could not find @TableId.", (Object[])new Object[0]);
                }
                batchSqlSession.flushStatements();
            }
        }
        return true;
    }
}

