/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.aspect;

import com.gaotao.common.annotation.SysLog;
import com.gaotao.common.utils.HttpContextUtils;
import com.gaotao.common.utils.IPUtils;
import com.gaotao.modules.sys.entity.SysLogEntity;
import com.gaotao.modules.sys.entity.SysUserEntity;
import com.gaotao.modules.sys.service.SysLogService;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SysLogAspect {
    @Autowired
    private SysLogService sysLogService;

    @Pointcut(value="@annotation(com.gaotao.common.annotation.SysLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, time);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLogEntity sysLog = new SysLogEntity();
        SysLog syslog = method.getAnnotation(SysLog.class);
        if (syslog != null) {
            sysLog.setOperation(syslog.value());
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        sysLog.setMethod(className + "." + methodName + "()");
        Object[] args = joinPoint.getArgs();
        try {
            String params = new Gson().toJson((Object)args);
            sysLog.setParams(params);
        }
        catch (Exception params) {
            // empty catch block
        }
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        sysLog.setIp(IPUtils.getIpAddr(request));
        String username = ((SysUserEntity)SecurityUtils.getSubject().getPrincipal()).getUsername();
        sysLog.setUsername(username);
        sysLog.setTime(time);
        sysLog.setCreateDate(new Date());
        this.sysLogService.save(sysLog);
    }
}

