/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.common.aop;

import com.gaotao.common.exception.XJException;
import com.gaotao.modules.sys.entity.SysUserEntity;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class RepeatSubmitAspect {
    private static final Cache<String, Object> caches = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    @Pointcut(value="@annotation(com.gaotao.common.annotation.RepeatSubmit)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object submitAop(ProceedingJoinPoint pjp) throws Exception {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String url = request.getRequestURI();
        SysUserEntity currentUser = (SysUserEntity)SecurityUtils.getSubject().getPrincipal();
        if (null == currentUser) {
            HttpServletResponse response = attributes.getResponse();
            response.sendError(403, "Session is expired!");
            return response;
        }
        String username = currentUser.getUsername();
        String key = username + "-" + url;
        if (!StringUtils.isEmpty((CharSequence)key)) {
            if (caches.getIfPresent((Object)key) == null) {
                caches.put((Object)key, (Object)key);
            } else {
                HttpServletResponse response = attributes.getResponse();
                throw new XJException("\u91cd\u590d\u63d0\u4ea4!", 500);
            }
        }
        try {
            return pjp.proceed();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

