//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $("#rollNo").val();
        	  if(null==rollNo||rollNo==""){
        		  layer.alert("内部卷号不能为空!");
        	  }else{
        		  getRollInfoByRollNo(rollNo);
                  return false;
        	  }
          }
          return true;
});
//为供应商卷号绑定一个失去焦点事件
$("#supplierRollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $("#rollNo").val();
        	  var supplierRollNo = $("#supplierRollNo").val();
        	  if(null==rollNo||rollNo==""||null==supplierRollNo||supplierRollNo==""){
        		  layer.msg("内部卷号和供应商卷号都不能为空!");
        	  }else if(null!=supplierRollNo&&null!=rollNo&&supplierRollNo==rollNo){
        		  layer.msg("当前供应商卷号存在与内部卷号中!");
        		  $("#supplierRollNo").val("");
        	  }else{
        		  updateRollInfoByCondition(rollNo,supplierRollNo);
        	  }
        	  layer.closeAll('loading');
              return false;
          }
          return true;
});
//通过内部卷号获取信息
function getRollInfoByRollNo(rollNo){
	$.ajax({
		url : "/roll/getRollInfoByRollNo",
		type : "POST",
		data : {rollNo: rollNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			var tempData = data.obj;
			if (code=='0') {
				$("#materialCode").html(tempData.partNo);
				$("#materialDes").html(tempData.partDescription);
				$("#orderNo").html(tempData.pono);
				$("#supplierRollNo").focus();
				//更新供应商编码
			} else if (code=='1') {
				layer.confirm(data.msg, {
					btn : [ '是', '否' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
					$("#materialCode").html(tempData.partNo);
					$("#materialDes").html(tempData.partDescription);
					$("#orderNo").html(tempData.pono);
					$("#supplierRollNo").focus();
				}, function() {
					clear();
					$("#rollNo").focus();
				});
			}else if(code=='100'){
				layer.alert(data.msg);
				clear();
			}
		},
		error : function(data) {
		}
	});
}
//修改内部卷号的供应商卷号
function updateRollInfoByCondition(rollNo,supplierRollNo){
	$.ajax({
		url : "/roll/updateSuppRollNo",
		type : "POST",
		data : {rollNo: rollNo,supplierRollNo: supplierRollNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if (code=='0'||code=='1') {
				clear();
				layer.msg(data.msg);
				$("#rollNo").focus();
				//更新供应商编码
			} else if (code=='2') {
				layer.alert(data.msg);
				$("#supplierRollNo").val("");
				$("#supplierRollNo").focus();
			}
		},
		error : function(data) {
		}
	});
}
//
//清楚信息
function clear(){
	$("#materialCode").html("");
	$("#materialDes").html("");
	$("#orderNo").html("");
	$("#rollNo").val("");
	$("#supplierRollNo").val("");
}