//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $("#rollNo").val();
        	  if(null==rollNo||rollNo==""){
        		  layer.alert("成品卷号不能为空!");
        	  }else{
        		  scanRollNo(rollNo);
                  return false;
        	  }
          }
          return true;
});

// 页面初始化加在数据
$(function(){
	// 判断是否需要更新当前页面数
	var flag = $("#flag").val();
	var depot = $("#select_depot").val();
	//设置默认的参数
	if(null!=depot&&depot!=''){
		$("#depot").val(depot);
	}
	// 判断是否开始收货
	if(flag == 'Y'){
		getSavedRollCounts();
	}
});

// 通过成品卷号获取信息
function scanRollNo(rollNo){
	$.ajax({
		url : "/produce/scanRollNo",
		type : "POST",
		data : {rollNo: rollNo,
				depot: $("#depot").val()
		},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			var tempData = data.obj;
			if (code=='200') {
				// 刷新页面
				window.document.location.href = "/pda/produceAccept?titleName=''&menuId=0";
				// 更新供应商编码
			} else if (code=='500') {
				layer.alert(data.msg);
				$("#rollNo").val("");
			}
		},
		error : function(data) {
		}
	});
}

// 刷新记录信息
function getSavedRollCounts(){
	$.ajax({
		url : "/produce/getSavedRollCounts",
		type : "POST",
		data : {},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var tagStr ='';
			var orderNo = data.currentOrderNo;
			delete data["currentOrderNo"];
			for(key in data){
				var partNo = data[key].partNo;
				tagStr+= '<div><div class="r-left-line">物料描述：'+data[key].partDes+'</div>';
				tagStr+='<div class="ivu-table-wrapper"><div class="ivu-table">';
				tagStr+='<div class="ivu-table-header">';
				tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
				tagStr+='<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
				tagStr+='<thead><tr><th class=""><div class="ivu-table-cell">';
				tagStr+='<span>单卷数量</span></div></th>';
				tagStr+='<th class=""><div class="ivu-table-cell"><span>卷数</span></div></th>';
				tagStr+='<th class=""><div class="ivu-table-cell"><span>总数量</span></div></th>';
				tagStr+='<th class=""><div class="ivu-table-cell"><span>操作</span></div></th>';
				tagStr+='</tr></thead></table></div>';
				tagStr+='<div class="ivu-table-body">';
				tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
				tagStr+='<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
				tagStr+='<tbody class="ivu-table-tbody">';
				var rollData = data[key].list;
				for(inKey in rollData){
					tagStr+='<tr class="ivu-table-row"><td class=""><div class="ivu-table-cell"><span>'+rollData[inKey].nums+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><span>'+rollData[inKey].rollNums+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><span>'+rollData[inKey].rollTotal+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><div>';
					tagStr+='<button type="button" onclick="getRollNos('+'\''+partNo+'\','+rollData[inKey].nums+')"'+' class="ivu-btn ivu-btn-primary ivu-btn-small"><span>明细</span></button>';
					tagStr+='</div></div></td></tr>';
				}
				tagStr+='</tbody></table></div></div></div></div>';
			}
			$("#rollCounts").append(tagStr);
			//判断是否进去批量录入
			var produce_cache_flag = $("#produce_cache_flag").val();
			if('N'==produce_cache_flag){
				layer.confirm('确定批量自动录入卷号?',{
					btn:['确定','取消']
				},function(){
					batchInsert(orderNo);
				});
			}
		},
		error : function(data) {
		}
	});
}

//批量插入的方法
function batchInsert(orderNo){
	$.ajax({
		url : "/produce/batchInsert",
		type : "POST",
		data : {orderNo : orderNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.document.location.href = "/pda/publicMenu?titleName=''&menuId=0";
			}else if (code=='500') {
				layer.alert(data.msg);
				$("#rollNo").val("");
			}
		},
		error : function(data) {
		}
	});
}

//返回主界面清除缓存信息
function goBack(){
	layer.confirm("返回主界面将会删除当前扫描信息！！", {
		btn : [ '确认', '取消' ]
	// 按钮
	}, function() {
		layer.closeAll('dialog');
		goBackHome();
	}, function() {
		layer.closeAll('dialog');
	});
}

// 执行返回主界面清除缓存信息
function goBackHome(){
	var token ={
		"token":$.cookie("token")
	}
	$.ajax({
		url : "/produce/goBackHome",
		type : "POST",
		data : token,
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.location.href = "/pda/publicMenu?titleName=''&menuId=0";
		}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}

// 清楚信息
function clear(){
	$("#rollNo").val("");
}

// 获取参数并且页面跳转
function getRollNos(partNo,nums){
	$.ajax({
		url : "/produce/sendRollParamter",
		type : "POST",
		data : {partNo: partNo,nums: nums},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.document.location.href="/pda/produce/produceRollNos"
			}else{
				layer.alert(data.msg);
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}

// 结束扫描
function endScan(){
	// 判断是否已经开启扫描
	var flag = $("#flag").val();
	if(flag=='Y'){
	 layer.confirm('确认完成扫描？', {
			btn : [ '确认', '取消' ]
		// 按钮
		}, function() {
			layer.closeAll('dialog');
			endCurrentScan();
		}, function() {
			clear();
			$("#rollNo").focus();
		});
	}else{
		layer.alert("当前暂无已扫描的卷号！");
	}
}
// 结束当前扫描操作
function endCurrentScan(){
	$.ajax({
		url : "/produce/endCurrentScan",
		type : "POST",
		data : {"depot": $("#depot").val()},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/publicMenu?titleName=''&menuId=0"
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/publicMenu?titleName=''&menuId="
				});
			}else if(code=='500'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
				}, function() {
					layer.closeAll('dialog');
				});
			}else{
				var outData = data.obj;
				var outShow  = '状态有误的卷号：';
				for(var i = 0;i<outData.length;i++){
					outShow+=outData[i];
				}
				layer.alert(outShow);
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}