var userId = $("#current_id").val();
var userName = $("#current_username").val();
var site = $("#current_site").val();


var toolDetailList = new Array();
var locationDate;

//页面初始化
$(function () {
    //	初始化录入时间
    InitStorageTime();
    //	获取领用人信息
    getOperatorList();
    //	初始化光标
    $("#tool_detail").focus();
});

// 获取领用人信息
function getOperatorList() {
    let query = {
        active: 'Y',
        site: $('#current_site').val()
    }
    $.ajax({
        url: "/productionReport/getProductionLineOperatorRegistration",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(query),
        dataType: "JSON",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var rows = data.rows;
            $("#operatorList").html('');
            var str = '<option value= "" style="height:24px;font-size :12px;">' + "请选择领用人" + '</option>';
            for (var i = 0; i < rows.length; i++) {
                str += '<option value="' + rows[i].operatorID + '" style="height:24px;font-size :12px;">' + rows[i].operatorName + '</option>';
            }
            $("#operatorList").html(str);
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

// 初始化入库日期
function InitStorageTime() {
    var data = getNowFormatDate();
    data = data.substring(0, 10);
    $("#storage_time").val(data);
}

//为工具实例条码绑定一个失去焦点事件
$("#tool_detail").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var toolInstanceId = $(this).val();
        if (toolInstanceId == null || toolInstanceId == "") {
            layer.msg("请输入正确的实例编码!");
            $(this).val("");
            $(this).focus();
        } else {
            getToolInstanceData(toolInstanceId);
        }
    }
});

//为工具实例条码绑定一个失去焦点事件
$("#locationId").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var locationId = $(this).val();
        if (locationId == null || locationId == "") {
            layer.msg("请输入正确的库位编码!");
            $(this).val("");
            $(this).focus();
        } else {
            getLocation(locationId);
        }
    }
});

// 获取获取工具实例编码
function getToolInstanceData(toolInstanceId) {
    $("#tool_detail").val("");
    var jsonData = {
        site: site,
        toolInstanceId: toolInstanceId,
    }
    $.ajax({
        url: "/toolPda/getToolDetail",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(jsonData),//你的formid
        dataType: "JSON",
        async: false,
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            var row = data.row;
            if (row != null || row == "") {
                if (row.status != "已投用" ) {
                    layer.msg("该工具不可用!");
                    return false;
                }
                if ( row.statusRef != "" && row.statusRef != null){
                    layer.msg("该工具不可领用!");
                    return false;
                }
                for (let i = 0; i < toolDetailList.length; i++) {
                    if (toolDetailList[i].toolInstanceId == row.toolInstanceId) {
                        layer.msg("已有该工具记录!");
                        $("#tool_detail").focus();
                        return;
                    }
                }
                toolDetailList.push(row);
                var str = '<tr id = ' + row.toolInstanceId + '>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<span>' + row.toolInstanceId + '</span></th>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<span>' + row.toolDescription + '</span></th>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<span>' + row.locationId + '</span></th>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<button  data-toggle="modal" onclick="remove(\'' + row.toolInstanceId + '\')" style="padding: 3px 10px;">' +
                    '删除</button>' +
                    '</tr>';
                $("#dateil_table").append(str);
                $("#tool_detail").focus();
            } else {
                layer.msg("没有该工具记录!");
            }

        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

//删除
function remove(toolInstanceId) {
    for (var i = 0; i < toolDetailList.length; i++) {
        if (toolDetailList[i].toolInstanceId == toolInstanceId) {
            toolDatailRemo(toolDetailList[i].toolInstanceId);
            toolDetailList.splice(i, 1);
            layer.msg("移除成功!");
            $("#tool_detail").val("");
            $("#tool_detail").focus();
            return false;
        }
    }
    layer.msg("没有该工具记录!");
    $("#tool_detail").val("");
}


// 移除工具实例编码
function toolDatailRemo(toolInstanceId) {
    $table = $("#dateil_table tr");
    $("tr[id='" + toolInstanceId + "']").remove();
}


//新增库位信息
function updateToolDetail() {
    $("#saveDetail").attr('disabled', true);
    let remark = $('#remark').val()
    let orderRef2 = $("#orderRef2").val()
    if (toolDetailList.length == 0) {
        layer.msg("请输入实例编码!");
        $("#saveDetail").attr('disabled', false);
        return;
    }
    if (orderRef2.length == 0) {
        layer.msg("请选择领用人!");
        $("#saveDetail").attr('disabled', false);
        return;
    }
    var alreadyList = new Array;
    for (var i = 0; i < toolDetailList.length; i++) {
        var jsonData = {
            toolId: toolDetailList[i].toolId,
            site: toolDetailList[i].site,
            toolInstanceId: toolDetailList[i].toolInstanceId,
            locationId: toolDetailList[i].locationId.toUpperCase(),
            transNoHead: 'TL',
            transType: '工具领用',
            transTypeDb: 'JL',
            direction: "-",
            userName: userName,
            statusRef: "领用出库",
            remark: remark,
            orderRef2: orderRef2

        };
        alreadyList.push(jsonData);
    }
    $.ajax({
        url: "/toolPda/updateToolDetail",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(alreadyList),
        dataType: "JSON",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                layer.msg(data.msg);
                toolDetailList = new Array;
                $("#dateil_table").html("");
                $("#tool_detail").val("");
                $('#remark').val('')
                $("#orderRef2").val('')
                //触发隐藏
                $("#location_modal").modal("hide");
            } else if (data.code == 401) {
                window.location.href = "/login";
            } else {
                layer.msg(data.msg);
            }
        },
        error: function (data) {
            var responseText = data.responseText;
            var json_str = JSON.parse(responseText);
            var status = json_str.status;
            var message = json_str.message;
            //判断是否是session超时
            if (403 == status) {
                layer.alert(message, function () {
                    window.location.href = "/login";
                });
            }
            layer.closeAll('loading');
        }
    })
}

//清除前台缓存
function cleanData() {
    toolDatail = new Array;
    warehouseData = new Array;
    $("#dateil_table").html("");
}
