/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.language.controller;

import com.gaotao.common.exception.ResponseEnum;
import com.gaotao.common.utils.PageUtils;
import com.gaotao.common.utils.R;
import com.gaotao.modules.language.entity.SysObjectLanguageBase;
import com.gaotao.modules.language.entity.SysObjectLanguageOthers;
import com.gaotao.modules.language.entity.vo.LanguageBaseLanguageVo;
import com.gaotao.modules.language.entity.vo.LanguageOthersVo;
import com.gaotao.modules.language.query.QuerySysLanguagePack;
import com.gaotao.modules.language.service.SysLanguageBaseService;
import com.gaotao.modules.language.service.SysLanguagePackService;
import com.gaotao.modules.sys.controller.AbstractController;
import com.gaotao.modules.sys.service.SysConfigService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"sysLanguagePack"})
@RestController
public class SysObjectLanguageOthersController
extends AbstractController {
    @Autowired
    private SysLanguagePackService sysLanguagePackService;
    @Autowired
    private SysLanguageBaseService sysLanguageBaseService;
    @Autowired
    private SysConfigService sysConfigService;

    @PostMapping(value={"searchSysLanguagePackList"})
    public R searchSysLanguagePackList(@RequestBody QuerySysLanguagePack querySysLanguagePack) {
        PageUtils page = this.sysLanguagePackService.searchSysLanguagePackList(querySysLanguagePack);
        return R.ok().put("page", (Object)page);
    }

    @PostMapping(value={"searchSysLanguageParam"})
    public R searchSysLanguageParam(@RequestBody QuerySysLanguagePack querySysLanguagePack) {
        List<SysObjectLanguageOthers> paramList = this.sysLanguagePackService.searchSysLanguageParam(querySysLanguagePack);
        return R.ok().put("rows", (Object)paramList);
    }

    @PostMapping(value={"searchSysLanguagePack"})
    public R searchSysLanguagePack() {
        Map<String, Map<String, String>> objectObjectMap = this.sysLanguagePackService.languageList();
        return R.ok().put("data", (Object)objectObjectMap);
    }

    @PostMapping(value={"searchFunctionButtonList"})
    public R searchFunctionButtonList(@RequestBody SysObjectLanguageOthers sysObjectLanguageOthers) {
        String multiLanguage = this.sysConfigService.getValue("multiLanguage");
        if (StringUtils.isNotEmpty((String)multiLanguage) && multiLanguage.equals("Y")) {
            Map<String, String> sysLanguagePacks = this.sysLanguagePackService.searchFunctionButtonList(sysObjectLanguageOthers);
            return R.ok().put("data", (Object)sysLanguagePacks);
        }
        return R.error(ResponseEnum.NOT_MULTI_LANGUAGE_FLAG);
    }

    @PostMapping(value={"saveSysLanguagePack"})
    public R saveSysLanguagePack(List<SysObjectLanguageOthers> sysLanguagePacks) {
        this.sysLanguagePackService.saveSysLanguagePack(sysLanguagePacks);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @PostMapping(value={"saveSysLanguageOne"})
    public R saveSysLanguage(@RequestBody SysObjectLanguageOthers sysObjectLanguageOthers) {
        this.sysLanguagePackService.saveSysLanguage(sysObjectLanguageOthers);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @PostMapping(value={"saveSysLanguageList"})
    public R saveSysLanguage(@RequestBody List<SysObjectLanguageOthers> sysObjectLanguageOthers) {
        this.sysLanguagePackService.saveSysLanguageList(sysObjectLanguageOthers);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @PostMapping(value={"saveButtonList"})
    public R saveButtonList(@RequestBody List<SysObjectLanguageBase> sysObjectLanguageBases) {
        this.sysLanguageBaseService.saveButtonList(sysObjectLanguageBases);
        return R.ok(this.getLanguageMsg("200000"));
    }

    @PostMapping(value={"searchLanguageListByLanguageCode"})
    public R searchLanguageListByLanguageCode(@RequestBody QuerySysLanguagePack querySysLanguagePack) {
        List<LanguageOthersVo> sysObjectLanguageOthersList = this.sysLanguagePackService.searchLanguageListByLanguageCode(querySysLanguagePack);
        return R.ok().put("rows", (Object)sysObjectLanguageOthersList);
    }

    @PostMapping(value={"/searchPageLanguageData"})
    public R searchPageLanguageData(@RequestBody SysObjectLanguageOthers sysObjectLanguageOthers) {
        Map<String, String> sysLanguagePacks = this.sysLanguagePackService.searchFunctionButtonList(sysObjectLanguageOthers);
        return R.ok().put("data", (Object)sysLanguagePacks);
    }

    @PostMapping(value={"removerLanguage"})
    public R removerLanguage(@RequestBody SysObjectLanguageOthers sysObjectLanguageOthers) {
        this.sysLanguagePackService.removerOther(sysObjectLanguageOthers);
        this.sysLanguageBaseService.removerBase(sysObjectLanguageOthers);
        return R.ok();
    }

    @PostMapping(value={"searchBaseLanguageList"})
    public R getBaseLanguageList(@RequestBody LanguageBaseLanguageVo languageBaseLanguageVo) {
        List<LanguageBaseLanguageVo> sysObjectLanguageOthersList = this.sysLanguageBaseService.getBaseLanguageListByFidAndOid(languageBaseLanguageVo);
        return R.ok().put("rows", (Object)sysObjectLanguageOthersList);
    }

    @PostMapping(value={"saveBaseObjectLanguageList"})
    public R saveBaseObjectLanguageList(@RequestBody List<SysObjectLanguageOthers> languageVos) {
        this.sysLanguagePackService.saveBaseObjectLanguageList(languageVos);
        return R.ok(this.getLanguageMsg("200000"));
    }
}

