/*
 * Decompiled with CFR 0.152.
 */
package com.gaotao.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaotao.common.exception.XJException;
import com.gaotao.common.utils.DateUtils;
import com.gaotao.modules.sys.dao.SysCaptchaDao;
import com.gaotao.modules.sys.entity.SysCaptchaEntity;
import com.gaotao.modules.sys.service.SysCaptchaService;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysCaptchaService")
public class SysCaptchaServiceImpl
extends ServiceImpl<SysCaptchaDao, SysCaptchaEntity>
implements SysCaptchaService {
    @Autowired
    private Producer producer;

    @Override
    public BufferedImage getCaptcha(String uuid) {
        if (StringUtils.isBlank((String)uuid)) {
            throw new XJException("uuid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String code = this.producer.createText();
        SysCaptchaEntity captchaEntity = new SysCaptchaEntity();
        captchaEntity.setUuid(uuid);
        captchaEntity.setCode(code);
        captchaEntity.setExpireTime(DateUtils.addDateMinutes(new Date(), 5));
        this.save(captchaEntity);
        return this.producer.createImage(code);
    }

    @Override
    public boolean validate(String uuid, String code) {
        SysCaptchaEntity captchaEntity = (SysCaptchaEntity)this.getOne((Wrapper)new QueryWrapper().eq((Object)"uuid", (Object)uuid));
        if (captchaEntity == null) {
            return false;
        }
        this.removeById((Serializable)((Object)uuid));
        return captchaEntity.getCode().equalsIgnoreCase(code) && captchaEntity.getExpireTime().getTime() >= System.currentTimeMillis();
    }
}

