/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;

class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final Charset charset;
    private final long readerLength;
    private long readerCharsRead = 0L;
    private boolean atEndOfStream = false;
    private CharBuffer rawChars = null;
    private static final int MAX_CHAR_BUFFER_SIZE = 4000;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private ByteBuffer encodedChars = EMPTY_BUFFER;
    private final byte[] oneByte = new byte[1];

    ReaderInputStream(Reader reader, String string, long l) throws UnsupportedEncodingException {
        assert (reader != null);
        assert (string != null);
        assert (-1L == l || l >= 0L);
        this.reader = reader;
        try {
            this.charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(illegalCharsetNameException.getMessage());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
        }
        this.readerLength = l;
    }

    @Override
    public int available() throws IOException {
        assert (null != this.reader);
        assert (null != this.encodedChars);
        if (0L == this.readerLength) {
            return 0;
        }
        if (this.encodedChars.remaining() > 0) {
            return this.encodedChars.remaining();
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        return -1 == this.readInternal(this.oneByte, 0, this.oneByte.length) ? -1 : this.oneByte[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.readInternal(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readInternal(byArray, n, n2);
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        assert (null != byArray);
        assert (0 <= n && n <= byArray.length);
        assert (0 <= n2 && n2 <= byArray.length);
        assert (n <= byArray.length - n2);
        if (0 == n2) {
            return 0;
        }
        for (n3 = 0; n3 < n2 && this.encodeChars(); n3 += n4) {
            n4 = this.encodedChars.remaining();
            if (n4 > n2 - n3) {
                n4 = n2 - n3;
            }
            assert (n4 > 0);
            this.encodedChars.get(byArray, n + n3, n4);
        }
        return 0 == n3 && this.atEndOfStream ? -1 : n3;
    }

    private boolean encodeChars() throws IOException {
        if (this.atEndOfStream) {
            return false;
        }
        if (this.encodedChars.hasRemaining()) {
            return true;
        }
        if (null == this.rawChars || !this.rawChars.hasRemaining()) {
            if (null == this.rawChars) {
                this.rawChars = CharBuffer.allocate(-1L == this.readerLength || this.readerLength > 4000L ? 4000 : Math.max((int)this.readerLength, 1));
            } else {
                this.rawChars.clear();
            }
            while (this.rawChars.hasRemaining()) {
                int n = this.rawChars.position();
                int n2 = 0;
                try {
                    n2 = this.reader.read(this.rawChars);
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    if (null == string) {
                        string = SQLServerException.getErrString("R_streamReadReturnedInvalidValue");
                    }
                    IOException iOException = new IOException(string);
                    iOException.initCause(exception);
                    throw iOException;
                }
                if (n2 < -1 || 0 == n2) {
                    throw new IOException(SQLServerException.getErrString("R_streamReadReturnedInvalidValue"));
                }
                if (-1 == n2) {
                    if (this.rawChars.position() != n) {
                        throw new IOException(SQLServerException.getErrString("R_streamReadReturnedInvalidValue"));
                    }
                    if (-1L != this.readerLength && 0L != this.readerLength - this.readerCharsRead) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                        throw new IOException(messageFormat.format(new Object[]{this.readerLength, this.readerCharsRead}));
                    }
                    if (0 != this.rawChars.position()) break;
                    this.rawChars = null;
                    this.atEndOfStream = true;
                    return false;
                }
                assert (n2 > 0);
                if (n2 != this.rawChars.position() - n) {
                    throw new IOException(SQLServerException.getErrString("R_streamReadReturnedInvalidValue"));
                }
                if (-1L != this.readerLength && (long)n2 > this.readerLength - this.readerCharsRead) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                    throw new IOException(messageFormat.format(new Object[]{this.readerLength, this.readerCharsRead}));
                }
                this.readerCharsRead += (long)n2;
            }
            this.rawChars.flip();
        }
        if (!this.rawChars.hasRemaining()) {
            return false;
        }
        this.encodedChars = this.charset.encode(this.rawChars);
        return true;
    }
}

