let checkFlag = 'Y';
//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $("#rollNo").val();
        	  if(null==rollNo||rollNo==""){
        		  layer.alert("成品卷号不能为空!");
        	  }else{
        		  scanRollNo(rollNo);
                  return false;
        	  }
          }
          return true;
});

//库位绑定一个失去焦点事件
$("#location_no").bind("keydown",function(event){
	if (event.keyCode == 13) {
		var locationNo = $(this).val();
		if(null==locationNo||locationNo==""){
			layer.alert("库位编码不能为空!");
		}else{
			endCurrentScan();
			return false;
		}
	}
	return true;
});

// 页面初始化加在数据
$(function(){
	//获取焦点
	$("#rollNo").focus();//获取焦点
});

// 通过卷号获取信息
function scanRollNo(rollNo){
	$.ajax({
		url : "/sap/scanRollNo",
		type : "POST",
		data : {rollNo: rollNo
		},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if (code=='200') {
				// 赋值
				var rollData = data.obj;
				$("#rollNo").attr("disabled", "disabled");
				//赋值当前的物料编码
				$("#part_no").val(rollData.partNo);
				// 获取焦点
				$("#location_no").focus();
			} else if (code=='500') {
				layer.alert(data.msg);
				$("#rollNo").val("");
				//获取焦点
				$("#rollNo").focus();
			}
		},
		error : function(data) {
		}
	});
}

//返回主界面清除缓存信息
function goBack(){
	layer.confirm("返回主界面将会删除当前扫描信息！！", {
		btn : [ '确认', '取消' ]
	// 按钮
	}, function() {
		layer.closeAll('dialog');
		goBackHome();
	}, function() {
		layer.closeAll('dialog');
	});
}
// 执行返回主界面清除缓存信息
function goBackHome(){
	var token ={
		"token":$.cookie("token")
	}
	$.ajax({
		url : "/produce/goBackHome",
		type : "POST",
		data : token,
		dataType : "json",
		beforeSend: function(request) {
			request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.location.href = "/pda/pdaBase";
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}

// 清楚信息
function clear(){
	//刷新信息 处理数据
	$("#rollNo").removeAttr("disabled");
	//赋值当前的物料编码
	$("#part_no").val("");
	$("#rollNo").val("");
	$("#location_no").val("");
	// 获取焦点
	$("#rollNo").focus();
}

// 结束当前扫描操作
function endCurrentScan(){
	$.ajax({
		url : "/sap/endCurrentScan",
		type : "POST",
		data : {"partNo": $("#part_no").val(), "locationNo": $("#location_no").val(), "checkFlag": checkFlag},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				layer.msg(data.msg);
				clear();
			}else if(code=='201'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
					// 按钮
				}, function() {
					layer.closeAll('dialog');
					//重置当前的参数
					checkFlag = 'N';
					endCurrentScan();
				}, function(index) {
					layer.close(index);
					layer.closeAll('dialog');
					clear();
					$("#rollNo").focus();
				});
			}else{
				layer.msg(data.msg);
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
	//重置标记
	checkFlag = 'Y';
}