//为内部卷号绑定一个失去焦点事件
$("#rollNo").bind("keydown",function(event){
          if (event.keyCode == 13) {
        	  var rollNo = $("#rollNo").val();
        	  if(null==rollNo||rollNo==""){
        		  layer.alert("内部卷号不能为空!");
        	  }else{
        		  scanRollNo(rollNo);
                  return false;
        	  }
          }
          return true;
});
// 页面初始化加在数据
$(function(){
	// 判断是否需要更新当前页面数
	var flag = $("#flag").val();
	// 判断是否查询数据信息
	if(flag == 'Y'){
		getSaveRollInfo();
	}
});
// 通过内部卷号获取信息
function scanRollNo(rollNo){
	$.ajax({
		url : "/qa/scanRollNo",
		type : "POST",
		data : {"rollNo": rollNo},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			var tempData = data.obj;
			if (code=='200') {
				layer.msg('扫码成功!');
				// 刷新页面
				window.document.location.href = "/pda/qaCheck";
				// 更新供应商编码
			} else if (code=='500') {
				layer.msg(data.msg);
				$("#rollNo").val("");
			}
		},
		error : function(data) {
		}
	});
}

//批量插入的方法
function batchInsert(data){
	$.ajax({
		url : "/qa/batchInsert",
		type : "POST",
		data : {},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		//contentType : 'application/json;charset=utf-8',
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.document.location.href = "/pda/qaCheck";
			}else if (code=='500') {
				layer.alert(data.msg);
				$("#rollNo").val("");
			}
		},
		error : function(data) {
		}
	});
}

// 刷新记录信息
function getSaveRollInfo(){
	$.ajax({
		url : "/qa/getSaveRollInfo",
		type : "POST",
		data : {},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var tagStr ='';
			var partMap = data["partMap"];
			delete data["partMap"];
			tagStr+= '<div><div style="margin-left: -80px;" class="" >物料描述：'+partMap.qa_partDes+'</div>';
			tagStr+='<div class="ivu-table-wrapper"><div class="ivu-table">';
			tagStr+='<div class="ivu-table-header">';
			tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
			tagStr+='<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
			tagStr+='<thead><tr>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>单卷数量</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>卷数</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>总数量</span></div></th>';
			tagStr+='<th class=""><div class="ivu-table-cell"><span>操作</span></div></th>';
			tagStr+='</tr></thead></table></div>';
			tagStr+='<div class="ivu-table-body">';
			tagStr+='<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">';
			tagStr+='<colgroup><col width="90"><col width="60"><col width="75"><col width="80"></colgroup>';
			tagStr+='<tbody class="ivu-table-tbody">';
			for(key in data){
					tagStr+='<tr class="ivu-table-row"><td class=""><div class="ivu-table-cell"><span>'+data[key].rollQty+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><span>'+data[key].nums+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><span>'+data[key].totalQty+'</span></div></td>';
					tagStr+='<td class=""><div class="ivu-table-cell"><div>';
					tagStr+='<button type="button" onclick="getRollNos('+'\''+partMap.qa_partNo+'\','+data[key].rollQty+')"'+' class="ivu-btn ivu-btn-primary ivu-btn-small"><span>明细</span></button>';
					tagStr+='</div></div></td></tr>';
				}
			tagStr+='</tbody></table></div></div></div></div>';
			$("#rollCounts").append(tagStr);
			//判断是否进去批量录入
			var cache_flag = $("#qa_cache").val();
			if('Y'==cache_flag){
				layer.confirm('确定批量自动录入卷号?',{
					btn:['确定','取消']
				},function(){
					batchInsert();
				});
			}
		},
		error : function(data) {
		}
	});
}
// 获取参数并且页面跳转
function getRollNos(partNo, nums){
	$.ajax({
		url : "/qa/sendRollParamter",
		type : "POST",
		data : {"partNo": partNo,"nums": nums},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.document.location.href="/pda/qa/rollNosPage"
			}else{
				layer.alert(data.msg);
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}
// 结束扫描
function endScan(passFlag){
	// 判断是否已经开启扫描
	var flag = $("#flag").val();
	var alert_data = "确定当前所有卷要进行判退处理！";
	if(passFlag == "Y"){
		alert_data = "确定当前所有卷要进行合格放行！";
	}
	if(flag=='Y'){
		layer.confirm(alert_data, {
			btn : [ '确认', '取消' ]
		// 按钮
		}, function() {
			layer.closeAll('dialog');
			endCurrentScan(passFlag);
		}, function() {
			clear();
			$("#rollNo").focus();
		});
	}else{
		layer.msg("当前暂无已扫描的卷号！");
	}
}
// 结束当前扫描操作
function endCurrentScan(passFlag){
	$.ajax({
		url : "/qa/endCurrentScan",
		type : "POST",
		data : {"passFlag": passFlag},
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/qaCheck"
				}, function() {
					layer.closeAll('dialog');
					window.document.location.href="/pda/qaCheck"
				});
			}else if(code=='500'){
				layer.confirm(data.msg, {
					btn : [ '确认', '取消' ]
				// 按钮
				}, function() {
					layer.closeAll('dialog');
				}, function() {
					layer.closeAll('dialog');
				});
			}else{
				var outData = data.obj;
				var outShow  = '状态有误的卷号：';
				for(var i = 0;i<outData.length;i++){
					outShow+=outData[i];
				}
				layer.msg(outShow);
			}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}
// 返回主界面清除缓存信息
function goBack(){
	layer.confirm("返回主界面将会删除当前扫描信息！！", {
		btn : [ '确认', '取消' ]
	// 按钮
	}, function() {
		layer.closeAll('dialog');
		goBackHome();
	}, function() {
		layer.closeAll('dialog');
	});
}
// 执行返回主界面清除缓存信息
function goBackHome(){
	var token ={
		"token":$.cookie("token")
	}
	$.ajax({
		url : "/qa/goBackHome",
		type : "POST",
		data : token,
		dataType : "json",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
		success : function(data) {
			var code = data.code;
			if(code=='200'){
				window.location.href = "/pda/publicMenu?titleName=''&menuId=0";
		}
		},
		error : function(data) {
			layer.alert(data.msg);
		}
	});
}
// 清楚信息
function clear(){
	$("#rollNo").val("");
}

//区间扫描方式模态框打开
function intervalScanModal(){
	//清楚数据
	$("#start_roll_no").val("");
	$("#end_roll_no").val("");
	$("#interval_roll_modal").modal();
}

//解决无法获取焦点的问题
$('#interval_roll_modal').on('shown.bs.modal', function () {
    $("#start_roll_no").focus();//获取焦点
});

//解决模态框隐藏获取焦点的问题
$('#interval_roll_modal').on('hidden.bs.modal', function () {
    $("#rollNo").focus();//获取焦点
});

//初始化enter录入
$(".scan-code").bind("keydown",function(event){
    if (event.keyCode == 13) {
    	//获取扫描的内容
    	scanText = $.trim($(this).val());
    	//获取当前的id
    	var scanId = $(this).attr("id");
  	  	if(null == scanText || scanText == ""){
  	  		layer.alert("扫码数据不能为空!");
  	  	}else{
  	  		//分别判断不同情况
  	  		if(scanId == "start_roll_no"){
  	  			//获取不同的焦点
  	  			$("#end_roll_no").focus();
  	  		}else{
  	  			$("#end_roll_no").blur();
  	  		}
  	  	}
    }
    return true;
});

//结束区间扫描
function endIntervalScan(){
	var startRollNo = $.trim($("#start_roll_no").val());
	var endRollNo = $.trim($("#end_roll_no").val());
	if('' == endRollNo || null == endRollNo){
		layer.alert('结束卷号不能为空!');
		return false;
	}
	$.ajax({
	    url: '/qa/endIntervalScan',
	    type:"POST",
	    data:{"site": '1',
	    	  "startRollNo": startRollNo,
	    	  "endRollNo": endRollNo},// 你的formid
	    dataType:"JSON",
		beforeSend: function(request) {
			 request.setRequestHeader("token", $.cookie("token"));
		},
	    success: function (data) {
	    	if(data.success){
	    		layer.msg(data.msg);
	    		$("#end_cancle").click();
	    		// 刷新页面
				window.document.location.href = "/pda/qaCheck";
	    	}else{
	    		layer.msg(data.msg);
	    	}
	    },
	    error: function(data) {
	    	var responseText = data.responseText;
	    	var json_str = JSON.parse(responseText);
	    	var status = json_str.status;
	    	var message = json_str.message;
	    	//判断是否是session超时
	    	if(403==status){
	    		layer.alert(message,function(){
	    			window.location.href="/login";
	    		});
	    	}
	    	layer.closeAll('loading');
	    }
	});
	
}
