var rollList = []
var rolls = []
// 获取扫描卷
function getRollInfo(rollNo) {
    let roll = {
        "rollno": rollNo,
      //  "statusDb": "I"
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/infoRollno",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                rollInfoData = data.cRollinfo;
                if (rollInfoData) {
                    if(rollInfoData.statusDb != 'I'){
                        layer.alert("该卷的状态为: "+rollInfoData.status);
                        $("#rollNo").val('');
                        $("#rollNo").focus();

                        return;
                    }
                    if (rollList.length > 0){
                        var partBool = rollList.some(item => item.partno === rollInfoData.partno)
                        if (!partBool){
                            layer.alert('不同物料的卷不能进行合并');
                            return
                        }
                    }
                    var rollBool = rollList.some(item => item.rollno === rollInfoData.rollno)
                    if (rollBool) {
                        layer.alert('该卷号已存在');
                        return
                    }
                    rollList.push(rollInfoData)
                    var str = '<tr id = ' + rollInfoData.rollno + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button  data-toggle="modal" onclick="removeRoll(\'' + rollInfoData.rollno + '\')" style="padding: 3px 10px;">' +
                        '删除</button>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + rollInfoData.rollno + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + rollInfoData.rollqty + '</span></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                    $("#rollno1").val('');
                    $("#rollno1").focus();
                } else {
                    layer.alert('该卷不存在');
                }
            } else {
                layer.alert('该卷不存在');
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 删除扫描内容
function removeRoll(rollNo) {
    $table = $("#roll_table tr");
    $("tr[id='" + rollNo + "']").remove();
    rollList = rollList.filter(item => item.rollno != rollNo)
    $("#rollno1").val('');
    $("#rollno1").focus();
}

//物料号bind 回车事件
$("#rollno1").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollno1").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
            return false;
        } else {
            getRollInfo(rollNo);
            $("#rollno1").val('');
            $("#rollno1").focus();
            return false;
        }
    }
    return true;
});


// 合卷
function joinRoll() {
    if (rollList.length < 2) {
        layer.alert("卷的数量要大于等2")
        return;
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/joinRoll",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollList),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            rollList = []
            if (data.code == 0) {
                $("#roll_join_table").html('');
                layer.alert("合卷成功")
                $('#rollno1').val('')
                $('#rollno1').focus()
                $("#roll_table").html('');
                rollList = []
                roll = data.newRoll
                rolls.push(data.newRoll)
                var str = '<tr id = ' + data.newRoll.rollno + '>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<span>' + data.newRoll.rollno + '</span></th>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<span>' + data.newRoll.rollqty + '</span></th>' +
                    '<th class="" style="text-align:center;background-color: #ffff;">' +
                    '<button   onclick="printRoll(\'' + data.newRoll.rollno + '\')" data-toggle="modal"  style="padding: 3px 10px;">' +
                    '打印标签</button></th>' +
                    '</tr>';
                $("#roll_join_table").append(str);
                print(data.newRoll)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}
function printRoll(){
    print(roll);
}

// 打印卷标签
function print(val){
    var rollPrintList = []
    rollPrintList.push(val)
    if (rollPrintList.length <= 0) {
        return;
    }
    $.ajax({
        url: "/finishedProduct/crollinfo/rollPrint",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(rollPrintList),
        dataType: "json",
        beforeSend: function (request) {
             request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            rollList = []
            if (data.code == 0) {
                layer.alert("打印成功")
                rollPrintList = []
            }else {
                layer.alert(data.msg)
            }

            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}







