//初始化
$(function () {

});

//卷号bind 回车事件
$("#rollNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var rollNo = $("#rollNo").val();
        if (null == rollNo || rollNo == "") {
            layer.alert("卷号不能为空!");
        } else {
            scannerRollNoList(rollNo);
            return false;
        }
    }
    return true;
});

//箱号号bind 回车事件
$("#boxNo").bind("keydown", function (event) {
    if (event.keyCode == 13) {
        var boxNo = $("#boxNo").val();
        if (null == boxNo || boxNo == "") {
            layer.alert("箱号不能为空!");
        } else {
            scannerBoxNoList(boxNo);
            return false;
        }
    }
    return true;
});

// 扫描卷移除操作
$('#scanRollNo').bind("keydown",(event)=>{
    if (event.keyCode == 13) {
        var scanRollNo = $("#scanRollNo").val();
        if (null == scanRollNo || scanRollNo == "") {
            layer.alert("扫描卷号不能为空!");
        } else {
            removeBoxRoll(scanRollNo);
            return false;
        }
    }
    return true;
})

function scannerRollNoList(rollNo) {
    let roll = {
        "finalRollNo": rollNo
    }
    $.ajax({
        url: "/soBoxing/boxScanRollList",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                $("#roll_table").html('')
                $('#boxNoView').val(data.boxNo)
                $('#boxQty').val(data.boxNumber)
                $('#itemCode').val(data.itemCode)
                $('#orderNo').val(data.orderNo)
                var rollInfoData = data.rollList
                rollInfoData.forEach( item => {
                    var str = '<tr id = ' + item.rollNo + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button  data-toggle="modal" onclick="removeBoxRoll(\'' + item.finalRollNo + '\')" style="padding: 3px 10px;">' +
                        '移除</button>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.finalRollNo + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollQty + '</span></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                })
            }
            if (data.code == 500) {
                layer.alert(data.msg);
                $("#roll_table").html('')
                $('#boxNoView').val('')
                $('#boxQty').val('')
                $("#rollNo").val('')
                $("#orderNo").val('')
                $("#itemCode").val('')
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

function scannerBoxNoList(boxNo) {
    let roll = {
        "boxNo": boxNo
    }
    $.ajax({
        url: "/soBoxing/boxScanBoxNoList",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(roll),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                $("#roll_table").html('')
                $('#boxNoView').val(data.boxNo)
                $('#boxQty').val(data.boxNumber)
                $('#itemCode').val(data.itemCode)
                $('#orderNo').val(data.orderNo)
                var rollInfoData = data.rollList
                rollInfoData.forEach( item => {
                    var str = '<tr id = ' + item.rollNo + '>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<button  data-toggle="modal" onclick="removeBoxRoll(\'' + item.finalRollNo + '\')" style="padding: 3px 10px;">' +
                        '移除</button>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.finalRollNo + '</span></th>' +
                        '<th class="" style="text-align:center;background-color: #ffff;">' +
                        '<span>' + item.rollQty + '</span></th>' +
                        '</tr>';
                    $("#roll_table").append(str);
                })
            }
            if (data.code == 500) {
                layer.alert(data.msg);
                $("#roll_table").html('')
                $('#boxNoView').val('')
                $('#boxQty').val('')
                $("#rollNo").val('')
                $("#orderNo").val('')
                $("#itemCode").val('')
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 打开扫描框
function openScanModal() {
    $('#scanRollNoModal').modal();
}

// 把卷从箱里拿出来
function removeBoxRoll(rollNo){
    layer.confirm( '是否移除该卷', {
        btn: ['确定', '取消']
        // 按钮
    }, function () {
        // 移除卷
        let roll = {
            "finalRollNo": rollNo
        }
        $.ajax({
            url: "/soBoxing/splitBoxRoll",
            contentType: 'application/json',
            type: "POST",
            data: JSON.stringify(roll),
            dataType: "json",
            beforeSend: function (request) {
                request.setRequestHeader("token", $.cookie("token"));
            },
            success: function (data) {
                if (data.code == 0) {
                    layer.alert("移除卷成功")
                    $('#scanRollNo').val('')
                    scannerBoxNoList($('#boxNoView').val())
                }
                if (data.code == 500) {
                    layer.alert(data.msg);
                }
                if (data.code == 401) {
                    layer.alert('用户身份已过期');
                    window.location.href = "/login"
                }
            },
            error: function (data) {
            }
        });
    },function () {

    })

}

// 移除箱
function removeBox(){
    var boxNo = $('#boxNoView').val();
    if (!boxNo){
        layer.alert('请先获取箱号,可以通过扫描卷号获取')
        return
    }
    layer.confirm( '是否移除该箱', {
        btn: ['确定', '取消']
        // 按钮
    },  ()=> {
        let box = {
            boxNo: boxNo
        }
        $.ajax({
            url: "/soBoxing/removeBox",
            contentType: 'application/json',
            type: "POST",
            data: JSON.stringify(box),
            dataType: "json",
            beforeSend: function (request) {
                request.setRequestHeader("token", $.cookie("token"));
            },
            success: function (data) {
                if (data.code == 0) {
                    layer.alert(data.msg);
                }
                if (data.code == 500) {
                    layer.alert(data.msg);
                }
                if (data.code == 401) {
                    layer.alert('用户身份已过期');
                    window.location.href = "/login"
                }
                $("#roll_table").html('')
                $('#boxNoView').val('')
                $('#boxQty').val('')
                $("#rollNo").val('')
            },
            error: function (data) {
            }
        });
    },()=>{})
}


// 打开装箱模态框
function boxingModal() {
   var partNo = $('#itemCode').val()
    getCustomerId(partNo)
    $('#printFile').modal()
}

// 更具拣配单号 获取 客户编号
function getCustomerId(partNo) {
    let picking = {
        partNo: partNo
    }
    $.ajax({
        url: "/packing/getCustomerId",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(picking),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                getPrintFile(data.customerId)

            }

            if (data.code == 500) {
                layer.alert(data.msg)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}

// 获取根据客户编号 获取装配打印模板
function getPrintFile(customerId) {
    let customer = {
        customerId: customerId,
        reportFamily: '外箱标签'
    }
    $.ajax({
        url: "/packing/getReportFileListByCustomerId",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(customer),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                $('#reoprtId').html('')
                let reportList = data.reportFileVos
                let reportHtml = ''
                reportList.forEach((item, index) => {
                    reportHtml += '<option label=' + item.reportFileVo + ' value=' + item.reportIdVo + '>' +
                        '</option>';
                })
                $('#reoprtId').append(reportHtml)
            }

            if (data.code == 500) {
                layer.alert(data.msg)
            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
        },
        error: function (data) {
        }
    });
}


// 装箱完成调用打印
function pickingPrint() {
    $("#box_print").attr("disabled",true);
    var reoprt = $('#reoprtId').val();
    var split = reoprt.split(":");
    var reportFile = split[2]
    var reportId = split[1]
    var isCustomer = split[0]
    //var reportFile =  reoprt.substr(reoprt.indexOf(":")+1)
    // var reportId =  reoprt.substr(0,reoprt.indexOf(":"))
    let reportFileVo = {
        reportId: reportId,
        reportFile: reportFile,
        orderNo: $("#orderNo").val(),
        partNo: $('#itemCode').val(),
        pickingNumber: $('#boxQty').val(),
        isCustomer: isCustomer,
        boxNo: $('#boxNoView').val()
    }


    $.ajax({
        url: "/packing/printPacking",
        contentType: 'application/json',
        type: "POST",
        data: JSON.stringify(reportFileVo),
        dataType: "json",
        beforeSend: function (request) {
            request.setRequestHeader("token", $.cookie("token"));
        },
        success: function (data) {
            if (data.code == 0) {
                layer.alert(data.msg)
                $("#box_close").click();
                $("#rollNo").val('');
                $("#rollNo").focus();
            }
            if (data.code == 500) {
                layer.alert(data.msg)

            }
            if (data.code == 401) {
                layer.alert('用户身份已过期');
                window.location.href = "/login"
            }
            $("#box_print").attr("disabled",false);
        },
        error: function (data) {
        }
    });
}